/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BasePrintTemplateRemote;
import com.zkteco.zkbiosecurity.system.service.BasePrintTemplateService;
import com.zkteco.zkbiosecurity.system.vo.BasePrintTemplateItem;
import com.zkteco.zkbiosecurity.system.vo.SystemAttributeInfoItem;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BasePrintTemplateController
extends BaseController
implements BasePrintTemplateRemote {
    @Autowired
    private BasePrintTemplateService basePrintTemplateService;

    @RequiresPermissions(value={"system:printTemplate"})
    public ModelAndView index() {
        return new ModelAndView("system/basePrintTemplate/basePrintTemplate");
    }

    @RequiresPermissions(value={"system:printTemplate:refresh"})
    public DxGrid list(BasePrintTemplateItem condition) {
        Pager pager = this.basePrintTemplateService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="system_module", object="base_leftMenu_printTemplateManagement", opType="common_op_edit", requestParams={"name", "moduleCode"}, opContent="base_leftMenu_printTemplateManagement")
    @RequiresPermissions(value={"system:printTemplate:edit", "system:printTemplate:add"})
    public ZKResultMsg savePrintTemplate(BasePrintTemplateItem item) {
        return new ZKResultMsg((Object)this.basePrintTemplateService.saveTemplate(item));
    }

    @RequiresPermissions(value={"system:printTemplate:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        BasePrintTemplateItem basePrintTemplateItem = new BasePrintTemplateItem();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            basePrintTemplateItem = this.basePrintTemplateService.getItemById(id);
        } else {
            basePrintTemplateItem.setModuleCode("pers");
        }
        this.request.setAttribute("item", (Object)basePrintTemplateItem);
        this.request.setAttribute("moduleMap", (Object)this.basePrintTemplateService.getModuleMap());
        return new ModelAndView("system/basePrintTemplate/editBasePrintTemplate");
    }

    public String validTemplateName(@RequestParam(value="name") String name) {
        BasePrintTemplateItem item = this.basePrintTemplateService.getItemByName(name);
        boolean rs = item == null;
        return String.valueOf(rs);
    }

    @LogRequest(module="system_module", object="base_leftMenu_printTemplateManagement", opType="common_op_del", requestParams={"names", "moduleCodes"}, opContent="base_leftMenu_printTemplateManagement")
    @RequiresPermissions(value={"system:printTemplate:del"})
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        BasePrintTemplateItem item = new BasePrintTemplateItem();
        item.setInitFlag(Boolean.valueOf(true));
        List items = this.basePrintTemplateService.getByCondition(item);
        String[] idStr = ids.split(",");
        int len = idStr.length;
        ArrayList<String> idsList = new ArrayList<String>();
        idsList.addAll(Arrays.asList(idStr));
        for (BasePrintTemplateItem templateItem : items) {
            idsList.remove(templateItem.getId());
        }
        if (len > idsList.size()) {
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"common_prompt_initDataCanNotDel", (Object[])new Object[0]));
        }
        this.basePrintTemplateService.deleteByIds(StringUtils.join(idsList, (String)","));
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"system:printTemplate:preview"})
    public ModelAndView preview(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.basePrintTemplateService.getItemById(id));
        }
        return new ModelAndView("system/basePrintTemplate/previewPrintTemplate");
    }

    public ZKResultMsg getPrintTemplateByModule(@RequestParam(value="moduleCode", required=false) String moduleCode) {
        List basePrintTemplateItems = this.basePrintTemplateService.getItemsByModuleCode(moduleCode);
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (BasePrintTemplateItem basePrintTemplateItem : basePrintTemplateItems) {
            SelectItem selectItem = new SelectItem();
            selectItem.setValue(basePrintTemplateItem.getId());
            selectItem.setText((Object)basePrintTemplateItem.getName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public ZKResultMsg getItemById(@RequestParam(value="id") String id) {
        BasePrintTemplateItem item = this.basePrintTemplateService.getItemById(id);
        return new ZKResultMsg((Object)item);
    }

    public ZKResultMsg saveImages(@RequestParam(value="opImage", required=false) MultipartFile opImage, @RequestParam(value="bgImage", required=false) MultipartFile bgImage) {
        HashMap<String, Object> imgData = new HashMap<String, Object>();
        try {
            if (opImage != null || bgImage != null) {
                String newImage = String.valueOf(System.currentTimeMillis()) + ".jpg";
                String templateImgPath = null;
                if (opImage != null) {
                    templateImgPath = FileUtil.saveFileToServer((String)"base", (String)"printTemplate/images", (String)newImage, (MultipartFile)opImage);
                }
                if (bgImage != null) {
                    templateImgPath = FileUtil.saveFileToServer((String)"base", (String)"printTemplate/bgImgs", (String)newImage, (MultipartFile)bgImage);
                }
                File outputfile = new File(FileUtil.getLocalFullPath((String)templateImgPath));
                FileInputStream fileInputStream = new FileInputStream(outputfile);
                BufferedImage sourceImg = ImageIO.read(fileInputStream);
                imgData.put("imgUrl", templateImgPath);
                imgData.put("width", sourceImg.getWidth());
                imgData.put("height", sourceImg.getHeight());
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg(imgData));
    }

    public ZKResultMsg delImages(String filePath) {
        FileUtil.deleteFile((String)FileUtil.getLocalFullPath((String)filePath));
        FileUtil.deleteFile((String)FileUtil.getLocalFullPath((String)FileUtil.getThumbPath((String)filePath)));
        return new ZKResultMsg();
    }

    public ModelAndView selectPersAttribute() {
        this.request.setAttribute("infoItems", (Object)this.basePrintTemplateService.getSystemAttributeInfoItemList());
        return new ModelAndView("system/basePrintTemplate/opSelectDataMore");
    }

    public ZKResultMsg getPersAttributes() {
        List systemAttributeInfoItemList = this.basePrintTemplateService.getSystemAttributeInfoItemList();
        for (SystemAttributeInfoItem systemAttributeInfoItem : systemAttributeInfoItemList) {
            if (!"init".equals(systemAttributeInfoItem.getSqlStr())) continue;
            systemAttributeInfoItem.setAttrName(I18nUtil.i18nCode((String)systemAttributeInfoItem.getAttrName(), (Object[])new Object[0]));
        }
        return new ZKResultMsg((Object)systemAttributeInfoItemList);
    }
}

