/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.app.service.BaseAuthCloudMessageSendService;
import com.zkteco.zkbiosecurity.system.remote.BaseParamSettingRemote;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.service.ModuleInfoService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseParamSettingController
extends BaseController
implements BaseParamSettingRemote {
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Value(value="${system.customDateFormat:false}")
    private Boolean customDateFormat;
    @Value(value="${system.securityLevel:0}")
    private int securityLevel;
    @Autowired
    private BaseAuthCloudMessageSendService baseAuthCloudMessageSendService;
    @Autowired
    private ModuleInfoService moduleInfoService;

    @RequiresPermissions(value={"system:param:setting"})
    public ModelAndView index() {
        Map qrCodeMap = this.baseSysParamService.getParamsByModule("qrcode");
        this.request.setAttribute("qrCodeMap", (Object)qrCodeMap);
        if (this.customDateFormat.booleanValue()) {
            Map fmtMap = this.baseSysParamService.getParamsByModule("system.fmt");
            if (fmtMap.size() == 0) {
                this.initFmtParams();
            }
            this.request.setAttribute("fmtMap", (Object)fmtMap);
        }
        Map systemPlugin = this.baseSysParamService.getParamsByModule("system.plugin");
        this.request.setAttribute("systemPlugin", (Object)systemPlugin);
        HashMap<String, String> systemData = new HashMap<String, String>();
        boolean existIvs = this.moduleInfoService.isExistModuleByCode("ivs");
        String showIvs = existIvs ? "1" : "0";
        systemData.put("showIvs", showIvs);
        systemData.put("protection", this.baseSysParamService.getValByName("system.data.protection"));
        String isShow = this.securityLevel > 0 ? "1" : "0";
        systemData.put("isShow", isShow);
        this.request.setAttribute("systemData", systemData);
        Map systemEntryMap = this.baseSysParamService.getParamsByModule("systemEntry");
        this.request.setAttribute("systemEntryMap", (Object)systemEntryMap);
        this.request.setAttribute("systemPrivacy", (Object)this.baseSysParamService.getValByName("system.privacy"));
        return new ModelAndView("system/param/baseParamSetting");
    }

    private void initFmtParams() {
        BaseSysParamItem item = new BaseSysParamItem("system.fmt.date", "YYYY_MM_DD", "Custom Date Format");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("system.fmt.time", "HH_MM_SS", "Custom Time Format");
        this.baseSysParamService.initData(item);
    }

    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        this.baseSysParamService.saveParams(params);
        this.baseAuthCloudMessageSendService.syncSysParamToCloud();
        ZKResultMsg ret = I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
        if (this.customDateFormat.booleanValue()) {
            String dateFmt = params.get("system.fmt.date");
            String timeFmt = params.get("system.fmt.time");
            DateUtil.CustomDateStyle d = DateUtil.CustomDateStyle.valueOf((String)dateFmt);
            DateUtil.CustomDateStyle t = DateUtil.CustomDateStyle.valueOf((String)timeFmt);
            ServletContext context = this.request.getServletContext();
            context.setAttribute("date.dhxDateFmt", (Object)d.getDhxFmt());
            context.setAttribute("date.dhxTimeFmt", (Object)t.getDhxFmt());
            context.setAttribute("biosecurity.date.sysDateFmt.alias", (Object)d.getJavaFmt());
            context.setAttribute("biosecurity.date.sysTimeFmt.alias", (Object)t.getJavaFmt());
            context.setAttribute("biosecurity.date.sysDateTimeFmt.alias", (Object)(String.valueOf(d.getJavaFmt()) + " " + t.getJavaFmt()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dhxDate", d.getDhxFmt());
            map.put("dhxTime", t.getDhxFmt());
            ret.setData(map);
        }
        return ret;
    }

    public ZKResultMsg importPrivacyTxt(@RequestParam(value="importPrivacy", required=false) MultipartFile upload) {
        if (Objects.nonNull(upload) && !upload.isEmpty()) {
            if (upload.getOriginalFilename().toLowerCase().matches(".*?(txt)$")) {
                String txtPath = FileUtil.saveFileToServer((String)"base", (String)"privacy", (String)"customPrivacy.txt", (MultipartFile)upload);
                String oldTxtPath = this.baseSysParamService.getValByName("system.privacy.txtPath");
                if (StringUtils.isNotBlank((CharSequence)oldTxtPath) && !oldTxtPath.equals(txtPath)) {
                    FileUtil.deleteFile((String)oldTxtPath);
                }
                this.baseSysParamService.saveValueByName("system.privacy.txtPath", txtPath);
                return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
            }
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"auth_license_fileIncorrectFormat"));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"pers_import_selectCorrectFile"));
    }

    public ModelAndView viewPrivacyTxt() {
        String privacyVal = this.request.getParameter("privacyVal");
        String txtValue = this.baseSysParamService.getPrivacyContent(privacyVal);
        this.request.setAttribute("txtValue", (Object)txtValue);
        return new ModelAndView("system/param/viewPrivacyTxt");
    }
}

