/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseOpLogRemote;
import com.zkteco.zkbiosecurity.system.service.BaseOpLogService;
import com.zkteco.zkbiosecurity.system.vo.BaseOpLogItem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseOpLogController
extends ExportController
implements BaseOpLogRemote {
    private static final Logger log = LoggerFactory.getLogger(BaseOpLogController.class);
    @Autowired
    private BaseOpLogService baseOpLogService;

    @RequiresPermissions(value={"system:opLog"})
    public ModelAndView index() {
        return new ModelAndView("system/opLog/baseOpLog");
    }

    @RequiresPermissions(value={"system:opLog:refresh"})
    public DxGrid list(BaseOpLogItem condition) {
        long limit = this.getLimitCount();
        Pager pager = this.baseOpLogService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"system:opLog:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        BaseOpLogItem baseOpLogItem = new BaseOpLogItem();
        this.setConditionValue((BaseItem)baseOpLogItem);
        int beginIndex = this.getBeginIndex();
        int endIndex = this.getEndIndex();
        List itemList = this.baseOpLogService.getItemData(request.getSession().getId(), BaseOpLogItem.class, baseOpLogItem, beginIndex, endIndex);
        this.excelExport(itemList, BaseOpLogItem.class);
    }

    @RequiresPermissions(value={"system:opLog:view"})
    public ModelAndView logView() {
        try {
            this.request.setAttribute("content", (Object)this.baseOpLogService.getLogView("info"));
            this.request.setAttribute("warnContent", (Object)this.baseOpLogService.getLogView("warn"));
            this.request.setAttribute("errorContent", (Object)this.baseOpLogService.getLogView("error"));
        }
        catch (Exception e) {
            log.error("encode error : {}", (Object)e.getMessage());
        }
        return new ModelAndView("system/opLog/opLogView");
    }

    @RequiresPermissions(value={"system:opLog:download"})
    public void download() {
        block15: {
            BufferedInputStream bis = null;
            try {
                try {
                    String[] filePath;
                    String tempPath = String.valueOf(System.getProperty("user.dir")) + File.separator + "logs" + File.separator + "zkbiosecurity-log" + "." + "zip";
                    ArrayList<File> files = new ArrayList<File>();
                    String[] stringArray = filePath = new String[]{"info", "warn", "error"};
                    int n = filePath.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        String fileName = this.getFilePath(key);
                        File file = new File(fileName);
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        files.add(file);
                        ++n2;
                    }
                    this.response = FileUtil.downLoadFiles((String)tempPath, (File[])((File[])files.stream().toArray(File[]::new)), (HttpServletRequest)this.request, (HttpServletResponse)this.response);
                    this.response.flushBuffer();
                    File zipTempFile = new File(tempPath);
                    if (zipTempFile.exists()) {
                        zipTempFile.delete();
                    }
                }
                catch (Exception e) {
                    log.error("download error : ", (Throwable)e);
                    if (bis == null) break block15;
                    try {
                        bis.close();
                    }
                    catch (IOException e2) {
                        log.error("close file error : ", (Throwable)e2);
                    }
                }
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        log.error("close file error : ", (Throwable)e);
                    }
                }
            }
        }
    }

    private String getFilePath(String prefix) {
        String filePath = String.valueOf(System.getProperty("user.dir")) + File.separator + "logs" + File.separator + "zkbiosecurity-" + prefix + ".log";
        return filePath;
    }
}

