/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseMessageNotificationRemote;
import com.zkteco.zkbiosecurity.system.service.BaseDataCleanService;
import com.zkteco.zkbiosecurity.system.service.BaseMessageNotificationService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseMessageNotificationController
extends BaseController
implements BaseMessageNotificationRemote {
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseDataCleanService baseDataCleanService;
    @Autowired
    private BaseMessageNotificationService baseMessageNotificationService;
    @Autowired
    private BaseLicenseProvider baseLicenseProvider;

    @RequiresPermissions(value={"system:message:notification"})
    public ModelAndView getParam() {
        boolean serverLicense = "ZKBioCVSecurityFoundation".equals(this.baseLicenseProvider.getProductCode()) || "ZKBioCVServerV6000".equals(this.baseLicenseProvider.getProductCode());
        boolean accPushLicense = this.baseLicenseProvider.isModuleLicensed("push");
        boolean accPullLicense = this.baseLicenseProvider.isModuleLicensed("pull");
        boolean accLicense = accPullLicense || accPushLicense || serverLicense;
        boolean psgLicense = this.baseLicenseProvider.isModuleLicensed("psg") != false || serverLicense;
        boolean lockerLicense = this.baseLicenseProvider.isModuleLicensed("locker") != false || serverLicense;
        boolean attLicense = this.baseLicenseProvider.isModuleLicensed("att") != false || serverLicense;
        BaseSysParamItem params = new BaseSysParamItem();
        params.setParamName("MessageNotification");
        List tempItems = this.baseSysParamService.getByCondition(params);
        ArrayList<BaseSysParamItem> items = new ArrayList<BaseSysParamItem>();
        for (BaseSysParamItem item : tempItems) {
            if (accLicense && "accMessageNotification".equals(item.getParamName())) {
                items.add(item);
                continue;
            }
            if (psgLicense && "psgMessageNotification".equals(item.getParamName())) {
                items.add(item);
                continue;
            }
            if (lockerLicense && "lockerMessageNotification".equals(item.getParamName())) {
                items.add(item);
                continue;
            }
            if (!attLicense || !"attMessageNotification".equals(item.getParamName())) continue;
            items.add(item);
        }
        boolean showSMS = this.baseMessageNotificationService.checkSmsModuleLicense();
        boolean showWhatsapp = this.baseMessageNotificationService.checkShowWhatsappLicense();
        this.request.setAttribute("showSMS", (Object)showSMS);
        this.request.setAttribute("showWhatsapp", (Object)showWhatsapp);
        this.request.setAttribute("items", items);
        return new ModelAndView("system/messageNotification/baseMessageNotification");
    }

    @RequiresPermissions(value={"system:message:notification"})
    @LogRequest(module="base_module", object="base_leftMenu_messageNotification", opType="base_leftMenu_messageNotification", opContent="base_leftMenu_messageNotification")
    public ZKResultMsg saveParam(Map<String, String> params) {
        HashMap<String, String> newParams = new HashMap<String, String>();
        BaseSysParamItem param = new BaseSysParamItem();
        param.setParamName("MessageNotification");
        List items = this.baseSysParamService.getByCondition(param);
        for (BaseSysParamItem item : items) {
            JSONObject json = JSON.parseObject((String)item.getParamValue());
            if (params.containsKey(String.valueOf(item.getParamName()) + "Email")) {
                json.put("Email", (Object)params.get(String.valueOf(item.getParamName()) + "Email"));
            }
            if (params.containsKey(String.valueOf(item.getParamName()) + "SMS")) {
                json.put("SMS", (Object)params.get(String.valueOf(item.getParamName()) + "SMS"));
            }
            if (params.containsKey(String.valueOf(item.getParamName()) + "Whatsapp")) {
                json.put("Whatsapp", (Object)params.get(String.valueOf(item.getParamName()) + "Whatsapp"));
            }
            newParams.put(item.getParamName(), json.toString());
        }
        if (!newParams.isEmpty()) {
            this.baseSysParamService.saveParams(newParams);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

