/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseLanguageResourceRemote;
import com.zkteco.zkbiosecurity.system.service.BaseLanguageResourceService;
import com.zkteco.zkbiosecurity.system.service.BaseLanguageService;
import com.zkteco.zkbiosecurity.system.utils.BaseLanguageUtil;
import com.zkteco.zkbiosecurity.system.vo.BaseLanguageItem;
import com.zkteco.zkbiosecurity.system.vo.BaseLanguageResourceItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseLanguageResourceController
extends BaseController
implements BaseLanguageResourceRemote {
    @Autowired
    private BaseLanguageResourceService baseLanguageResourceService;
    @Autowired
    private BaseLanguageService baseLanguageService;
    @Value(value="${system.language:zh_CN}")
    private String defalutLanguage;

    public ModelAndView index() {
        return new ModelAndView("system/baseLanguageResource/baseLanguageResource");
    }

    @RequiresPermissions(value={"system:baseLanguageResource:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.baseLanguageResourceService.getItemById(id));
        }
        return new ModelAndView("system/baseLanguageResource/editBaseLanguageResource");
    }

    public ZKResultMsg save(BaseLanguageResourceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.baseLanguageResourceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(BaseLanguageResourceItem condition) {
        Pager pager = this.baseLanguageResourceService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg del(String ids) {
        this.baseLanguageResourceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"system:baseLanguageResource:loadModuleLangResource"})
    public ModelAndView loadModuleLangResource() {
        String moduleCode = this.request.getParameter("moduleCode");
        String languageIds = this.request.getParameter("languageIds");
        BaseLanguageItem languageItem = new BaseLanguageItem();
        languageItem.setLanguageId(languageIds);
        List languageItems = this.baseLanguageService.getByCondition(languageItem);
        ArrayList<BaseLanguageItem> langSet = new ArrayList<BaseLanguageItem>();
        ArrayList<BaseLanguageItem> langList = new ArrayList<BaseLanguageItem>();
        for (BaseLanguageItem baseLanguageItem : languageItems) {
            baseLanguageItem.setI18nName(BaseLanguageUtil.transformCode((String)baseLanguageItem.getCode(), (String)this.defalutLanguage));
            if (baseLanguageItem.getCode().equals("zh_CN")) {
                langList.add(baseLanguageItem);
                continue;
            }
            langSet.add(baseLanguageItem);
        }
        langList.addAll(langSet);
        this.request.setAttribute("langList", langList);
        this.request.setAttribute("languageIds", (Object)languageIds);
        this.request.setAttribute("moduleCode", (Object)moduleCode);
        BaseLanguageResourceItem item = new BaseLanguageResourceItem();
        item.setInLanguageId(languageIds);
        item.setModuleCode(moduleCode);
        List items = this.baseLanguageResourceService.getByCondition(item);
        HashMap<String, String> langResContentMap = new HashMap<String, String>();
        ArrayList<String> langResKeyList = new ArrayList<String>();
        for (BaseLanguageResourceItem baseLanguageResourceItem : items) {
            langResContentMap.put(String.valueOf(baseLanguageResourceItem.getLanguageCode()) + "_" + baseLanguageResourceItem.getName(), baseLanguageResourceItem.getContent());
            if (!baseLanguageResourceItem.getLanguageCode().equals("zh_CN")) continue;
            langResKeyList.add(baseLanguageResourceItem.getName());
        }
        this.request.setAttribute("langResKeyList", langResKeyList);
        this.request.setAttribute("langResContentMap", langResContentMap);
        return new ModelAndView("system/baseLanguageResourceStatistic/editBaseLanguageResource");
    }

    @RequiresPermissions(value={"system:baseLanguageResource:saveChangedLangRes"})
    public ZKResultMsg saveChangedLangRes() {
        JSONArray obj = JSONArray.parseArray((String)this.request.getParameter("languageResources"));
        ArrayList<BaseLanguageResourceItem> items = new ArrayList<BaseLanguageResourceItem>();
        int i = 0;
        while (i < obj.size()) {
            BaseLanguageResourceItem item = (BaseLanguageResourceItem)JSONObject.parseObject((String)obj.getString(i), BaseLanguageResourceItem.class);
            items.add(item);
            ++i;
        }
        this.baseLanguageResourceService.saveChangedLangRes(items);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

