/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseLanguageRemote;
import com.zkteco.zkbiosecurity.system.service.BaseLanguageResourceService;
import com.zkteco.zkbiosecurity.system.service.BaseLanguageService;
import com.zkteco.zkbiosecurity.system.utils.BaseLanguageUtil;
import com.zkteco.zkbiosecurity.system.utils.BaseMediaFileUtil;
import com.zkteco.zkbiosecurity.system.vo.BaseLanguageItem;
import com.zkteco.zkbiosecurity.system.vo.BaseLanguageResourceStatisticItem;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseLanguageController
extends BaseController
implements BaseLanguageRemote {
    @Autowired
    private BaseLanguageService baseLanguageService;
    @Autowired
    private BaseLanguageResourceService baseLanguageResourceService;
    @Value(value="${system.language:zh_CN}")
    private String defalutLanguage;

    @RequiresPermissions(value={"system:baseLanguage"})
    public ModelAndView index() {
        List locales = BaseLanguageUtil.getAllLanguage();
        ArrayList<BaseLanguageItem> baseLanguageItemList = new ArrayList<BaseLanguageItem>();
        for (Locale locale : locales) {
            BaseLanguageItem item = new BaseLanguageItem();
            String localeStr = locale.toString();
            if (localeStr != null && localeStr.length() != 0) {
                item.setI18nName(BaseLanguageUtil.transformCode((String)localeStr, (String)this.defalutLanguage));
                item.setCode(localeStr);
            }
            baseLanguageItemList.add(item);
        }
        BaseLanguageItem zhCNItem = this.baseLanguageService.findByCode("zh_CN");
        this.request.setAttribute("zhchItem", (Object)zhCNItem);
        this.request.setAttribute("allLanguage", baseLanguageItemList);
        return new ModelAndView("system/baseLanguage/baseLanguage");
    }

    @RequiresPermissions(value={"system:baseLanguage:edit"})
    public ModelAndView edit(String id) {
        List baseLanguageItemList = this.baseLanguageService.getAllLanguage();
        this.request.setAttribute("allLanguage", (Object)baseLanguageItemList);
        return new ModelAndView("system/baseLanguage/editBaseLanguage");
    }

    @RequiresPermissions(value={"system:baseLanguage:edit"})
    public ZKResultMsg save(BaseLanguageItem item) {
        String newLanguage = this.request.getParameter("newLanguage");
        item.setBuildInFlag(Boolean.valueOf(false));
        item.setCode(newLanguage);
        this.baseLanguageService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"system:baseLanguage:refresh"})
    public DxGrid list(BaseLanguageItem condition) {
        Pager pager = this.baseLanguageService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"system:baseLanguage:del"})
    public ZKResultMsg del(String ids) {
        this.baseLanguageService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"system:baseLanguage:downloadResource"})
    public void downloadResource() {
        try {
            String langId = this.request.getParameter("id");
            BaseLanguageItem languageItem = this.baseLanguageService.getItemById(langId);
            String currentPath = String.valueOf(ClassUtil.getRootPath()) + "/local/" + languageItem.getCode() + "/";
            Map newLanguageMap = this.baseLanguageService.getNewLanguageProperties(langId);
            for (String code : newLanguageMap.keySet()) {
                BaseMediaFileUtil.writeStringToFile(new File(String.valueOf(currentPath) + code + "_" + languageItem.getCode() + ".properties"), (String)newLanguageMap.get(code), "UTF-8");
            }
            File file = new File(currentPath);
            FileUtil.downLoadFiles((String)(String.valueOf(currentPath) + languageItem.getCode() + ".zip"), (File[])file.listFiles(), (HttpServletRequest)this.request, (HttpServletResponse)this.response);
            FileUtil.deleteDirectory((String)currentPath);
        }
        catch (Exception e) {
            throw new ZKBusinessException();
        }
    }

    @RequiresPermissions(value={"system:baseLanguage:contrast"})
    public ModelAndView contrast(String languageIds) {
        BaseLanguageItem zhCNItem = this.baseLanguageService.findByCode("zh_CN");
        zhCNItem.setI18nName(BaseLanguageUtil.transformCode((String)"zh_CN", (String)this.defalutLanguage));
        HashMap map = new HashMap();
        HashMap<String, Long> zhcnMap = new HashMap<String, Long>();
        BaseLanguageResourceStatisticItem statisticItem = new BaseLanguageResourceStatisticItem();
        statisticItem.setInLanguageId(languageIds);
        List items = this.baseLanguageResourceService.getResourceStatisticByCondition(statisticItem);
        ArrayList<BaseLanguageItem> langSet = new ArrayList<BaseLanguageItem>();
        ArrayList<String> temps = new ArrayList<String>();
        for (BaseLanguageResourceStatisticItem item : items) {
            if (item.getLangCode().equals("zh_CN")) {
                zhcnMap.put(item.getModuleCode(), item.getFinishedQuantity());
            } else if (!temps.contains(item.getLangCode())) {
                BaseLanguageItem tempLang = this.baseLanguageService.findByCode(item.getLangCode());
                tempLang.setI18nName(BaseLanguageUtil.transformCode((String)item.getLangCode(), (String)this.defalutLanguage));
                langSet.add(tempLang);
                temps.add(item.getLangCode());
            }
            HashMap<String, Long> temp = (HashMap<String, Long>)map.get(item.getModuleCode());
            if (temp == null) {
                temp = new HashMap<String, Long>();
            }
            if (item.getModuleCode() == null) continue;
            temp.put(item.getLangCode(), item.getFinishedQuantity());
            map.put(item.getModuleCode(), temp);
        }
        temps = null;
        ArrayList<BaseLanguageItem> langList = new ArrayList<BaseLanguageItem>();
        langList.add(zhCNItem);
        langList.addAll(langSet);
        this.request.setAttribute("langList", langList);
        this.request.setAttribute("langMap", map);
        this.request.setAttribute("languageIds", (Object)languageIds);
        return new ModelAndView("system/baseLanguageResourceStatistic/baseLanguageResourceStatistic");
    }

    @RequiresPermissions(value={"system:baseLanguage:preview"})
    public ZKResultMsg preview(String id) {
        try {
            BaseLanguageItem languageItem = this.baseLanguageService.getItemById(id);
            String currentPath = String.valueOf(ClassUtil.getRootPath()) + "/local/";
            Map newLanguageMap = this.baseLanguageService.getNewLanguageProperties(id);
            for (String code : newLanguageMap.keySet()) {
                BaseMediaFileUtil.writeStringToFile(new File(String.valueOf(currentPath) + code + "_" + languageItem.getCode() + ".properties"), (String)newLanguageMap.get(code), "UTF-8");
            }
            this.baseLanguageService.previewLanguage(languageItem.getCode());
        }
        catch (Exception e) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

