/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.auth.provider.AuthSessionProvider;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.base.utils.SystemOsUtil;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseDbBackupRemote;
import com.zkteco.zkbiosecurity.system.service.BaseDbBackupService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.utils.ApacheFtpUtil;
import com.zkteco.zkbiosecurity.system.vo.BaseDbBackupItem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseDbBackupController
extends ExportController
implements BaseDbBackupRemote {
    @Autowired
    private BaseDbBackupService baseDbBackupService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;
    @Autowired
    private AuthSessionProvider authSessionProvider;

    @RequiresPermissions(value={"system:baseDbBackup"})
    public ModelAndView index() {
        this.request.setAttribute("dbBackupIsWindow", (Object)String.valueOf(SystemOsUtil.isWindow()));
        return new ModelAndView("system/baseDbBackup/baseDbBackup");
    }

    @RequiresPermissions(value={"system:baseDbBackup:refresh"})
    public DxGrid list(BaseDbBackupItem condition) {
        Pager pager = this.baseDbBackupService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"system:baseDbBackup:del"})
    @LogRequest(module="system_module", object="base_leftMenu_admsDataManage", opType="common_op_del", requestParams={"startTime"}, opContent="common_op_startTime")
    public ZKResultMsg del(String ids) {
        this.baseDbBackupService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"system:baseDbBackup:immeBackup"})
    @LogRequest(module="system_module", object="base_leftMenu_admsDataManage", opType="base_db_backup", opContent="base_db_backup")
    public ZKResultMsg immeBackup() {
        String backupFtp = this.request.getParameter("backupFtp");
        ZKResultMsg zkResultMsg = this.baseDbBackupService.immeBackupAndFtp(WebContextUtil.getCurrentSessionId(), backupFtp);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void opDownloadFile(String id) throws IOException {
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"start");
        this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        Object fileOutputStr = null;
        BaseDbBackupItem item = this.baseDbBackupService.getItemById(id);
        if (Objects.isNull(item) || StringUtils.isBlank((CharSequence)item.getFileName())) {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
            return;
        }
        if (!item.getBackupPath().contains("ftp://")) {
            File file = new File(String.valueOf(item.getBackupPath()) + item.getFileName());
            if (file.exists()) {
                boolean isMSIE;
                String fileName = item.getFileName();
                String agent = this.request.getHeader("User-Agent");
                boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
                if (isMSIE) {
                    fileName = URLEncoder.encode(fileName, "UTF-8");
                    fileName = fileName.replaceAll("\\+", " ");
                } else {
                    fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
                }
                if (this.request.getHeader("User-Agent") != null && this.request.getHeader("User-Agent").indexOf("Edge") != -1) {
                    fileName = fileName.replaceAll(" ", "%20");
                    fileName = URLEncoder.encode(fileName, "ISO-8859-1");
                    fileName = fileName.replace("%2520", " ");
                }
                byte[] buffer = new byte[1024];
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                OutputStream outputStream = null;
                try {
                    try {
                        fis = new FileInputStream(file);
                        bis = new BufferedInputStream(fis);
                        outputStream = this.response.getOutputStream();
                        this.response.setContentType("application/force-download");
                        this.response.addHeader("Content-Disposition", "attachment;fileName=" + fileName);
                        int i = bis.read(buffer);
                        while (i != -1) {
                            outputStream.write(buffer, 0, i);
                            i = bis.read(buffer);
                        }
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException e4) {
                                e4.printStackTrace();
                            }
                        }
                        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
                    }
                    return;
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
                }
            }
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
            throw new ZKBusinessException("base_db_backupFileNotExist");
        }
        ApacheFtpUtil ftpUtil = null;
        try {
            String ftpFilePath = item.getBackupPath();
            String ftpAddr = this.baseSysParamService.getValByName("ftpAddr").trim();
            String ftpPort = this.baseSysParamService.getValByName("ftpPort").trim();
            String ftpUsername = this.baseSysParamService.getValByName("ftpUsername").trim();
            String ftpPwd = this.baseSysParamService.getValByName("ftpPwd").trim();
            String ftpDir = this.baseSysParamService.getValByName("ftpDir").trim();
            ftpUtil = new ApacheFtpUtil(ftpAddr, Integer.valueOf(ftpPort), ftpUsername, ftpPwd);
            Pair<Boolean, String> pair = ftpUtil.downloadFile(ftpDir, item.getFileName(), this.response);
            if (!((Boolean)pair.getKey()).booleanValue()) {
                this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
                throw new ZKBusinessException((String)pair.getValue());
            }
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
            return;
        }
        finally {
            if (ftpUtil != null) {
                ftpUtil.close();
            }
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
        }
    }

    @RequiresPermissions(value={"system:baseDbBackup:planBackup"})
    public ZKResultMsg planBackup() {
        ZKResultMsg zkResultMsg = null;
        SecuritySubject securitySubject = this.authSessionProvider.getSecuritySubject(this.request.getSession().getId());
        if (securitySubject != null) {
            String startTime = this.request.getParameter("startTime");
            String intervaltime = this.request.getParameter("dbBackupIntervalTime");
            String dbBackupRemote = this.request.getParameter("dbBackupRemote");
            zkResultMsg = this.baseDbBackupService.planBackupAndFtp(startTime, intervaltime, dbBackupRemote);
        }
        return zkResultMsg;
    }

    public ModelAndView getStartTime() {
        String dbBackupStartTime = this.baseSysParamService.getValByName("dbBackupStartTime");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isBlank((CharSequence)dbBackupStartTime)) {
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            String startTime = simpleDateFormat.format(date);
            int hour = calendar.get(11);
            if (calendar.get(12) * 60 + calendar.get(13) > 600) {
                ++hour;
            }
            dbBackupStartTime = String.valueOf(startTime.substring(0, startTime.indexOf(" "))) + " " + hour + ":00:00";
        }
        this.request.setAttribute("dbBackupStartTime", (Object)dbBackupStartTime);
        String dbBackupIntervalTime = this.baseSysParamService.getValByName("dbBackupIntervalTime");
        if (StringUtils.isBlank((CharSequence)dbBackupIntervalTime)) {
            dbBackupIntervalTime = "1";
        }
        this.request.setAttribute("dbBackupIntervalTime", (Object)dbBackupIntervalTime);
        this.request.setAttribute("dbBackupRemote", (Object)this.baseSysParamService.getValByName("dbBackupRemote"));
        this.request.setAttribute("dbBackupIsLinux", (Object)String.valueOf(SystemOsUtil.isLinux()));
        try {
            this.setNextTime(dbBackupStartTime, dbBackupIntervalTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.request.setAttribute("editPage", (Object)true);
        return new ModelAndView("system/baseDbBackup/opBaseDbBackup");
    }

    @RequiresPermissions(value={"system:baseDbBackup:getFtpSetting"})
    public ModelAndView getFtpSetting() {
        HashMap<String, String> ftpParams = new HashMap<String, String>();
        ftpParams.put("ftpAddr", this.baseSysParamService.getValByName("ftpAddr").trim());
        ftpParams.put("ftpPort", this.baseSysParamService.getValByName("ftpPort").trim());
        ftpParams.put("ftpDir", this.baseSysParamService.getValByName("ftpDir").trim());
        ftpParams.put("ftpUsername", this.baseSysParamService.getValByName("ftpUsername").trim());
        ftpParams.put("ftpPwd", this.baseSysParamService.getValByName("ftpPwd").trim());
        this.request.setAttribute("ftpParams", ftpParams);
        this.request.setAttribute("editPage", (Object)true);
        return new ModelAndView("system/baseDbBackup/opBaseDbBackupToFtp");
    }

    public ZKResultMsg saveFtpSetting(@RequestParam Map<String, String> params) {
        String ftpAddr = params.get("ftpAddr");
        String ftpPort = params.get("ftpPort");
        String ftpUsername = params.get("ftpUsername");
        String ftpPwd = params.get("ftpPwd");
        String ftpDir = params.get("ftpDir");
        this.baseDbBackupService.saveFtpSetting(ftpAddr, ftpPort, ftpDir, ftpUsername, Base64Util.getFromBase64((String)ftpPwd));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    private void setNextTime(String dbBackupStartTime, String dbBackupIntervalTime) throws ParseException {
        this.request.setAttribute("lastdbBackupTime", (Object)this.baseSysParamService.getValByName("lastdbBackupTime"));
        String[] timeArr = dbBackupStartTime.split(" ")[1].split(":");
        Date currentDate = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sfNoHMS = new SimpleDateFormat("yyyy-MM-dd");
        Date targetDate = null;
        targetDate = sf.parse(dbBackupStartTime);
        long dateSub = 0L;
        if (currentDate.before(targetDate)) {
            dateSub = targetDate.getTime() - currentDate.getTime();
            this.request.setAttribute("nextdbBackupTime", (Object)dbBackupStartTime);
        } else {
            String curYMDStr = sfNoHMS.format(currentDate);
            String currentDateStr = sf.format(currentDate);
            String tarYMDStr = dbBackupStartTime.split(" ")[0];
            String curHMSStr = currentDateStr.split(" ")[1];
            String tarHMSStr = dbBackupStartTime.split(" ")[1];
            Date curYMDDate = null;
            Date tarYMDDate = null;
            curYMDDate = sfNoHMS.parse(curYMDStr);
            tarYMDDate = sfNoHMS.parse(tarYMDStr);
            long dimDay = (long)Math.floor((double)(curYMDDate.getTime() - tarYMDDate.getTime()) / 8.64E7);
            long leftTime = 0L;
            if (dimDay % Long.parseLong(dbBackupIntervalTime) == 0L && curHMSStr.compareTo(tarHMSStr) > 0) {
                leftTime = Long.parseLong(dbBackupIntervalTime);
            } else {
                long rightDay = Math.round((double)(currentDate.getTime() - targetDate.getTime()) / 8.64E7);
                leftTime = Long.parseLong(dbBackupIntervalTime) - rightDay % Long.parseLong(dbBackupIntervalTime);
                if (rightDay % Long.parseLong(dbBackupIntervalTime) == 0L) {
                    leftTime = 0L;
                }
            }
            Calendar nextDate = Calendar.getInstance();
            nextDate.set(11, Integer.parseInt(timeArr[0]));
            nextDate.set(12, Integer.parseInt(timeArr[1]));
            nextDate.set(13, Integer.parseInt(timeArr[2]));
            nextDate.add(5, (int)leftTime);
            dateSub = nextDate.getTimeInMillis() - currentDate.getTime();
            if (Integer.parseInt(dbBackupIntervalTime) == 1 && dateSub > 86400000L) {
                dateSub -= 86400000L;
                nextDate.add(5, -1);
            }
            this.request.setAttribute("nextdbBackupTime", (Object)sf.format(nextDate.getTime()));
        }
        long backupday = dateSub / 86400000L;
        long backuphour = dateSub / 3600000L - backupday * 24L;
        long backupmin = dateSub / 60000L - backupday * 24L * 60L - backuphour * 60L;
        long backupsed = dateSub / 1000L - backupday * 24L * 60L * 60L - backuphour * 60L * 60L - backupmin * 60L;
        this.request.setAttribute("backupday", (Object)backupday);
        this.request.setAttribute("backuphour", (Object)backuphour);
        this.request.setAttribute("backupmin", (Object)backupmin);
        this.request.setAttribute("backupsed", (Object)backupsed);
    }

    public ZKResultMsg testConnection() {
        String ftpAddr = this.request.getParameter("ftpAddr");
        String ftpPort = this.request.getParameter("ftpPort");
        String ftpUsername = this.request.getParameter("ftpUsername");
        String ftpPwd = this.request.getParameter("ftpPwd");
        String ftpDir = this.request.getParameter("ftpDir");
        boolean ret = false;
        if (StringUtils.isNotBlank((CharSequence)"ftpAddr") && StringUtils.isNotBlank((CharSequence)"ftpPort") && StringUtils.isNotBlank((CharSequence)"ftpUsername") && StringUtils.isNotBlank((CharSequence)"ftpPwd")) {
            if (StringUtils.isBlank((CharSequence)ftpDir)) {
                ftpDir = "";
            }
            ret = this.baseDbBackupService.testConnection(ftpAddr, Integer.valueOf(Integer.parseInt(ftpPort)), ftpDir, ftpUsername, Base64Util.getFromBase64((String)ftpPwd));
        }
        if (ret) {
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }

    public ZKResultMsg backupTestConnection() {
        String ftpAddr = this.baseSysParamService.getValByName("ftpAddr").trim();
        String ftpPort = this.baseSysParamService.getValByName("ftpPort").trim();
        String ftpDir = this.baseSysParamService.getValByName("ftpDir").trim();
        String ftpUsername = this.baseSysParamService.getValByName("ftpUsername").trim();
        String ftpPwd = this.baseSysParamService.getValByName("ftpPwd").trim();
        boolean ftpRet = false;
        if (StringUtils.isBlank((CharSequence)ftpAddr) || StringUtils.isBlank((CharSequence)ftpPort) || StringUtils.isBlank((CharSequence)ftpUsername) || StringUtils.isBlank((CharSequence)ftpPwd)) {
            return ZKResultMsg.failMsg((String)"notSet", (Object[])new Object[]{I18nUtil.i18nCode((String)"base_db_ftpNotSet", (Object[])new Object[0])});
        }
        if (StringUtils.isNotBlank((CharSequence)ftpAddr) && StringUtils.isNotBlank((CharSequence)ftpPort) && StringUtils.isNotBlank((CharSequence)ftpUsername) && StringUtils.isNotBlank((CharSequence)ftpPwd)) {
            if (StringUtils.isBlank((CharSequence)ftpDir)) {
                ftpDir = "";
            }
            ftpRet = this.baseDbBackupService.testConnection(ftpAddr, Integer.valueOf(Integer.parseInt(ftpPort)), ftpDir, ftpUsername, ftpPwd);
        }
        if (ftpRet) {
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }

    public Boolean isShowBackupPathSet() {
        return SystemOsUtil.isLinux();
    }

    public ModelAndView getBackupPath() {
        this.request.setAttribute("secondDbLocalBackupPath", (Object)this.baseSysParamService.getValByName("secondDbLocalBackupPath").trim());
        this.request.setAttribute("editPage", (Object)true);
        return new ModelAndView("system/baseDbBackup/opBackupPath");
    }

    public ZKResultMsg setBackupPath(@RequestParam String secondDbLocalBackupPath) {
        File file;
        if (SystemOsUtil.isWindow()) {
            secondDbLocalBackupPath = secondDbLocalBackupPath.replaceAll("/", Matcher.quoteReplacement(File.separator));
        } else if (SystemOsUtil.isLinux()) {
            secondDbLocalBackupPath = secondDbLocalBackupPath.replaceAll("\\\\", File.separator);
        }
        if (!secondDbLocalBackupPath.endsWith(File.separator)) {
            secondDbLocalBackupPath = String.valueOf(secondDbLocalBackupPath) + File.separator;
        }
        if ((file = new File(secondDbLocalBackupPath)).exists()) {
            this.baseSysParamService.saveValueByName("secondDbLocalBackupPath", secondDbLocalBackupPath);
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"base_db_backupPathNoExist", (Object[])new Object[0]), (Object[])new Object[0]);
    }

    @RequiresPermissions(value={"system:baseDataManage:resourceFileBackup"})
    @LogRequest(module="system_module", object="base_leftMenu_admsDataManage", opType="base_dataManage_ResourceFileBackup", opContent="base_dataManage_ResourceFileBackup")
    public ZKResultMsg resourceFileBackup() {
        ZKResultMsg zkResultMsg = this.baseDbBackupService.resourceFileBackup(WebContextUtil.getCurrentSessionId());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }
}

