/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.constants.BaseDataConstants;
import com.zkteco.zkbiosecurity.system.remote.BaseDataCleanRemote;
import com.zkteco.zkbiosecurity.system.service.BaseDataCleanService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseDataCleanController
extends BaseController
implements BaseDataCleanRemote {
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseDataCleanService baseDataCleanService;

    @RequiresPermissions(value={"system:baseDataClean"})
    public ModelAndView getParam() {
        BaseSysParamItem params = new BaseSysParamItem();
        params.setParamName("ReportDataClean");
        List items = this.baseSysParamService.getByCondition(params);
        params = new BaseSysParamItem();
        params.setParamName("systemDataClean");
        List systemItems = this.baseSysParamService.getByCondition(params);
        params = new BaseSysParamItem();
        params.setParamName("DiskDataClean");
        List diskItems = this.baseSysParamService.getByCondition(params);
        this.request.setAttribute("items", (Object)items);
        this.request.setAttribute("systemItems", (Object)systemItems);
        this.request.setAttribute("diskItems", (Object)diskItems);
        return new ModelAndView("system/dataClear/setBaseDataClean");
    }

    @RequiresPermissions(value={"system:baseDataClean"})
    @LogRequest(module="base_module", object="base_leftMenu_dataClean", opType="common_leftMenu_paramSet", opContent="common_leftMenu_paramSet")
    public ZKResultMsg saveParam(@RequestParam Map<String, String> params) {
        HashMap<String, String> newParams = new HashMap<String, String>();
        BaseSysParamItem param = new BaseSysParamItem();
        param.setParamName("DataClean");
        List items = this.baseSysParamService.getByCondition(param);
        for (BaseSysParamItem item : items) {
            JSONObject json = JSON.parseObject((String)item.getParamValue());
            if (!params.containsKey(String.valueOf(item.getParamName()) + "KeptMonth")) continue;
            json.put("keptMonth", (Object)params.get(String.valueOf(item.getParamName()) + "KeptMonth"));
            json.put("runtime", (Object)params.get(String.valueOf(item.getParamName()) + "Time"));
            json.put("keptType", (Object)params.get(String.valueOf(item.getParamName()) + "KeptType"));
            newParams.put(item.getParamName(), json.toString());
        }
        if (!newParams.isEmpty()) {
            this.baseSysParamService.saveParams(newParams);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="base_module", object="base_leftMenu_dataClean", opType="base_dataClean_cleanNow", opContent="base_dataClean_cleanNow")
    public ZKResultMsg immediateClean() {
        String keptMonth = this.request.getParameter("keptMonth");
        String name = this.request.getParameter("name");
        String columnName = this.request.getParameter("columnName");
        if (StringUtils.isNotBlank((CharSequence)columnName)) {
            JSONObject json = new JSONObject();
            json.put("keptMonth", (Object)keptMonth);
            json.put("keptType", (Object)BaseDataConstants.DATA_CLEAN_KEPTMONTH);
            this.baseDataCleanService.execute(name, columnName, JSON.toJSONString((Object)json));
        } else {
            this.baseDataCleanService.TomcatLogAndDbBackupClean(name, keptMonth);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

