/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.app.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.system.app.service.BaseAuthAppLoginService;
import com.zkteco.zkbiosecurity.system.app.vo.BaseAuthAppItem;
import com.zkteco.zkbiosecurity.system.service.BaseRegisterService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.service.ModuleInfoService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/app/v1"})
@ApiIgnore
public class BaseAuthAppLoginController {
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseRegisterService baseRegisterService;
    @Autowired
    private BaseAuthAppLoginService baseAuthAppLoginService;
    @Autowired
    private ModuleInfoService moduleInfoService;
    @Value(value="${socketio.url:127.0.0.1}")
    private String socketioUrl;
    @Value(value="${socketio.port:8098}")
    private String socketioPort;
    @Value(value="${system.productCode:ZKBioSecurity}")
    private String productCode;

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public String login(@RequestBody BaseAuthAppItem authAppItem) {
        JSONObject jsonObject;
        block10: {
            jsonObject = null;
            try {
                try {
                    String code = authAppItem.getProductCode();
                    if (StringUtils.isBlank((CharSequence)code)) {
                        code = "ZKBioSecurity";
                    }
                    if (this.getAppCodeByProductCode().equals(code)) {
                        jsonObject = (JSONObject)this.baseAuthAppLoginService.login(authAppItem).getData();
                        break block10;
                    }
                    jsonObject = new JSONObject();
                    jsonObject.put("ret", (Object)"525");
                }
                catch (ZKBusinessException e) {
                    String blank;
                    jsonObject = new JSONObject();
                    if (e.getMessage().equals("auth_login_userOrPwdError")) {
                        jsonObject.put("ret", (Object)"520");
                        break block10;
                    }
                    String msg = e.getMessage();
                    if (msg.indexOf(blank = "&nbsp") >= 0) {
                        msg = msg.substring(0, msg.indexOf(blank));
                    }
                    if (msg.equals("auth_login_licenseOver")) {
                        jsonObject.put("ret", (Object)"522");
                        break block10;
                    }
                    if (msg.equals("auth_login_licenseTrialOver")) {
                        jsonObject.put("ret", (Object)"523");
                        break block10;
                    }
                    jsonObject.put("ret", (Object)"524");
                }
            }
            catch (Throwable throwable) {}
        }
        return jsonObject.toString();
    }

    @RequestMapping(value={"/testConnect"}, method={RequestMethod.POST})
    public String testConnect(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        if (jsonObject != null) {
            String code = jsonObject.getString("productCode");
            if (StringUtils.isBlank((CharSequence)code)) {
                code = "ZKBioSecurity";
            }
            if (!this.getAppCodeByProductCode().equals(code)) {
                json.put("ret", (Object)"525");
                return json.toString();
            }
        } else if ("ZKBioAccess".equals(this.productCode)) {
            json.put("ret", (Object)"525");
            return json.toString();
        }
        json.put("ret", (Object)"OK");
        return json.toString();
    }

    @RequestMapping(value={"/appBinding"}, method={RequestMethod.POST})
    public String appBinding(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        String code = jsonObject.getString("productCode");
        if (StringUtils.isBlank((CharSequence)code)) {
            code = "ZKBioSecurity";
        }
        if (!this.getAppCodeByProductCode().equals(code)) {
            json.put("ret", (Object)"525");
            return json.toString();
        }
        String uuid = jsonObject.getString("uuid");
        if (StringUtils.isBlank((CharSequence)uuid)) {
            json.put("ret", (Object)"500");
            json.put("message", (Object)"uuid is null");
            return json.toString();
        }
        int ret = this.baseRegisterService.appBinding(jsonObject.getString("barcode"), uuid, jsonObject.getString("username"));
        if (ret == 200) {
            json.put("ret", (Object)"OK");
        } else {
            json.put("ret", (Object)String.valueOf(ret));
        }
        return json.toString();
    }

    @RequestMapping(value={"/queryMenus"}, method={RequestMethod.POST})
    public String queryMenus(@RequestBody BaseAuthAppItem authAppItem) {
        JSONObject json = new JSONObject();
        json.put("ret", (Object)"OK");
        json.put("menus", this.baseAuthAppLoginService.getMenus(authAppItem).getData());
        return json.toString();
    }

    @RequestMapping(value={"/getCurrentlanguage"}, method={RequestMethod.POST})
    public String getCurrentlanguage() {
        JSONObject json = new JSONObject();
        String currentlanguage = LocaleMessageSourceUtil.language;
        json.put("ret", (Object)"OK");
        json.put("currentlanguage", (Object)currentlanguage);
        return json.toString();
    }

    @RequestMapping(value={"/getCurrentVersion"}, method={RequestMethod.POST})
    public String getCurrentVersion() {
        JSONObject json = new JSONObject();
        String currentVersion = this.baseSysParamService.getValByName("systemVersion");
        json.put("ret", (Object)"OK");
        json.put("currentVersion", (Object)currentVersion);
        return json.toString();
    }

    @RequestMapping(value={"/getDictionary"}, method={RequestMethod.POST})
    public String getDictionary(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        json.put("ret", (Object)"OK");
        return json.toString();
    }

    @RequestMapping(value={"/editAppUser"}, method={RequestMethod.POST})
    public String editAppUser(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        this.baseAuthAppLoginService.editUser(jsonObject.getString("loginType"), jsonObject.getString("username"), jsonObject.getString("password"), jsonObject.getString("name"), jsonObject.getString("email"));
        json.put("ret", (Object)"OK");
        return json.toString();
    }

    @RequestMapping(value={"/getAppUser"}, method={RequestMethod.POST})
    public String getAppUser(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        json.put("ret", (Object)"OK");
        Map map = this.baseAuthAppLoginService.getAppUserInfo(jsonObject.getString("loginType"), jsonObject.getString("username"));
        json.put("data", (Object)map);
        return json.toString();
    }

    @RequestMapping(value={"/getSocketIoURL"}, method={RequestMethod.POST})
    public String getSocketIoURL() {
        JSONObject json = new JSONObject();
        json.put("ret", (Object)"OK");
        json.put("url", (Object)this.socketioUrl);
        json.put("port", (Object)this.socketioPort);
        return json.toString();
    }

    @RequestMapping(value={"/loginOut"}, method={RequestMethod.POST})
    public String loginOut(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        this.baseAuthAppLoginService.loginOut(jsonObject.getString("token"));
        json.put("ret", (Object)"OK");
        return json.toString();
    }

    @RequestMapping(value={"/getValueByKey"}, method={RequestMethod.POST})
    public String getValueByKey(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        JSONArray keys = jsonObject.getJSONArray("keys");
        HashMap<String, String> map1 = new HashMap<String, String>();
        if (!"".equals(keys) && keys != null) {
            int i = 0;
            while (i < keys.size()) {
                String value = this.baseSysParamService.getValByName(keys.getString(i));
                map1.put(keys.getString(i), value);
                if (this.moduleInfoService.isExistModuleByCode("acc")) {
                    map1.put("acc.version", "true");
                }
                ++i;
            }
        }
        if (map1.isEmpty()) {
            json.put("ret", (Object)"no value");
        } else {
            json.put("ret", (Object)"OK");
            json.put("data", map1);
        }
        return json.toString();
    }

    private String getAppCodeByProductCode() {
        String appCode = "ZKBioSecurity";
        switch (this.productCode) {
            case "ZKBioAccess": {
                appCode = "ZKBioAccess";
                break;
            }
            case "ZKBioCVSecurity": 
            case "ZKBioSecurity": {
                appCode = "ZKBioSecurity";
            }
        }
        return appCode;
    }
}

