/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.aop;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.system.service.BaseOpLogService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseOpLogItem;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class OpLogAspect {
    @Autowired
    BaseOpLogService baseOpLogService;
    @Autowired
    BaseSysParamService baseSysParamService;
    private static final Logger log = LoggerFactory.getLogger(OpLogAspect.class);

    @Around(value="@annotation(logRequest)")
    public Object doInterceptor(ProceedingJoinPoint pjp, LogRequest logRequest) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = null;
        BaseOpLogItem log = new BaseOpLogItem();
        short opResult = 0;
        String[] sysParams = null;
        try {
            try {
                if (WebContextUtil.getCurrentRequest() != null) {
                    HttpServletRequest httpServletRequest = WebContextUtil.getCurrentRequest();
                    String ip = httpServletRequest.getHeader("X-Forwarded-For");
                    if (StringUtils.isBlank((CharSequence)ip)) {
                        ip = httpServletRequest.getRemoteAddr();
                    }
                    if ("0:0:0:0:0:0:0:1".equals(ip)) {
                        ip = "127.0.0.1";
                    }
                    log.setOpIp(ip);
                    SecuritySubject securitySubject = this.baseOpLogService.getCurrentUser(httpServletRequest.getSession().getId());
                    if (securitySubject != null) {
                        log.setOpUserId(securitySubject.getUserId());
                        log.setOpUsername(securitySubject.getUserCode());
                    } else if (httpServletRequest.getRequestURI().contains("login.do")) {
                        log.setOpUsername(httpServletRequest.getParameter("username"));
                    }
                    log.setOpSys(I18nUtil.i18nCode((String)logRequest.module(), (Object[])new Object[0]));
                    log.setOpObject(I18nUtil.i18nCode((String)logRequest.object(), (Object[])new Object[0]));
                    if (logRequest.opType().equals("common_op_edit") && StringUtils.isBlank((CharSequence)httpServletRequest.getParameter("id"))) {
                        log.setOpType(I18nUtil.i18nCode((String)"common_op_new", (Object[])new Object[0]));
                    } else {
                        log.setOpType(I18nUtil.i18nCode((String)logRequest.opType(), (Object[])new Object[0]));
                    }
                    log.setOpTime(new Date());
                    if (StringUtils.isNotBlank((CharSequence)logRequest.opContent())) {
                        log.setContent(I18nUtil.i18nCode((String)logRequest.opContent(), (Object[])new Object[0]));
                    } else {
                        log.setContent("");
                    }
                    String[] params = logRequest.requestParams();
                    if (params != null && params.length > 0) {
                        StringBuffer psb = new StringBuffer();
                        String[] stringArray = params;
                        int n = params.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String p = stringArray[n2];
                            String s = httpServletRequest.getParameter(p);
                            if (StringUtils.isNotBlank((CharSequence)s)) {
                                psb.append(String.valueOf(s) + ";");
                            }
                            ++n2;
                        }
                        log.setContent(String.valueOf(log.getContent()) + ":" + psb.toString());
                    }
                    sysParams = logRequest.sysParams();
                    this.saveParamsByLog(sysParams, httpServletRequest, log);
                    if (StringUtils.isBlank((CharSequence)log.getContent())) {
                        log.setContent(pjp.getTarget().toString());
                    }
                }
                result = pjp.proceed();
            }
            catch (Exception e) {
                if (e instanceof ZKBusinessException) {
                    String msg = I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]);
                    ZKBusinessException ee = (ZKBusinessException)e;
                    if (Objects.nonNull(ee.getObjects())) {
                        msg = I18nUtil.i18nCode((String)e.getMessage(), (Object[])ee.getObjects());
                    }
                    log.setContent(msg);
                } else {
                    log.setContent(e.getMessage());
                }
                opResult = 1;
                log.setOpResult(Short.valueOf(opResult));
                throw e;
            }
        }
        finally {
            if (sysParams == null || sysParams.length <= 0) {
                log.setOpResult(Short.valueOf(opResult));
                log.setCostTime(Integer.valueOf((int)(System.currentTimeMillis() - startTime)));
                this.baseOpLogService.saveItem(log);
            }
        }
        return result;
    }

    private void saveParamsByLog(String[] sysParams, HttpServletRequest httpServletRequest, BaseOpLogItem baseOpLogItem) {
        if (sysParams != null && sysParams.length > 0) {
            String ret = this.buildParameter(sysParams, httpServletRequest);
            long startTime = System.currentTimeMillis();
            short opResult = 0;
            BaseOpLogItem log = new BaseOpLogItem();
            log.setOpIp(baseOpLogItem.getOpIp());
            log.setOpSys(baseOpLogItem.getOpSys());
            log.setOpObject(baseOpLogItem.getOpObject());
            log.setOpType(I18nUtil.i18nCode((String)"common_op_edit", (Object[])new Object[0]));
            log.setOpUserId(baseOpLogItem.getOpUserId());
            log.setOpUsername(baseOpLogItem.getOpUsername());
            log.setContent((String)StringUtils.defaultIfBlank((CharSequence)ret, (CharSequence)I18nUtil.i18nCode((String)"common_leftMenu_paramSet", (Object[])new Object[0])));
            log.setOpTime(new Date());
            log.setOpResult(Short.valueOf(opResult));
            log.setCostTime(Integer.valueOf((int)(System.currentTimeMillis() - startTime)));
            this.baseOpLogService.saveItem(log);
        }
    }

    private String buildParameter(String[] sysParams, HttpServletRequest httpServletRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        String[] stringArray = sysParams;
        int n = sysParams.length;
        int n2 = 0;
        while (n2 < n) {
            String[] split;
            String sysParam = stringArray[n2];
            if (sysParam.contains(":")) {
                split = sysParam.split(":");
                String parameter = httpServletRequest.getParameter(split[1]);
                params.put(split[0], StringUtils.isBlank((CharSequence)parameter) ? "" : parameter);
                if (split[1].equals("down_event_hours")) {
                    params.put("acc.downNewLogExpression", new StringBuffer("0 0 ").append(parameter).append(" * * ?").toString());
                }
            } else if (sysParam.contains("*")) {
                split = sysParam.split("\\*");
                Map moduleParams = this.baseSysParamService.getParamsByModule(split[0]);
                for (String key : moduleParams.keySet()) {
                    String param = (String)moduleParams.get(key);
                    if (StringUtils.isBlank((CharSequence)param)) continue;
                    String parameter = httpServletRequest.getParameter(param);
                    params.put(param, StringUtils.isBlank((CharSequence)parameter) ? "" : parameter);
                }
            } else {
                String parameter = httpServletRequest.getParameter(sysParam);
                params.put(sysParam, StringUtils.isBlank((CharSequence)parameter) ? "" : parameter);
            }
            ++n2;
        }
        HashMap oldParams = new HashMap();
        HashMap newParams = new HashMap();
        String ret = "";
        params.entrySet().stream().forEach(entry -> Optional.ofNullable(this.baseSysParamService.findByParamName((String)entry.getKey())).map(param -> {
            if (param != null) {
                oldParams.put((String)entry.getKey(), String.valueOf(param.getParamValue()) + "-" + param.getDescription());
                newParams.put((String)entry.getKey(), String.valueOf((String)entry.getValue()) + "-" + param.getDescription());
                param.setParamValue((String)entry.getValue());
            }
            return param;
        }));
        for (String key : oldParams.keySet()) {
            if (!newParams.containsKey(key) || ((String)oldParams.get(key)).equals(newParams.get(key))) continue;
            String[] oldArray = ((String)oldParams.get(key)).split("-");
            String[] newArray = ((String)newParams.get(key)).split("-");
            ret = StringUtils.isBlank((CharSequence)ret) ? String.valueOf(ret) + oldArray[1] + ":" + oldArray[0] + " -> " + newArray[0] : String.valueOf(ret) + "," + oldArray[1] + ":" + oldArray[0] + " -> " + newArray[0];
        }
        return ret;
    }
}

