/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.remote.AccZoneRemote;
import com.zkteco.zkbiosecurity.acc.service.AccZonePersonService;
import com.zkteco.zkbiosecurity.acc.service.AccZoneService;
import com.zkteco.zkbiosecurity.acc.vo.AccZoneItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccZoneController
extends BaseController
implements AccZoneRemote {
    @Autowired
    private AccZoneService accZoneService;
    @Autowired
    private AccZonePersonService accZonePersonService;

    @RequiresPermissions(value={"acc:zone"})
    public ModelAndView index() {
        return new ModelAndView("acc/zone/accZone");
    }

    @RequiresPermissions(value={"acc:zone:edit", "acc:zone:add"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accZoneService.getItemById(id));
        }
        return new ModelAndView("acc/zone/editAccZone");
    }

    @RequiresPermissions(value={"acc:zone:edit", "acc:zone:add"})
    @LogRequest(module="acc_module", object="acc_leftMenu_zone", opType="common_op_edit", requestParams={"code"}, opContent="acc_zone_code")
    public ZKResultMsg save(AccZoneItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accZoneService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:zone:queryZoneRules"})
    @LogRequest(module="acc_module", object="acc_leftMenu_zone", opType="acc_leftMenu_whatRulesInside", requestParams={"code"}, opContent="acc_zone_code")
    public ModelAndView queryZoneRules(String ids) {
        String zoneId = this.request.getParameter("zoneId");
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.request.setAttribute("tempAccZone", (Object)this.accZoneService.getItemById(ids));
        }
        return new ModelAndView("acc/zone/opAccZoneRules");
    }

    @RequiresPermissions(value={"acc:zone:refresh"})
    public DxGrid list(AccZoneItem codition) {
        Pager pager = this.accZoneService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:zone:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_zone", opType="common_op_del", requestParams={"code"}, opContent="acc_zone_code")
    public ZKResultMsg del(String ids) {
        this.accZoneService.deleteByIds(ids);
        this.accZonePersonService.deleteByZoneIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getZoneList() {
        String zoneExpOutside = this.request.getParameter("zoneExpOutside");
        return new ZKResultMsg((Object)this.accZoneService.getZoneList(zoneExpOutside));
    }

    public ZKResultMsg getGlobalApbZoneList(String zoneId) {
        return new ZKResultMsg((Object)this.accZoneService.getGlobalApbZoneList(zoneId));
    }

    public String valid(String code) {
        AccZoneItem item = this.accZoneService.getItemByCode(code);
        boolean rs = item == null;
        return String.valueOf(rs);
    }

    public TreeItem tree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        List accZoneItemList = this.accZoneService.getByCondition(new AccZoneItem());
        if (!accZoneItemList.isEmpty()) {
            TreeItem item = null;
            for (AccZoneItem accZoneItem : accZoneItemList) {
                item = new TreeItem();
                item.setId(accZoneItem.getId());
                item.setText(accZoneItem.getName());
                item.setParent(new TreeItem("0"));
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public TreeItem fliterTree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        List accZoneItemList = this.accZoneService.getByCondition(new AccZoneItem());
        if (!accZoneItemList.isEmpty()) {
            TreeItem item = null;
            for (AccZoneItem accZoneItem : accZoneItemList) {
                if (accZoneItem.getInitFlag().booleanValue()) continue;
                item = new TreeItem();
                item.setId(accZoneItem.getId());
                item.setText(accZoneItem.getName());
                item.setParent(new TreeItem("0"));
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public TreeItem zonePersonTree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        List accZoneItemList = this.accZoneService.getByCondition(new AccZoneItem());
        if (accZoneItemList.size() > 1) {
            TreeItem item = null;
            TreeItem pItem = new TreeItem("0");
            TreeItem rItem = new TreeItem("total");
            rItem.setText(I18nUtil.i18nCode((String)"common_all", (Object[])new Object[0]));
            rItem.setParent(pItem);
            items.add(rItem);
            Map personCountMap = this.accZonePersonService.getPersonCountMap();
            for (AccZoneItem accZoneItem : accZoneItemList) {
                if ("1".equals(accZoneItem.getCode())) continue;
                Map zonePersonCount = this.accZonePersonService.getZonePersonAllCountById(accZoneItem.getId());
                String inCount = "0";
                String outCount = "0";
                if (Objects.nonNull(zonePersonCount) && zonePersonCount.size() > 0) {
                    inCount = (String)zonePersonCount.get("in");
                    outCount = (String)zonePersonCount.get("out");
                }
                item = new TreeItem();
                item.setId(accZoneItem.getId());
                item.setParent(new TreeItem("total"));
                int allCount = 0;
                if (personCountMap.containsKey(accZoneItem.getId())) {
                    allCount = (Integer)personCountMap.get(accZoneItem.getId());
                }
                String titleIn = I18nUtil.i18nCode((String)"acc_zonePerson_inCount", (Object[])new Object[0]);
                String titleOut = I18nUtil.i18nCode((String)"acc_zonePerson_outCount", (Object[])new Object[0]);
                item.setText("<span> " + accZoneItem.getName() + "</span><p style='padding: 2px 0px 4px;'>" + "<span style='margin-right:5px;' class='icv-acc_zonePersonCount_current'></span>" + allCount + "<span style='margin-left:10px; margin-right:5px;' title='" + titleIn + "' class='icv-acc_zonePersonCount_in'></span>" + inCount + "<span style='margin-left:10px; margin-right:5px;' class='icv-acc_zonePersonCount_out'  title='" + titleOut + "'></span>" + outCount + "</p>");
                items.add(item);
            }
        } else {
            items = new ArrayList();
            TreeItem infoItem = new TreeItem();
            infoItem.setId("_");
            infoItem.setText("<span class='warningColor'>" + I18nUtil.i18nCode((String)"acc_zone_addZone", (Object[])new Object[0]) + "</span>");
            infoItem.setIm0("comm_iconAlert.png");
            items.add(infoItem);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public boolean isExistName(String name) {
        AccZoneItem item = this.accZoneService.getItemByName(name);
        return item == null;
    }

    public ZKResultMsg getRulesFromZone(String zoneId) {
        ZKResultMsg res = new ZKResultMsg();
        List rulesList = this.accZoneService.getRulesFromZone(zoneId);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        for (Map ruleMap : rulesList) {
            jsonObject = new JSONObject();
            for (String key : ruleMap.keySet()) {
                jsonObject.put("ruleType", (Object)I18nUtil.i18nCode((String)key, (Object[])new Object[0]));
                jsonObject.put("ruleName", ruleMap.get(key));
            }
            jsonArray.add((Object)jsonObject);
        }
        if (!jsonArray.isEmpty()) {
            res.setData((Object)jsonArray);
        }
        return res;
    }
}

