/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccPersonLimitZoneRemote;
import com.zkteco.zkbiosecurity.acc.service.AccAdvancedPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonLimitService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonLimitZoneService;
import com.zkteco.zkbiosecurity.acc.vo.AccAdvancedPersonSelectItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonLimitZoneItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonPersonLimitZoneItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.ApplicationPropertiesUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccPersonLimitZoneController
extends BaseController
implements AccPersonLimitZoneRemote {
    @Autowired
    private AccPersonLimitZoneService accPersonLimitZoneService;
    @Autowired
    private AccPersonLimitService accPersonLimitService;
    @Autowired
    private AccAdvancedPersonService accAdvancedPersonService;

    @RequiresPermissions(value={"acc:personLimitZone"})
    public ModelAndView index() {
        return new ModelAndView("acc/personLimitZone/accPersonLimitZone");
    }

    @RequiresPermissions(value={"acc:personLimitZone:add", "acc:personLimitZone:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccPersonLimitZoneItem item = this.accPersonLimitZoneService.getItemById(id);
            item.setValidTimes("");
            if ("1".equals("" + item.getValidType()) && StringUtils.isNotBlank((CharSequence)item.getValidDateTime())) {
                item.setValidDate(DateUtil.stringToDate((String)item.getValidDateTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
                item.setValidDateTime("");
            } else if ("3".equals("" + item.getValidType()) && StringUtils.isNotBlank((CharSequence)item.getValidDateTime())) {
                item.setValidTimes(item.getValidDateTime());
                item.setValidDateTime("");
            }
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("acc/personLimitZone/editAccPersonLimitZone");
    }

    @RequiresPermissions(value={"acc:personLimitZone:add", "acc:personLimitZone:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_personLimit", opType="common_op_edit", requestParams={"name"}, opContent="acc_personLimit_availabilityName")
    public ZKResultMsg save(AccPersonLimitZoneItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accPersonLimitZoneService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:personLimitZone:refresh"})
    public DxGrid list(AccPersonLimitZoneItem codition) {
        Pager pager = this.accPersonLimitZoneService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:personLimitZone:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_personLimit", opType="common_op_del", requestParams={"names"}, opContent="acc_personLimit_availabilityName")
    public ZKResultMsg del(String ids) {
        this.accPersonLimitZoneService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String valid(String name) {
        AccPersonLimitZoneItem item = this.accPersonLimitZoneService.getItemByName(name);
        boolean rs = item == null;
        return String.valueOf(rs);
    }

    public ZKResultMsg getPersonLimitZoneDetail(String id) {
        String ret = "";
        AccPersonLimitZoneItem accPersonLimitZoneItem = this.accPersonLimitZoneService.getItemById(id);
        if (accPersonLimitZoneItem != null) {
            if (accPersonLimitZoneItem.getValidType().toString().equals("3")) {
                ret = String.valueOf(accPersonLimitZoneItem.getValidDateTime()) + " " + I18nUtil.i18nCode((String)"common_times", (Object[])new Object[0]);
            } else if (accPersonLimitZoneItem.getValidType().toString().equals("2")) {
                ret = String.valueOf(accPersonLimitZoneItem.getValidDateTime()) + " " + I18nUtil.i18nCode((String)"common_days", (Object[])new Object[0]);
            } else if (accPersonLimitZoneItem.getValidType().toString().equals("1")) {
                Date date = DateUtil.stringToDate((String)accPersonLimitZoneItem.getValidDateTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
                ret = String.valueOf(I18nUtil.i18nCode((String)"acc_personLimit_userDateTo", (Object[])new Object[0])) + " " + DateUtil.dateToLocaleString((Date)date, (String)ApplicationPropertiesUtil.getProperty((String)"biosecurity.date.sysDateTimeFmt.alias", (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        return new ZKResultMsg((Object)ret);
    }

    public DxGrid personList(AccPersonPersonLimitZoneItem condition) {
        Pager pager = this.accPersonLimitZoneService.getPersonItemList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectPersonList(AccAdvancedPersonSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.accPersonLimitZoneService.getNoExistPersonFilterDept(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_personLimit", opType="pers_common_addPerson", requestParams={"personLimitZoneName", "personPins"}, opContent="acc_personLimit_availabilityName")
    public ZKResultMsg addPerson(String personLimitZoneId, String personIds, String deptIds) {
        ZKResultMsg ret = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.accAdvancedPersonService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)personLimitZoneId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            ArrayList<String> personIdList = new ArrayList<String>(Arrays.asList(personIds.split(",")));
            if (StringUtils.isNotBlank((CharSequence)deptIds)) {
                String validType = this.request.getParameter("validType");
                String zoneId = this.request.getParameter("zoneId");
                List existPersonIds = this.accPersonLimitZoneService.getExistPersonIdsByCondition(zoneId, validType);
                if (existPersonIds.size() > 0) {
                    personIdList.removeAll(existPersonIds);
                }
                if (personIdList.isEmpty()) {
                    ret.setRet("500");
                    ret.setMsg("acc_personLimit_addPersonRepeatTip");
                    return I18nUtil.i18nMsg((ZKResultMsg)ret);
                }
            }
            this.accPersonLimitZoneService.addPerson(personLimitZoneId, personIdList);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_personLimit", opType="pers_common_delPerson", requestParams={"personLimitZoneName", "persPins"}, opContent="acc_personLimit_availabilityName")
    public ZKResultMsg delPerson(String personLimitZoneId, String perPersonLimitZoneIds) {
        this.accPersonLimitZoneService.delPerson(personLimitZoneId, perPersonLimitZoneIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_personLimit", opType="common_op_reset", requestParams={"name"}, opContent="acc_personLimit_availabilityName")
    public ZKResultMsg resetPersonLimitZone(String personLimitZoneId) {
        this.accPersonLimitZoneService.resetPersonLimitZone(personLimitZoneId);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_personLimit", opType="common_op_reset", requestParams={"persPin"}, opContent="pers_person_pin")
    public ZKResultMsg resetPersonPersonLimitZone() {
        String personId = this.request.getParameter("personId");
        String zoneId = this.request.getParameter("zoneId");
        String validType = this.request.getParameter("validType");
        this.accPersonLimitZoneService.resetPersonPersonLimitZoneByPersonId(personId, zoneId, validType);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

