/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccMusterPointReportRemote;
import com.zkteco.zkbiosecurity.acc.service.AccMusterPointReportService;
import com.zkteco.zkbiosecurity.acc.service.AccMusterPointService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonLimitZoneService;
import com.zkteco.zkbiosecurity.acc.vo.AccAdvancedSelectVisitorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccMusterPointReportItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccMusterPointReportController
extends ExportController
implements AccMusterPointReportRemote {
    @Autowired
    private AccMusterPointReportService accMusterPointReportService;
    @Autowired
    private AccPersonLimitZoneService accPersonLimitZoneService;
    @Autowired
    private AccMusterPointService accMusterPointService;

    @RequiresPermissions(value={"acc:musterPointReport"})
    public ModelAndView index() {
        return new ModelAndView("acc/musterPointReport/accMusterPointReport");
    }

    @RequiresPermissions(value={"acc:musterPointReport:signInManually"})
    @LogRequest(module="acc_module", object="acc_musterPoint_report", opType="acc_musterPointReport_sign", requestParams={"selectPinId"}, opContent="pers_person_pin")
    public ZKResultMsg signInManually() {
        String musterPointId = this.request.getParameter("selectMusterPointId");
        String persPersonType = this.request.getParameter("persPersonType");
        if ("0".equals(persPersonType)) {
            String personId = this.request.getParameter("personId");
            this.accMusterPointReportService.signInManually(personId, musterPointId);
        } else {
            String visitorId = this.request.getParameter("visitorId");
            this.accMusterPointReportService.signInManuallyForVisitor(visitorId, musterPointId);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg generateReport(AccMusterPointReportItem item) {
        this.accMusterPointReportService.generateReport(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid list(AccMusterPointReportItem condition) {
        String musterPointId;
        String selectedStatus = this.request.getParameter("selectedStatus");
        if (StringUtils.isNotBlank((CharSequence)selectedStatus)) {
            condition.setStatus(selectedStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)(musterPointId = this.request.getParameter("musterPointId")))) {
            condition.setMusterPointIdEq(musterPointId);
        } else {
            musterPointId = this.accMusterPointService.getSelectedMusterPointId();
            condition.setMusterPointIdEq(musterPointId);
        }
        if ("1".equals(condition.getPersonType())) {
            condition.setDeptCode("vis");
        } else if ("0".equals(condition.getPersonType())) {
            condition.setDeptCodeNoEq("vis");
        }
        long limit = this.getLimitCount();
        Pager pager = this.accMusterPointReportService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"acc:musterPointReport:del"})
    @LogRequest(module="acc_module", object="acc_musterPoint_report", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.accMusterPointReportService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:musterPointReport:export"})
    @LogRequest(module="acc_module", object="acc_musterPoint_report", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String userId;
        AccMusterPointReportItem accMusterPointReportItem = new AccMusterPointReportItem();
        this.setConditionValue((BaseItem)accMusterPointReportItem);
        String personType = accMusterPointReportItem.getPersonType();
        if (StringUtils.isNotBlank((CharSequence)personType)) {
            if ("1".equals(personType)) {
                accMusterPointReportItem.setDeptCode("vis");
            } else {
                accMusterPointReportItem.setDeptCodeNoEq("vis");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(userId = this.accPersonLimitZoneService.getUserIdBySessionId(request.getSession().getId())))) {
            accMusterPointReportItem.setDeptCodeInByUserId(userId);
        }
        List itemList = this.accMusterPointReportService.getItemData(AccMusterPointReportItem.class, (BaseItem)accMusterPointReportItem, this.getBeginIndex(), this.getEndIndex());
        if (StringUtils.isNotBlank((CharSequence)personType) && "1".equals(personType)) {
            for (AccMusterPointReportItem item : itemList) {
                item.setDeptName(I18nUtil.i18nCode((String)item.getDeptName(), (Object[])new Object[0]));
            }
        }
        this.excelExport(itemList, AccMusterPointReportItem.class);
    }

    public ZKResultMsg getData(String musterPointId) {
        ZKResultMsg retMsg = new ZKResultMsg();
        String userId = this.accPersonLimitZoneService.getUserIdBySessionId(this.request.getSession().getId());
        retMsg.setData((Object)this.accMusterPointReportService.getDataByFilter(userId, musterPointId));
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @RequiresPermissions(value={"acc:musterPointReport:generate"})
    @LogRequest(module="acc_module", object="acc_musterPoint_report", opType="acc_musterPointReport_generate", requestParams={"musterPointName"}, opContent="common_name")
    public ZKResultMsg generateReportByMusterPoint(String musterPointId) {
        if (StringUtils.isNotBlank((CharSequence)musterPointId)) {
            this.accMusterPointReportService.generateReportByMusterPoint(musterPointId);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid selectVisitorList(AccAdvancedSelectVisitorItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.accMusterPointReportService.getNoExistVisitor(condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

