/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccMusterPointRemote;
import com.zkteco.zkbiosecurity.acc.service.AccGlobalLinkageService;
import com.zkteco.zkbiosecurity.acc.service.AccMusterPointService;
import com.zkteco.zkbiosecurity.acc.vo.AccMusterPointDeptItem;
import com.zkteco.zkbiosecurity.acc.vo.AccMusterPointItem;
import com.zkteco.zkbiosecurity.acc.vo.AccMusterPointSelectDeptItem;
import com.zkteco.zkbiosecurity.acc.vo.AccMusterPointSelectReaderItem;
import com.zkteco.zkbiosecurity.acc.vo.AccMusterPointSignPointItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccMusterPointController
extends BaseController
implements AccMusterPointRemote {
    @Autowired
    private AccMusterPointService accMusterPointService;
    @Autowired
    private AccGlobalLinkageService accGlobalLinkageService;

    @RequiresPermissions(value={"acc:musterPoint"})
    public ModelAndView index() {
        return new ModelAndView("acc/musterPoint/accMusterPoint");
    }

    @RequiresPermissions(value={"acc:musterPoint:add"})
    public ModelAndView edit(String id) {
        boolean showSMS = this.accGlobalLinkageService.checkShowSMS();
        boolean showWhatsapp = this.accGlobalLinkageService.checkShowWhatsapp();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccMusterPointItem item = this.accMusterPointService.getItemById(id);
            String messageNotificationType = item.getMessageNotificationType();
            if (StringUtils.isNotBlank((CharSequence)messageNotificationType)) {
                item.setSendEmail(String.valueOf(messageNotificationType.charAt(0)));
                item.setSendSMS(String.valueOf(messageNotificationType.charAt(1)));
                item.setSendWhatsapp(String.valueOf(messageNotificationType.charAt(2)));
                item.setMessageNotificationType(messageNotificationType);
            }
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("signPointList", (Object)item.getMusterPointSignPointItemList());
        }
        this.request.setAttribute("showSMS", (Object)showSMS);
        this.request.setAttribute("showWhatsapp", (Object)showWhatsapp);
        return new ModelAndView("acc/musterPoint/editAccMusterPoint");
    }

    @RequiresPermissions(value={"acc:musterPoint:add"})
    @LogRequest(module="acc_module", object="acc_leftMenu_accMusterPoint", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(AccMusterPointItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accMusterPointService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:musterPoint:refresh"})
    public DxGrid list(AccMusterPointItem condition) {
        Pager pager = this.accMusterPointService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:musterPoint:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_accMusterPoint", opType="common_op_del", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg del(String ids) {
        this.accMusterPointService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid signPointList(AccMusterPointSignPointItem condition) {
        return null;
    }

    public String valid(String name) {
        AccMusterPointItem item = this.accMusterPointService.getItemByName(name);
        boolean rs = item == null;
        return String.valueOf(rs);
    }

    public void export(HttpServletRequest request, HttpServletResponse response) {
    }

    @RequiresPermissions(value={"acc:musterPoint:activate"})
    @LogRequest(module="acc_module", object="acc_leftMenu_accMusterPoint", opType="acc_musterPoint_activate", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg activate(String ids) {
        this.accMusterPointService.activateMusterPoint(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:musterPoint:cancel"})
    @LogRequest(module="acc_module", object="acc_leftMenu_accMusterPoint", opType="common_edit_cancel", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg cancel(String ids) {
        this.accMusterPointService.cancelMusterPoint(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:musterPoint:refresh"})
    public DxGrid deptList(AccMusterPointDeptItem condition) {
        Pager pager = this.accMusterPointService.getAccMusterPointDeptItems(condition, this.request.getSession().getId(), this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:musterPoint:delDept"})
    @LogRequest(module="acc_module", object="acc_leftMenu_accMusterPoint", opType="acc_musterPoint_delDept", requestParams={"musterPointName", "deptNames"}, opContent="pers_dept_deptName")
    public ZKResultMsg delDept(String musterPointId, String musterPointDeptIds) {
        this.accMusterPointService.delDept(musterPointId, musterPointDeptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:musterPoint:addDept"})
    @LogRequest(module="acc_module", object="acc_leftMenu_accMusterPoint", opType="acc_musterPoint_addDept", requestParams={"musterPointName", "deptNames"}, opContent="pers_dept_deptName")
    public ZKResultMsg addDept(String musterPointId, String deptIds) {
        this.accMusterPointService.addDept(musterPointId, deptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid selectDeptList(AccMusterPointSelectDeptItem condition) {
        Pager pager = new Pager();
        condition.setFilterId(condition.getMusterPointId());
        condition.setNotInId(condition.getSelectId());
        if (condition.getType().equals("noSelected")) {
            pager = this.accMusterPointService.getNoExistDept(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectReaderList(AccMusterPointSelectReaderItem condition) {
        String exitReaderIds;
        Pager pager = new Pager();
        String selectIds = this.request.getParameter("selectValue");
        if (StringUtils.isNotBlank((CharSequence)condition.getSelectId())) {
            selectIds = StringUtils.isNotBlank((CharSequence)selectIds) ? String.valueOf(selectIds) + "," + condition.getSelectId() : condition.getSelectId();
        }
        if (StringUtils.isNotBlank((CharSequence)(exitReaderIds = this.accMusterPointService.getExitReaderIds(condition.getMusterPointId())))) {
            String string = selectIds = StringUtils.isNotBlank((CharSequence)selectIds) ? String.valueOf(selectIds) + "," + exitReaderIds : exitReaderIds;
        }
        if (StringUtils.isNotBlank((CharSequence)selectIds)) {
            condition.setSelectId(selectIds);
            condition.setNotInId(selectIds);
        }
        if (condition.getType().equals("noSelected")) {
            pager = this.accMusterPointService.getNotExistReader(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getMusterPointList() {
        return new ZKResultMsg((Object)this.accMusterPointService.getActivatedPointList());
    }

    public ZKResultMsg getAllMusterPointList() {
        return new ZKResultMsg((Object)this.accMusterPointService.getAllMusterPointList());
    }
}

