/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.remote.AccGlobalLinkageRemote;
import com.zkteco.zkbiosecurity.acc.service.AccAdvancedPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccGlobalLinkageService;
import com.zkteco.zkbiosecurity.acc.service.AccMusterPointService;
import com.zkteco.zkbiosecurity.acc.vo.AccGlobalLinkageItem;
import com.zkteco.zkbiosecurity.acc.vo.AccGlobalLinkagePersonItem;
import com.zkteco.zkbiosecurity.acc.vo.AccGlobalLinkageSelectAuxInItem;
import com.zkteco.zkbiosecurity.acc.vo.AccGlobalLinkageSelectAuxOutItem;
import com.zkteco.zkbiosecurity.acc.vo.AccGlobalLinkageSelectDoorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccMusterPointItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccGlobalLinkageController
extends BaseController
implements AccGlobalLinkageRemote {
    private static final Logger logger = LoggerFactory.getLogger(AccGlobalLinkageController.class);
    @Autowired
    private AccGlobalLinkageService accGlobalLinkageService;
    @Autowired
    private AccAdvancedPersonService accAdvancedPersonService;
    @Autowired
    private AccMusterPointService accMusterPointService;

    @RequiresPermissions(value={"acc:globalLinkage"})
    public ModelAndView index() {
        return new ModelAndView("acc/globalLinkage/accGlobalLinkage");
    }

    @RequiresPermissions(value={"acc:globalLinkage:add", "acc:globalLinkage:edit"})
    public ModelAndView edit(String id) {
        boolean showLine = this.accGlobalLinkageService.checkShowLine();
        boolean showMusterPoint = this.accGlobalLinkageService.checkShowMusterPoint();
        List accMusterPointItemList = null;
        if (showMusterPoint) {
            accMusterPointItemList = this.accMusterPointService.getAllItems();
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccGlobalLinkageItem item = this.accGlobalLinkageService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
            if (showLine) {
                List accGlobalLinkage4LineContactItems = this.accGlobalLinkageService.getLineContactsByContactIds(item.getLineContactId());
                this.request.setAttribute("contactList", (Object)accGlobalLinkage4LineContactItems);
            }
            if (accMusterPointItemList != null && StringUtils.isNotBlank((CharSequence)item.getMusterPointId())) {
                List musterPointIds = StrUtil.strToList((String)item.getMusterPointId());
                for (AccMusterPointItem accMusterPointItem : accMusterPointItemList) {
                    accMusterPointItem.setChecked(Boolean.valueOf(false));
                    if (!musterPointIds.contains(accMusterPointItem.getId())) continue;
                    accMusterPointItem.setChecked(Boolean.valueOf(true));
                }
            }
        }
        this.request.setAttribute("musterPointList", (Object)accMusterPointItemList);
        this.request.setAttribute("showMusterPoint", (Object)showMusterPoint);
        this.request.setAttribute("showLine", (Object)showLine);
        this.request.setAttribute("showSMS", (Object)this.accGlobalLinkageService.checkShowSMS());
        this.request.setAttribute("showDigifort", (Object)this.accGlobalLinkageService.checkShowDigifort());
        this.request.setAttribute("showWhatsapp", (Object)this.accGlobalLinkageService.checkShowWhatsapp());
        return new ModelAndView("acc/globalLinkage/editAccGlobalLinkage");
    }

    @RequiresPermissions(value={"acc:globalLinkage:add", "acc:globalLinkage:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_globalLinkage", opType="common_op_edit", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg save(AccGlobalLinkageItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String isApplyToAll = this.request.getParameter("applyToAll");
        String inputTpye = this.request.getParameter("inputType").equalsIgnoreCase("AccDoor") ? "AccDoor" : "AccAuxIn";
        String digiEventNames = this.request.getParameter("digiEventNames");
        item.setInputType(inputTpye);
        if (isApplyToAll != null) {
            item.setIsApplyToAll(Short.valueOf((short)0));
        } else if (inputTpye.equals("AccDoor")) {
            item.setIsApplyToAll(Short.valueOf((short)1));
        } else {
            item.setIsApplyToAll(Short.valueOf((short)2));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getPopUpVideo()) && "1".equals(item.getPopUpVideo())) {
            String popUpTime = this.request.getParameter("popUpTime");
            item.setPopUpTimes(Integer.parseInt(popUpTime));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getRecord()) && "2".equals(item.getRecord())) {
            String recordTime = this.request.getParameter("recordTime");
            item.setRecordTimes(Integer.parseInt(recordTime));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getCapture()) && "3".equals(item.getCapture())) {
            String captureTime = this.request.getParameter("captureTime");
            if (StringUtils.isNotBlank((CharSequence)captureTime)) {
                item.setCaptureTimes(Integer.parseInt(captureTime));
            } else {
                item.setCaptureTimes(-1);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)digiEventNames)) {
            item.setDigifortEventName(digiEventNames);
        }
        this.accGlobalLinkageService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:globalLinkage:refresh"})
    public DxGrid list(AccGlobalLinkageItem codition) {
        Pager pager = this.accGlobalLinkageService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:globalLinkage:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_globalLinkage", opType="common_op_del", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg del(String ids) {
        this.accGlobalLinkageService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg isSupportLockDoor(String doorIds) {
        boolean isSupportLockDoor = true;
        if (StringUtils.isNotBlank((CharSequence)doorIds)) {
            isSupportLockDoor = this.accGlobalLinkageService.isSupportLockDoor(doorIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)isSupportLockDoor));
    }

    public ZKResultMsg getLinkTriggerOpt(String globalLinkageId) {
        JSONObject devsJson = new JSONObject();
        try {
            devsJson.put("id", (Object)"globalTrigger");
            JSONArray devJsonArray = new JSONArray();
            ZKResultMsg resultMsg = this.accGlobalLinkageService.getLinkTriggerOpt(globalLinkageId);
            JSONObject dataJson = (JSONObject)resultMsg.getData();
            JSONArray deviceEvent = dataJson.getJSONArray("deviceEvent");
            JSONArray auxInEvent = dataJson.getJSONArray("auxInEvent");
            JSONArray doorEvent = dataJson.getJSONArray("doorEvent");
            Map checkParentElement = (Map)dataJson.get((Object)"checkParentElement");
            int checkEventSize = dataJson.getIntValue("checkEventSize");
            JSONObject eventJson = null;
            String[] parentElement = new String[]{I18nUtil.i18nCode((String)"common_linkIO_doorEvent", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_linkIO_auxInEvent", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_linkIO_deviceEvent", (Object[])new Object[0])};
            if (doorEvent.size() > 0 || auxInEvent.size() > 0 || deviceEvent.size() > 0) {
                int i = 0;
                while (i < 2) {
                    eventJson = new JSONObject();
                    eventJson.put("id", (Object)(String.valueOf(i) + "_parent"));
                    eventJson.put("text", (Object)parentElement[i]);
                    eventJson.put("open", (Object)"1");
                    if (checkParentElement.containsKey(i)) {
                        if (i == 0) {
                            if (doorEvent.size() == checkEventSize) {
                                eventJson.put("checked", (Object)"1");
                            } else {
                                eventJson.put("checked", (Object)"-1");
                            }
                        } else if (i == 1) {
                            if (auxInEvent.size() == checkEventSize) {
                                eventJson.put("checked", (Object)"1");
                            } else {
                                eventJson.put("checked", (Object)"-1");
                            }
                        } else if (deviceEvent.size() == checkEventSize) {
                            eventJson.put("checked", (Object)"1");
                        } else {
                            eventJson.put("checked", (Object)"-1");
                        }
                    }
                    eventJson.put("item", (Object)(i == 0 ? doorEvent : (i == 1 ? auxInEvent : deviceEvent)));
                    devJsonArray.add((Object)eventJson);
                    ++i;
                }
                devsJson.put("item", (Object)devJsonArray);
            }
        }
        catch (Exception e) {
            logger.error("getLinkTriggerOpt error", (Throwable)e);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devsJson));
    }

    public ZKResultMsg getInputInfo(String triggerNos) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        try {
            String[] triggerNoStr;
            ArrayList<Integer> triggerNoList = new ArrayList<Integer>();
            String[] stringArray = triggerNoStr = triggerNos.split(",");
            int n = triggerNoStr.length;
            int n2 = 0;
            while (n2 < n) {
                String triggerNo = stringArray[n2];
                triggerNoList.add(Integer.parseInt(triggerNo.indexOf("_") >= 0 ? triggerNo.trim().split("_")[1] : triggerNo));
                ++n2;
            }
            String filterInputIds = this.accGlobalLinkageService.getInputFilterIds(triggerNoList);
            JSONObject retIds = new JSONObject();
            retIds.put("inputFilterIds", (Object)filterInputIds);
            resultMsg.setData((Object)retIds);
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        return resultMsg;
    }

    @RequiresPermissions(value={"acc:globalLinkage:addPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_globalLinkage", opType="pers_common_addPerson", requestParams={"globalLinkageName", "personPins"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg addPerson(String globalLinkageId, String personIds, String deptIds) {
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.accAdvancedPersonService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)globalLinkageId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            this.accGlobalLinkageService.addPerson(globalLinkageId, personIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:globalLinkage:delPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_globalLinkage", opType="pers_common_delPerson", requestParams={"globalLinkageName", "personPins"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg delPerson(String globalLinkageId, String personIds) {
        if (StringUtils.isNotBlank((CharSequence)globalLinkageId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            this.accGlobalLinkageService.delPerson(globalLinkageId, personIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:globalLinkage:enable"})
    @LogRequest(module="acc_module", object="acc_leftMenu_globalLinkage", opType="common_enable", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg setEnable(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.accGlobalLinkageService.setGlobalLinkageStatus(ids, true);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:globalLinkage:disable"})
    @LogRequest(module="acc_module", object="acc_leftMenu_globalLinkage", opType="common_disable", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg setDisable(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.accGlobalLinkageService.setGlobalLinkageStatus(ids, false);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg checkMailParam() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.accGlobalLinkageService.checkMailParam());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public boolean isExistLinkageName(String name) {
        AccGlobalLinkageItem item = new AccGlobalLinkageItem();
        item.setName(name);
        item.setEquals(Boolean.valueOf(true));
        return this.accGlobalLinkageService.getByCondition(item).size() <= 0;
    }

    public ZKResultMsg getOutputInfo(String outputType) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        String filterOutputIds = this.accGlobalLinkageService.getOutputFilterIds(outputType);
        JSONObject retIds = new JSONObject();
        if (outputType.equals("door")) {
            retIds.put("doorFilterIds", (Object)filterOutputIds);
        } else {
            retIds.put("auxOutFilterIds", (Object)filterOutputIds);
        }
        resultMsg.setData((Object)retIds);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public DxGrid getGlobalLinkageSelectDoor(AccGlobalLinkageSelectDoorItem condition) {
        condition.setEnabled(Boolean.valueOf(true));
        Pager pager = this.accGlobalLinkageService.getGlobalLinkageSelectDoor(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getSelectAuxOutList(AccGlobalLinkageSelectAuxOutItem codition) {
        Pager pager = this.accGlobalLinkageService.getSelectAuxOutList(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public DxGrid getGlobalLinkageSelectAuxIn(AccGlobalLinkageSelectAuxInItem codition) {
        Pager pager = this.accGlobalLinkageService.getGlobalLinkageSelectAuxIn(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg addPersonValidate(String linkId) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (!this.accGlobalLinkageService.addPersonValidate(linkId)) {
            resultMsg.setRet("fail");
            resultMsg.setMsg("acc_globalLinkage_noAddPerson");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg checkSMSModemParam() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.accGlobalLinkageService.checkSMSModemParam());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg getDigifortGlobalEvents(String linkageId, String type) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.accGlobalLinkageService.getDigifortGlobalEvents(linkageId, type));
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public DxGrid getPersonList(AccGlobalLinkagePersonItem condition) {
        Pager pager = this.accAdvancedPersonService.getGlobalLinkPersonItemList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg checkGlobalTriggerOpt() {
        String triggerOpt = this.request.getParameter("triggerOpt");
        String inputAddr = this.request.getParameter("inputAddr");
        String globalLinkageId = this.request.getParameter("globalLinkageId");
        ZKResultMsg resultMsg = this.accGlobalLinkageService.checkGlobalTriggerOpt(triggerOpt, inputAddr, globalLinkageId);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

