/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccGlobalInterlockRemote;
import com.zkteco.zkbiosecurity.acc.service.AccGlobalInterlockService;
import com.zkteco.zkbiosecurity.acc.vo.AccGlobalInterlockItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccGlobalInterlockController
extends BaseController
implements AccGlobalInterlockRemote {
    @Autowired
    private AccGlobalInterlockService accGlobalInterlockService;

    @RequiresPermissions(value={"acc:globalInterlock"})
    public ModelAndView index() {
        return new ModelAndView("acc/globalInterlock/accGlobalInterlock");
    }

    @RequiresPermissions(value={"acc:globalInterlock:add", "acc:globalInterlock:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accGlobalInterlockService.getItemById(id));
        }
        return new ModelAndView("acc/globalInterlock/editAccGlobalInterlock");
    }

    @RequiresPermissions(value={"acc:globalInterlock:add", "acc:globalInterlock:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_globalInterlock", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(AccGlobalInterlockItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accGlobalInterlockService.saveItem(item);
        res.setData((Object)item.getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:globalInterlock:refresh"})
    public DxGrid list(AccGlobalInterlockItem codition) {
        Pager pager = this.accGlobalInterlockService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:globalInterlock:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_globalInterlock", opType="common_op_del", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg del(String ids) {
        this.accGlobalInterlockService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(AccGlobalInterlockItem item) {
        return this.accGlobalInterlockService.isExist(item.getName());
    }

    @RequiresPermissions(value={"acc:globalInterlock:addGroup"})
    @LogRequest(module="acc_module", object="acc_leftMenu_globalInterlock", opType="acc_globalInterlock_addGroup", requestParams={"interlockName", "groupNames"}, opContent="acc_combOpen_personGroupName")
    public ZKResultMsg addGroup(String interlockId, String groupIds) {
        this.accGlobalInterlockService.addGroup(interlockId, groupIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

