/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccGlobalApbRemote;
import com.zkteco.zkbiosecurity.acc.service.AccAdvancedPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccGlobalApbService;
import com.zkteco.zkbiosecurity.acc.vo.AccGlobalApbItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonGlobalApbItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccGlobalApbController
extends BaseController
implements AccGlobalApbRemote {
    @Autowired
    private AccGlobalApbService accGlobalApbService;
    @Autowired
    private AccAdvancedPersonService accAdvancedPersonService;

    @RequiresPermissions(value={"acc:globalApb"})
    public ModelAndView index() {
        return new ModelAndView("acc/globalApb/accGlobalApb");
    }

    @RequiresPermissions(value={"acc:globalApb:add", "acc:globalApb:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccGlobalApbItem item = this.accGlobalApbService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("acc/globalApb/editAccGlobalApb");
    }

    @RequiresPermissions(value={"acc:globalApb:add", "acc:globalApb:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_gapbSet", opType="common_op_edit", requestParams={"name"}, opContent="acc_common_ruleName")
    public ZKResultMsg save(AccGlobalApbItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if (item.getIsResetApb() == null) {
            item.setIsResetApb(Short.valueOf((short)0));
        }
        this.accGlobalApbService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:globalApb:refresh"})
    public DxGrid list(AccGlobalApbItem codition) {
        Pager pager = this.accGlobalApbService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:globalApb:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_gapbSet", opType="common_op_del", requestParams={"name"}, opContent="acc_common_ruleName")
    public ZKResultMsg del(String ids) {
        this.accGlobalApbService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:globalApb:refresh"})
    public DxGrid personList(AccPersonGlobalApbItem condition) {
        Pager pager = this.accAdvancedPersonService.getGlobalApbPersonItemList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:globalApb:addPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_gapbSet", opType="pers_common_addPerson", requestParams={"globalApbName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(String globalApbId, String personIds, String deptIds) {
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.accAdvancedPersonService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)globalApbId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            ArrayList<String> personIdList = new ArrayList<String>(Arrays.asList(personIds.split(",")));
            this.accGlobalApbService.addPerson(globalApbId, personIdList);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:globalApb:delPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_gapbSet", opType="pers_common_delPerson", requestParams={"globalApbName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delPerson(String globalApbId, String personIds) {
        this.accGlobalApbService.delPerson(globalApbId, personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg validApb() {
        return new ZKResultMsg((Object)this.accGlobalApbService.validApb(this.request.getParameter("zoneId")));
    }

    public ZKResultMsg validEntranceApb() {
        return new ZKResultMsg((Object)this.accGlobalApbService.validEntranceApb(this.request.getParameter("zoneId")));
    }

    public String valid(String name) {
        AccGlobalApbItem item = this.accGlobalApbService.getItemByName(name);
        boolean rs = item == null;
        return String.valueOf(rs);
    }

    public String judge(String accZoneId, String oldAccZoneId) {
        boolean ret = this.accGlobalApbService.judge(accZoneId, oldAccZoneId);
        return String.valueOf(ret);
    }
}

