/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.ias.service.IasTestService;
import com.zkteco.zkbiosecurity.ias.vo.IasDeviceItem;
import com.zkteco.zkbiosecurity.ias.vo.IasDeviceUserItem;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/token/deviceTest"})
public class IasTestController {
    private static final Logger log = LoggerFactory.getLogger(IasTestController.class);
    @Autowired
    private IasTestService iasTestService;

    @RequestMapping(params={"test"})
    @ResponseBody
    public ZKResultMsg test(@RequestBody IasDeviceItem iasDeviceItem) {
        return this.iasTestService.test(iasDeviceItem, "");
    }

    @RequestMapping(params={"disconnect"})
    @ResponseBody
    public ZKResultMsg disconnect(@RequestBody IasDeviceItem iasDeviceItem) {
        return this.iasTestService.disconnect(iasDeviceItem);
    }

    @RequestMapping(params={"keepAlive"})
    @ResponseBody
    public ZKResultMsg keepAlive(@RequestBody IasDeviceItem iasDeviceItem) {
        return this.iasTestService.keepAlive(iasDeviceItem);
    }

    @RequestMapping(params={"getPartitions"})
    @ResponseBody
    public ZKResultMsg getPartitions(@RequestBody IasDeviceItem iasDeviceItem) {
        return this.iasTestService.getPartitions(iasDeviceItem);
    }

    @RequestMapping(params={"getPoints"})
    @ResponseBody
    public ZKResultMsg getPoints(@RequestBody IasDeviceItem iasDeviceItem) {
        return this.iasTestService.getPoints(iasDeviceItem);
    }

    @RequestMapping(params={"getOutputs"})
    @ResponseBody
    public ZKResultMsg getOutputs(@RequestBody IasDeviceItem iasDeviceItem) {
        return this.iasTestService.getOutputs(iasDeviceItem);
    }

    @RequestMapping(params={"getUsers"})
    @ResponseBody
    public ZKResultMsg getUsers(@RequestBody IasDeviceItem iasDeviceItem) {
        return this.iasTestService.getUsers(iasDeviceItem, 30);
    }

    @RequestMapping(params={"arm"})
    @ResponseBody
    public ZKResultMsg arm(@RequestBody IasDeviceItem iasDeviceItem, @RequestParam Integer armType, @RequestParam List<Integer> partitionCodeList) {
        return this.iasTestService.arm(iasDeviceItem, armType, partitionCodeList);
    }

    @RequestMapping(params={"silenceBells"})
    @ResponseBody
    public ZKResultMsg silenceBells(@RequestBody IasDeviceItem iasDeviceItem, @RequestParam List<Integer> partitionCodeList) {
        return this.iasTestService.silenceBells(iasDeviceItem, partitionCodeList);
    }

    @RequestMapping(params={"setPointsBypass"})
    @ResponseBody
    public ZKResultMsg setPointsBypass(@RequestBody IasDeviceItem iasDeviceItem, @RequestParam List<Integer> pointCodeList, @RequestParam Boolean bypass) {
        return this.iasTestService.setPointsBypass(iasDeviceItem, pointCodeList, bypass);
    }

    @RequestMapping(params={"setOutputStatus"})
    @ResponseBody
    public ZKResultMsg setOutputStatus(@RequestBody IasDeviceItem iasDeviceItem, @RequestParam Integer outputCode, @RequestParam Boolean isActive) {
        return this.iasTestService.setOutputStatus(iasDeviceItem, outputCode, isActive);
    }

    @RequestMapping(params={"setDate"})
    @ResponseBody
    public ZKResultMsg setDate(@RequestBody IasDeviceItem iasDeviceItem) {
        return this.iasTestService.setDate(iasDeviceItem);
    }

    @RequestMapping(params={"saveUser"})
    @ResponseBody
    public ZKResultMsg saveUser(@RequestBody IasDeviceItem iasDeviceItem, @RequestBody JSONObject data) {
        IasDeviceUserItem iasDeviceUserItem = new IasDeviceUserItem();
        iasDeviceUserItem.setName(data.getString("userName"));
        iasDeviceUserItem.setCode(data.getInteger("userCode"));
        iasDeviceUserItem.setPassword(data.getString("userPassword"));
        return this.iasTestService.saveUser(iasDeviceItem, iasDeviceUserItem);
    }

    @RequestMapping(params={"deleteUser"})
    @ResponseBody
    public ZKResultMsg deleteUser(@RequestBody IasDeviceItem iasDeviceItem, @RequestParam Integer userCode) {
        return this.iasTestService.deleteUser(iasDeviceItem, userCode);
    }

    @RequestMapping(params={"setSubscriptions"})
    @ResponseBody
    public ZKResultMsg setSubscriptions(@RequestBody IasDeviceItem iasDeviceItem) {
        return this.iasTestService.setSubscriptions(iasDeviceItem);
    }
}

