/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.ias.remote.IasRTMonitorRemote;
import com.zkteco.zkbiosecurity.ias.service.IasOutputService;
import com.zkteco.zkbiosecurity.ias.service.IasPartitionService;
import com.zkteco.zkbiosecurity.ias.service.IasPointService;
import com.zkteco.zkbiosecurity.ias.service.IasRTMonitorService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IasRTMonitorController
extends BaseController
implements IasRTMonitorRemote {
    private static final Logger log = LoggerFactory.getLogger(IasRTMonitorController.class);
    @Autowired
    private IasRTMonitorService iasRTMonitorService;
    @Autowired
    private IasPartitionService iasPartitionService;
    @Autowired
    private IasPointService iasPointService;
    @Autowired
    private IasOutputService iasOutputService;

    public ModelAndView index() {
        String authAreaIds = this.iasRTMonitorService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        this.request.setAttribute("authAreaIds", (Object)authAreaIds);
        return new ModelAndView("ias/rtMonitor/iasRTMonitor");
    }

    @MessageMapping(value={"/iasMonitor/getDevState"})
    @SendTo(value={"/topic/iasMonitor/getDevState"})
    public Object getDevState(String params) {
        log.info("IasRTMonitorController init data ... ");
        JSONObject data = new JSONObject();
        List allPartition = this.iasRTMonitorService.getAllPartition(null);
        data.put("partitionStates", (Object)allPartition);
        List allOutput = this.iasRTMonitorService.getAllOutput(null);
        data.put("outputStates", (Object)allOutput);
        List allPoint = this.iasRTMonitorService.getAllPoint(null);
        data.put("pointStates", (Object)allPoint);
        return data;
    }

    public List<JSONObject> getAllPartition() {
        return this.iasRTMonitorService.getAllPartition(this.request.getSession().getId());
    }

    public List<JSONObject> getAllPoint() {
        return this.iasRTMonitorService.getAllPoint(this.request.getSession().getId());
    }

    public List<JSONObject> getAllOutput() {
        return this.iasRTMonitorService.getAllOutput(this.request.getSession().getId());
    }

    @RequiresPermissions(value={"ias:rtMonitor:arm"})
    @LogRequest(module="ias_module", object="common_leftMenu_rtMonitor", opType="ias_partitionArm", requestParams={"name"}, opContent="ias_partition_name")
    public ZKResultMsg arm(String id, Integer armType) {
        return this.iasPartitionService.arm(id, armType);
    }

    @RequiresPermissions(value={"ias:rtMonitor:disarm"})
    @LogRequest(module="ias_module", object="common_leftMenu_rtMonitor", opType="ias_partition_disarm", requestParams={"name"}, opContent="ias_partition_name")
    public ZKResultMsg disarm(String id) {
        return this.iasPartitionService.disarm(id);
    }

    @RequiresPermissions(value={"ias:rtMonitor:disAlarm"})
    @LogRequest(module="ias_module", object="common_leftMenu_rtMonitor", opType="ias_partition_disAlarm", requestParams={"name"}, opContent="ias_partition_name")
    public ZKResultMsg disAlarm(String id) {
        return this.iasPartitionService.disAlarm(id);
    }

    @RequiresPermissions(value={"ias:rtMonitor:bypass"})
    @LogRequest(module="ias_module", object="common_leftMenu_rtMonitor", opType="ias_point_bypass", requestParams={"name"}, opContent="ias_point_name")
    public ZKResultMsg bypass(String id) {
        return this.iasPointService.bypass(id);
    }

    @RequiresPermissions(value={"ias:rtMonitor:unBypass"})
    @LogRequest(module="ias_module", object="common_leftMenu_rtMonitor", opType="ias_point_unbypass", requestParams={"name"}, opContent="ias_point_name")
    public ZKResultMsg unBypass(String id) {
        return this.iasPointService.unbypass(id);
    }

    @RequiresPermissions(value={"ias:rtMonitor:active"})
    @LogRequest(module="ias_module", object="common_leftMenu_rtMonitor", opType="ias_output_active", requestParams={"name"}, opContent="ias_output_name")
    public ZKResultMsg activeOutput(String id) {
        return this.iasOutputService.activeOutput(id);
    }

    @RequiresPermissions(value={"ias:rtMonitor:inactive"})
    @LogRequest(module="ias_module", object="common_leftMenu_rtMonitor", opType="ias_output_cancel", requestParams={"name"}, opContent="ias_output_name")
    public ZKResultMsg inactiveOutput(String id) {
        return this.iasOutputService.inactiveOutput(id);
    }
}

