/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.web.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ias.remote.IasPointRemote;
import com.zkteco.zkbiosecurity.ias.service.IasPointService;
import com.zkteco.zkbiosecurity.ias.vo.IasPointItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IasPointController
extends BaseController
implements IasPointRemote {
    @Autowired
    private IasPointService iasPointService;

    @RequiresPermissions(value={"ias:point"})
    public ModelAndView index() {
        return new ModelAndView("ias/point/iasPoint");
    }

    @RequiresPermissions(value={"ias:point:refresh"})
    public DxGrid list(IasPointItem condition) {
        Pager pager = this.iasPointService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ias:point:edit"})
    public ModelAndView edit(String id) {
        this.request.setAttribute("iasPoint", (Object)this.iasPointService.getItemById(id));
        return new ModelAndView("ias/point/editIasPoint");
    }

    @RequiresPermissions(value={"ias:point:edit"})
    @LogChangeRequest(module="ias_module", object="ias_leftMenu_point", opType="common_op_edit", vo=IasPointItem.class, service=IasPointService.class)
    public ZKResultMsg save(IasPointItem item) {
        this.iasPointService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ias:point:bypass"})
    @LogRequest(module="ias_module", object="ias_leftMenu_point", opType="ias_point_bypass", requestParams={"name"}, opContent="ias_point_name")
    public ZKResultMsg bypass(String id) {
        return this.iasPointService.bypass(id);
    }

    @RequiresPermissions(value={"ias:point:unBypass"})
    @LogRequest(module="ias_module", object="ias_leftMenu_point", opType="ias_point_unbypass", requestParams={"name"}, opContent="ias_point_name")
    public ZKResultMsg unBypass(String id) {
        return this.iasPointService.unbypass(id);
    }
}

