/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.web.controller;

import com.zkteco.zkbiosecurity.auth.service.AuthUserService;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ias.remote.IasPartitionRemote;
import com.zkteco.zkbiosecurity.ias.service.IasDeviceService;
import com.zkteco.zkbiosecurity.ias.service.IasPartitionService;
import com.zkteco.zkbiosecurity.ias.vo.IasPartitionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IasPartitionController
extends ExportController
implements IasPartitionRemote {
    @Autowired
    private IasPartitionService iasPartitionService;
    @Autowired
    private IasDeviceService iasDeviceService;
    @Autowired(required=false)
    private AuthUserService authUserService;

    @RequiresPermissions(value={"ias:partition"})
    public ModelAndView index() {
        return new ModelAndView("ias/partition/iasPartition");
    }

    @RequiresPermissions(value={"ias:partition:refresh"})
    public DxGrid list(IasPartitionItem condition) {
        Pager pager = this.iasPartitionService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ias:partition:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("iasPartitionItem", (Object)this.iasPartitionService.getItemById(id));
        }
        return new ModelAndView("ias/partition/editPartition");
    }

    @RequiresPermissions(value={"ias:partition:edit"})
    @LogChangeRequest(module="ias_module", object="ias_leftMenu_partition", opType="common_op_edit", vo=IasPartitionItem.class, service=IasPartitionService.class)
    public ZKResultMsg save(IasPartitionItem item) {
        this.iasPartitionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ias:partition:arm"})
    public ModelAndView getArmPage(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IasPartitionItem partitionItem = this.iasPartitionService.getItemById(id);
            this.request.setAttribute("item", (Object)partitionItem);
            return new ModelAndView("ias/partition/opIasPartitionArm");
        }
        return null;
    }

    @RequiresPermissions(value={"ias:partition:arm"})
    @LogRequest(module="ias_module", object="ias_leftMenu_partition", opType="ias_partitionArm", requestParams={"name"}, opContent="ias_partition_name")
    public ZKResultMsg arm(String id, Integer armType) {
        if (this.isNeedValid("pwd")) {
            String loginPwd = this.request.getParameter("loginPwd");
            boolean ret = this.authUserService.verifySecurity(this.request.getSession().getId(), loginPwd, "pwd");
            if (!ret) {
                throw new ZKBusinessException("auth_user_pwdIncorrect");
            }
        }
        return this.iasPartitionService.arm(id, armType);
    }

    @RequiresPermissions(value={"ias:partition:disarm"})
    @LogRequest(module="ias_module", object="ias_leftMenu_partition", opType="ias_partition_disarm", requestParams={"name"}, opContent="ias_partition_name")
    public ZKResultMsg disarm(String id) {
        if (this.isNeedValid("pwd")) {
            String loginPwd = this.request.getParameter("loginPwd");
            boolean ret = this.authUserService.verifySecurity(this.request.getSession().getId(), loginPwd, "pwd");
            if (!ret) {
                throw new ZKBusinessException("auth_user_pwdIncorrect");
            }
        }
        return this.iasPartitionService.disarm(id);
    }

    @RequiresPermissions(value={"ias:partition:silenceBells"})
    @LogRequest(module="ias_module", object="ias_leftMenu_partition", opType="ias_partition_silenceBells", requestParams={"name"}, opContent="ias_partition_name")
    public ZKResultMsg silenceBells(String id) {
        return this.iasPartitionService.silenceBells(id);
    }

    public ZKResultMsg getArmTypes() {
        return new ZKResultMsg((Object)this.iasPartitionService.getArmTypes());
    }
}

