/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.web.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ias.remote.IasLinkageRecordRemote;
import com.zkteco.zkbiosecurity.ias.service.IasLinkageRecordService;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageRecordItem;
import com.zkteco.zkbiosecurity.ias.web.util.IasHttpsUtils;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IasLinkageRecordController
extends ExportController
implements IasLinkageRecordRemote {
    @Autowired
    private IasLinkageRecordService iasLinkageRecordService;

    @RequiresPermissions(value={"ias:linkageRecord"})
    public ModelAndView index() {
        return new ModelAndView("ias/linkageRecord/iasLinkageRecord");
    }

    @RequiresPermissions(value={"ias:linkageRecord:refresh"})
    public DxGrid list(IasLinkageRecordItem condition) {
        Pager pager = this.iasLinkageRecordService.loadTransactionByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ias:linkageRecord:del"})
    @LogRequest(module="ias_module", object="ias_linkage_record", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.iasLinkageRecordService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ias:linkageRecord:export"})
    @LogRequest(module="ias_module", object="ias_linkage_record", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        IasLinkageRecordItem iasLinkageRecordItem = new IasLinkageRecordItem();
        this.setConditionValue((BaseItem)iasLinkageRecordItem);
        List itemList = this.iasLinkageRecordService.getItemData(request.getSession().getId(), iasLinkageRecordItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, IasLinkageRecordItem.class);
    }

    public ZKResultMsg getLinkageFileUrl(String id) {
        return this.iasLinkageRecordService.getLinkageFileUrl(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLinkageImageByUrl() {
        block15: {
            ByteArrayOutputStream out = null;
            HttpURLConnection httpUrl = null;
            InputStream is = null;
            byte[] bytes = new byte[1024];
            try {
                String url = this.request.getParameter("url");
                if (!StringUtils.isNotBlank((CharSequence)url)) break block15;
                if (!url.startsWith("http") && !url.startsWith("https")) {
                    String decryptFileBase64 = FileEncryptUtil.getDecryptFileBase64((String)url);
                    bytes = Base64.getDecoder().decode(decryptFileBase64);
                } else if (url.startsWith("https")) {
                    bytes = IasHttpsUtils.doGet(url);
                } else if (url.startsWith("http")) {
                    URL photoUrl = new URL(url);
                    try {
                        httpUrl = (HttpURLConnection)photoUrl.openConnection();
                        httpUrl.setConnectTimeout(3000);
                        httpUrl.connect();
                        is = httpUrl.getInputStream();
                        if (is != null) {
                            out = new ByteArrayOutputStream();
                            int len = 0;
                            while ((len = is.read(bytes)) != -1) {
                                out.write(bytes, 0, len);
                            }
                            bytes = out.toByteArray();
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                        if (httpUrl != null) {
                            httpUrl.disconnect();
                        }
                    }
                }
                this.response.reset();
                this.response.getOutputStream().write(bytes);
            }
            catch (Exception e) {
                this.log.error("exception", (Throwable)e);
            }
        }
        return null;
    }

    public ZKResultMsg getLinkageVideoInfo(String id) {
        return this.iasLinkageRecordService.getLinkageVideoInfo(id);
    }
}

