/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.web.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ias.remote.IasLinkageRemote;
import com.zkteco.zkbiosecurity.ias.service.IasLinkageService;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageItem;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageSelectAccAuxOutItem;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageSelectAccDoorItem;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageSelectDeviceItem;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageSelectEleFloorItem;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageSelectIvsChannelItem;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageSelectLineContactItem;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageSelectOutputItem;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageSelectPartitionItem;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageSelectPointItem;
import com.zkteco.zkbiosecurity.ias.vo.IasLinkageSelectPsgGateItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IasLinkageController
extends BaseController
implements IasLinkageRemote {
    @Autowired
    private IasLinkageService iasLinkageService;

    @RequiresPermissions(value={"ias:linkage"})
    public ModelAndView index() {
        return new ModelAndView("ias/linkage/iasLinkage");
    }

    @RequiresPermissions(value={"ias:linkage:refresh"})
    public DxGrid list(IasLinkageItem condition) {
        Pager pager = this.iasLinkageService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ias:linkage:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.iasLinkageService.getItemById(id));
        }
        this.request.setAttribute("haveMailParam", (Object)this.iasLinkageService.haveMailParam());
        this.request.setAttribute("showSMS", (Object)this.iasLinkageService.checkShowSMS());
        this.request.setAttribute("haveSMSParam", (Object)this.iasLinkageService.haveSMSParam());
        this.request.setAttribute("showWhatsapp", (Object)this.iasLinkageService.checkShowWhatsapp());
        this.request.setAttribute("showLine", (Object)this.iasLinkageService.checkShowLine());
        this.request.setAttribute("showDigifort", (Object)this.iasLinkageService.checkShowDigifort());
        return new ModelAndView("ias/linkage/editLinkage");
    }

    @RequiresPermissions(value={"ias:linkage:edit"})
    @LogChangeRequest(module="ias_module", object="common_leftMenu_linkage", opType="common_op_edit", vo=IasLinkageItem.class, service=IasLinkageService.class, fields={"name"})
    public ZKResultMsg save(IasLinkageItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.iasLinkageService.saveItem(item));
    }

    @RequiresPermissions(value={"ias:linkage:del"})
    @LogRequest(module="ias_module", object="common_leftMenu_linkage", opType="common_op_del", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg del(String ids) {
        this.iasLinkageService.deleteByIds(ids);
        return ZKResultMsg.successMsg();
    }

    public boolean isNameExist(String name) {
        return this.iasLinkageService.isNameExist(name);
    }

    public TreeItem getTriggerCondTreeByManufacturer(String manufacturer) {
        return this.iasLinkageService.getTriggerCondTreeByManufacturer(manufacturer);
    }

    public TreeItem getTriggerCondTreeByTriggerConds(String manufacturer, String inputType, String triggerConds) {
        return this.iasLinkageService.getTriggerCondTreeByTriggerConds(manufacturer, inputType, triggerConds);
    }

    public DxGrid getSelectDeviceInput(IasLinkageSelectDeviceItem condition) {
        Pager pager = this.iasLinkageService.getSelectDeviceInput(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getSelectPartitionInput(IasLinkageSelectPartitionItem condition) {
        Pager pager = this.iasLinkageService.getSelectPartitionInput(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getSelectPointInput(IasLinkageSelectPointItem condition) {
        Pager pager = this.iasLinkageService.getSelectPointInput(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getSelectOutputInput(IasLinkageSelectOutputItem condition) {
        Pager pager = this.iasLinkageService.getSelectOutputInput(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem getInputTreeByInputIds(String manufacturer, String inputType, String inputIds) {
        return this.iasLinkageService.getInputTreeByInputIds(manufacturer, inputType, inputIds);
    }

    public TreeItem getIasOutputTreeByIds(String iasOutputIds) {
        return this.iasLinkageService.getIasOutputTreeByIds(iasOutputIds);
    }

    public DxGrid getSelectAccDoor(IasLinkageSelectAccDoorItem condition) {
        Pager pager = this.iasLinkageService.getSelectAccDoor(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem getAccDoorTreeByIds(String accDoorIds) {
        return this.iasLinkageService.getAccDoorTreeByIds(accDoorIds);
    }

    public ZKResultMsg isSupportLockAccDoor(String accDoorIds) {
        boolean isSupportLockDoor = true;
        if (StringUtils.isNotBlank((CharSequence)accDoorIds)) {
            isSupportLockDoor = this.iasLinkageService.isSupportLockAccDoor(accDoorIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)isSupportLockDoor));
    }

    public DxGrid getSelectAccAuxOut(IasLinkageSelectAccAuxOutItem condition) {
        Pager pager = this.iasLinkageService.getSelectAccAuxOut(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem getAccAuxOutTreeByIds(String accAuxOutIds) {
        return this.iasLinkageService.getAccAuxOutTreeByIds(accAuxOutIds);
    }

    public DxGrid getSelectIvsChannel(IasLinkageSelectIvsChannelItem condition) {
        Pager pager = this.iasLinkageService.getSelectIvsChannel(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem getIvsChannelTreeByIds(String ivsChannelIds) {
        return this.iasLinkageService.getIvsChannelTreeByIds(this.request.getSession().getId(), ivsChannelIds);
    }

    public DxGrid getSelectEleFloor(IasLinkageSelectEleFloorItem condition) {
        Pager pager = this.iasLinkageService.getSelectEleFloor(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem getEleFloorTreeByIds(String eleFloorIds) {
        return this.iasLinkageService.getEleFloorTreeByIds(this.request.getSession().getId(), eleFloorIds);
    }

    public DxGrid getSelectPsgGate(IasLinkageSelectPsgGateItem condition) {
        Pager pager = this.iasLinkageService.getSelectPsgGate(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem getPsgGateTreeByIds(String psgGateIds) {
        return this.iasLinkageService.getPsgGateTreeByIds(this.request.getSession().getId(), psgGateIds);
    }

    public DxGrid getSelectLineContact(IasLinkageSelectLineContactItem condition) {
        Pager pager = this.iasLinkageService.getSelectLineContact(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem getLineContactTreeByIds(String lineContactIds) {
        return this.iasLinkageService.getLineContactTreeByIds(this.request.getSession().getId(), lineContactIds);
    }
}

