/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.web.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.ias.remote.IasDeviceUserRemote;
import com.zkteco.zkbiosecurity.ias.service.IasDeviceService;
import com.zkteco.zkbiosecurity.ias.service.IasDeviceUserService;
import com.zkteco.zkbiosecurity.ias.vo.IasDeviceUserItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IasDeviceUserController
extends BaseController
implements IasDeviceUserRemote {
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private IasDeviceUserService iasDeviceUserService;
    @Autowired
    private IasDeviceService iasDeviceService;

    @RequiresPermissions(value={"ias:deviceUser"})
    public ModelAndView index() {
        return new ModelAndView("ias/deviceUser/iasDeviceUser");
    }

    @RequiresPermissions(value={"ias:deviceUser:refresh"})
    public DxGrid list(IasDeviceUserItem condition) {
        Pager pager = this.iasDeviceUserService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ias:deviceUser:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("iasDeviceUser", (Object)this.iasDeviceUserService.getItemById(id));
            this.request.setAttribute("type", (Object)"edit");
        }
        return new ModelAndView("ias/deviceUser/editDeviceUser");
    }

    @RequiresPermissions(value={"ias:deviceUser:edit"})
    @LogChangeRequest(module="ias_module", object="ias_leftMenu_deviceUser", opType="common_op_edit", vo=IasDeviceUserItem.class, service=IasDeviceUserService.class)
    public ZKResultMsg save(IasDeviceUserItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.iasDeviceUserService.saveItem(item));
    }

    @RequiresPermissions(value={"ias:deviceUser:del"})
    @LogRequest(module="ias_module", object="ias_leftMenu_deviceUser", opType="common_op_del", requestParams={"name"}, opContent="ias_deviceUser_name")
    public ZKResultMsg del(String ids) {
        return this.iasDeviceUserService.deleteDeviceUserByIds(ids);
    }

    public ModelAndView updateDeviceUserPage() {
        return new ModelAndView("ias/deviceUser/updateIasDeviceUser");
    }

    @RequiresPermissions(value={"ias:deviceUser:updateUser"})
    @LogRequest(module="ias_module", object="ias_leftMenu_deviceUser", opType="ias_device_updateUser", requestParams={"devName"}, opContent="common_dev_name")
    public ZKResultMsg updateDeviceUser(String ids, Integer userCount) {
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
        ZKResultMsg zkResultMsg = this.iasDeviceUserService.updateDeviceUser(ids, userCount.intValue());
        if (zkResultMsg.isSuccess()) {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"ias_updateUser_success", (Object[])new Object[0]));
        } else if (I18nUtil.i18nCode((String)"ias_device_offline", (Object[])new Object[0]).equals(zkResultMsg.getMsg())) {
            this.progressCache.finishProcess("<font class='zk-msg-error'>" + I18nUtil.i18nCode((String)"ias_device_offline", (Object[])new Object[0]) + "...</font><br/>");
        } else {
            this.progressCache.finishProcess("<font class='zk-msg-error'>" + zkResultMsg.getMsg() + "...</font><br/>");
        }
        return null;
    }
}

