/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.web.controller;

import com.zkteco.zkbiosecurity.auth.service.AuthUserService;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.ias.remote.IasDeviceRemote;
import com.zkteco.zkbiosecurity.ias.service.IasDeviceService;
import com.zkteco.zkbiosecurity.ias.vo.IasDeviceItem;
import com.zkteco.zkbiosecurity.ias.vo.IasDeviceSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IasDeviceController
extends ExportController
implements IasDeviceRemote {
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private IasDeviceService iasDeviceService;
    @Autowired(required=false)
    private AuthUserService authUserService;

    @RequiresPermissions(value={"ias:device"})
    public ModelAndView index() {
        return new ModelAndView("ias/device/iasDevice");
    }

    @RequiresPermissions(value={"ias:device:refresh"})
    public DxGrid list(IasDeviceItem condition) {
        Pager pager = this.iasDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ias:device:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("iasDevice", (Object)this.iasDeviceService.getItemById(id));
        }
        return new ModelAndView("ias/device/editIasDevice");
    }

    @RequiresPermissions(value={"ias:device:edit"})
    @LogChangeRequest(module="ias_module", object="common_leftMenu_device", opType="common_op_edit", vo=IasDeviceItem.class, service=IasDeviceService.class)
    public ZKResultMsg save(IasDeviceItem item) {
        return this.iasDeviceService.saveItem(item);
    }

    @RequiresPermissions(value={"ias:device:del"})
    @LogRequest(module="ias_module", object="common_leftMenu_device", opType="common_op_del", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg del(String ids) {
        if (this.isNeedValid("pwd")) {
            String loginPwd = this.request.getParameter("loginPwd");
            boolean ret = this.authUserService.verifySecurity(this.request.getSession().getId(), loginPwd, "pwd");
            if (!ret) {
                throw new ZKBusinessException("auth_user_pwdIncorrect");
            }
        }
        this.iasDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid listSelect(IasDeviceSelectItem condition) {
        Pager pager = this.iasDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ias:device:setDateTime"})
    @LogRequest(module="ias_module", object="common_leftMenu_device", opType="ias_device_operation_setDateTime", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg setDateTime(String ids) {
        return this.iasDeviceService.setDate(ids);
    }

    public ZKResultMsg getStatusByDevIps(String devIps) {
        ArrayList devStatusList = new ArrayList();
        List<String> ips = Arrays.asList(devIps.split(","));
        ips.forEach(ip -> {
            HashMap<String, String> devStatus = new HashMap<String, String>(4);
            devStatus.put("ip", (String)ip);
            devStatus.put("status", this.iasDeviceService.getStatusByDevIp(ip));
            devStatusList.add(devStatus);
        });
        return new ZKResultMsg(devStatusList);
    }

    public Boolean isNameExist(String name) {
        return this.iasDeviceService.isNameExist(name);
    }

    public Boolean isIpExist(String ip) {
        return this.iasDeviceService.isIpExist(ip);
    }

    public ModelAndView updateDeviceInfoPage(String ids) {
        IasDeviceItem deviceItem = this.iasDeviceService.getItemById(ids);
        this.request.setAttribute("iasDeviceItem", (Object)deviceItem);
        this.request.setAttribute("onlineStatus", (Object)this.iasDeviceService.getStatusByDevIp(deviceItem.getIp()));
        return new ModelAndView("ias/device/updateIasDeviceInfo");
    }

    @RequiresPermissions(value={"ias:device:updateDeviceInfo"})
    @LogRequest(module="ias_module", object="common_leftMenu_device", opType="ias_device_operation_updateDeviceInfo", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg updateDeviceInfo(String ids, String options, Integer userCount) {
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
        Boolean success = this.iasDeviceService.updateDeviceInfo(ids, options, userCount.intValue());
        if (success.booleanValue()) {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        } else {
            this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"common_progress_getDataFailed", (Object[])new Object[0]) + "...</font><br/>");
        }
        return null;
    }

    public TreeItem tree() {
        List iasDeviceItemList = this.iasDeviceService.getByCondition(new IasDeviceItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (IasDeviceItem iasDeviceItem : iasDeviceItemList) {
            TreeItem treeItem = new TreeItem();
            treeItem.setId(iasDeviceItem.getId());
            treeItem.setText(iasDeviceItem.getName());
            items.add(treeItem);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }
}

