/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.web.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ias.constant.IasConstant;
import com.zkteco.zkbiosecurity.ias.remote.IasAlarmEventRemote;
import com.zkteco.zkbiosecurity.ias.service.IasEventService;
import com.zkteco.zkbiosecurity.ias.vo.IasEventItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IasAlarmEventController
extends ExportController
implements IasAlarmEventRemote {
    @Autowired
    private IasEventService iasAlarmRecordService;

    @RequiresPermissions(value={"ias:alarmEvent"})
    public ModelAndView index() {
        return new ModelAndView("ias/alarmEvent/iasAlarmEvent");
    }

    @RequiresPermissions(value={"ias:alarmEvent:refresh"})
    public DxGrid list(IasEventItem condition) {
        condition.setEventType(IasConstant.IAS_EVENT_TYPE_ALARM);
        Pager pager = this.iasAlarmRecordService.loadTransactionByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ias:alarmEvent:del"})
    @LogRequest(module="ias_module", object="ias_leftMenu_alarm", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.iasAlarmRecordService.deleteByType(IasConstant.IAS_EVENT_TYPE_ALARM.shortValue());
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ias:alarmEvent:export"})
    @LogRequest(module="ias_module", object="ias_leftMenu_alarm", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        IasEventItem iasEventItem = new IasEventItem();
        this.setConditionValue((BaseItem)iasEventItem);
        iasEventItem.setEventType(IasConstant.IAS_EVENT_TYPE_ALARM);
        List itemList = this.iasAlarmRecordService.getItemData(request.getSession().getId(), iasEventItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, IasEventItem.class);
    }
}

