/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import jdk.jfr.Recording;
import jdk.management.jfr.Stringifier;

public final class RecordingInfo {
    private final long id;
    private final String name;
    private final String state;
    private final boolean dumpOnExit;
    private final long size;
    private final boolean disk;
    private final long maxAge;
    private final long maxSize;
    private final long startTime;
    private final long stopTime;
    private final String destination;
    private final long durationInSeconds;
    private final Map<String, String> settings;

    RecordingInfo(Recording recording) {
        this.id = recording.getId();
        this.name = recording.getName();
        this.state = recording.getState().toString();
        this.dumpOnExit = recording.getDumpOnExit();
        this.size = recording.getSize();
        this.disk = recording.isToDisk();
        Duration d = recording.getMaxAge();
        this.maxAge = d == null ? 0L : d.getSeconds();
        this.maxSize = recording.getMaxSize();
        Instant s = recording.getStartTime();
        this.startTime = s == null ? 0L : s.toEpochMilli();
        Instant st = recording.getStopTime();
        this.stopTime = st == null ? 0L : st.toEpochMilli();
        Path p = recording.getDestination();
        this.destination = p == null ? null : p.toString();
        Duration duration = recording.getDuration();
        this.durationInSeconds = duration == null ? 0L : duration.getSeconds();
        this.settings = recording.getSettings();
    }

    private RecordingInfo(CompositeData cd) {
        this.id = ((Integer)cd.get("id")).intValue();
        this.name = (String)cd.get("name");
        this.state = (String)cd.get("state");
        this.dumpOnExit = (Boolean)cd.get("dumpOnExit");
        this.size = (Long)cd.get("size");
        this.disk = (Boolean)cd.get("disk");
        this.maxAge = (Long)cd.get("maxAge");
        this.maxSize = (Long)cd.get("maxSize");
        this.startTime = (Long)cd.get("startTime");
        this.stopTime = (Long)cd.get("stopTime");
        this.destination = (String)cd.get("destination");
        this.durationInSeconds = (Long)cd.get("duration");
        this.settings = new LinkedHashMap<String, String>();
        Object map = cd.get("settings");
        if (map instanceof TabularData) {
            TabularData td = (TabularData)map;
            List<String> keyNames = td.getTabularType().getIndexNames();
            int size = keyNames.size();
            for (Object keys : td.keySet()) {
                Object[] keyValues = ((List)keys).toArray();
                for (int i = 0; i < size; ++i) {
                    String key = keyNames.get(i);
                    Object value = keyValues[i];
                    if (!(value instanceof String)) continue;
                    this.settings.put(key, (String)value);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public boolean getDumpOnExit() {
        return this.dumpOnExit;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public String getState() {
        return this.state;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public String getDestination() {
        return this.destination;
    }

    public String toString() {
        Stringifier s = new Stringifier();
        s.add("name", this.name);
        s.add("id", this.id);
        s.add("maxAge", this.maxAge);
        s.add("maxSize", this.maxSize);
        return s.toString();
    }

    public long getSize() {
        return this.size;
    }

    public boolean isToDisk() {
        return this.disk;
    }

    public long getDuration() {
        return this.durationInSeconds;
    }

    public static RecordingInfo from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        return new RecordingInfo(cd);
    }
}

