/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.PrintWriter;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.internal.tool.EventPrintWriter;

final class XMLWriter
extends EventPrintWriter {
    public XMLWriter(PrintWriter destination) {
        super(destination);
    }

    @Override
    protected void printBegin() {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.println("<recording xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        this.indent();
        this.printIndent();
        this.println("<events>");
        this.indent();
    }

    @Override
    protected void printEnd() {
        this.retract();
        this.printIndent();
        this.println("</events>");
        this.retract();
        this.println("</recording>");
    }

    @Override
    protected void print(List<RecordedEvent> events) {
        for (RecordedEvent event : events) {
            this.printEvent(event);
        }
    }

    private void printEvent(RecordedEvent event) {
        EventType type = event.getEventType();
        this.printIndent();
        this.print("<event");
        this.printAttribute("type", type.getName());
        this.print(">");
        this.println();
        this.indent();
        for (ValueDescriptor v : event.getFields()) {
            this.printValueDescriptor(v, this.getValue(event, v), -1);
        }
        this.retract();
        this.printIndent();
        this.println("</event>");
        this.println();
    }

    private void printAttribute(String name, String value) {
        this.print(" ", name, "=\"", value, "\"");
    }

    public void printObject(RecordedObject struct) {
        this.println();
        this.indent();
        for (ValueDescriptor v : struct.getFields()) {
            this.printValueDescriptor(v, this.getValue(struct, v), -1);
        }
        this.retract();
    }

    private void printArray(ValueDescriptor v, Object[] array) {
        this.println();
        this.indent();
        int depth = 0;
        for (int index = 0; index < array.length; ++index) {
            Object arrayElement = array[index];
            if (!(arrayElement instanceof RecordedFrame) || depth < this.getStackDepth()) {
                this.printValueDescriptor(v, array[index], index);
            }
            ++depth;
        }
        this.retract();
    }

    private void printValueDescriptor(ValueDescriptor vd, Object value, int index) {
        String name;
        boolean arrayElement = index != -1;
        String string = name = arrayElement ? null : vd.getName();
        if (vd.isArray() && !arrayElement) {
            if (this.printBeginElement("array", name, value, index)) {
                this.printArray(vd, (Object[])value);
                this.printIndent();
                this.printEndElement("array");
            }
            return;
        }
        if (!vd.getFields().isEmpty()) {
            if (this.printBeginElement("struct", name, value, index)) {
                this.printObject((RecordedObject)value);
                this.printIndent();
                this.printEndElement("struct");
            }
            return;
        }
        if (this.printBeginElement("value", name, value, index)) {
            this.printEscaped(String.valueOf(value));
            this.printEndElement("value");
        }
    }

    private boolean printBeginElement(String elementName, String name, Object value, int index) {
        this.printIndent();
        this.print("<", elementName);
        if (name != null) {
            this.printAttribute("name", name);
        }
        if (index != -1) {
            this.printAttribute("index", Integer.toString(index));
        }
        if (value == null) {
            this.printAttribute("xsi:nil", "true");
            this.println("/>");
            return false;
        }
        if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            this.printAttribute("size", Integer.toString(array.length));
        }
        this.print(">");
        return true;
    }

    private void printEndElement(String elementName) {
        this.print("</");
        this.print(elementName);
        this.println(">");
    }

    private void printEscaped(String text) {
        for (int i = 0; i < text.length(); ++i) {
            this.printEscaped(text.charAt(i));
        }
    }

    private void printEscaped(char c) {
        if (c == '\"') {
            this.print("&quot;");
            return;
        }
        if (c == '&') {
            this.print("&amp;");
            return;
        }
        if (c == '\'') {
            this.print("&apos;");
            return;
        }
        if (c == '<') {
            this.print("&lt;");
            return;
        }
        if (c == '>') {
            this.print("&gt;");
            return;
        }
        if (c > '\u007f') {
            this.print("&#");
            this.print((int)c);
            this.print(';');
            return;
        }
        this.print(c);
    }
}

