/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.settings;

import java.util.Set;

final class BooleanValue {
    private String value = "false";
    private boolean booleanValue;

    private BooleanValue(boolean b) {
        this.booleanValue = b;
        this.value = b ? "true" : "false";
    }

    public String union(Set<String> values) {
        for (String v : values) {
            if (!"true".equals(v)) continue;
            return "true";
        }
        return "false";
    }

    public void setValue(String value) {
        this.value = value;
        this.booleanValue = Boolean.valueOf(value);
    }

    public final String getValue() {
        return this.value;
    }

    public boolean getBoolean() {
        return this.booleanValue;
    }

    public static BooleanValue valueOf(String defaultValue) {
        if ("true".equals(defaultValue)) {
            return new BooleanValue(true);
        }
        if ("false".equals(defaultValue)) {
            return new BooleanValue(false);
        }
        throw new InternalError("Unknown default value for settings '" + defaultValue + "'");
    }
}

