/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.management;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.instrument.JDKEvents;

public final class ManagementSupport {
    public static List<EventType> getEventTypes() {
        Utils.checkAccessFlightRecorder();
        if (JVMSupport.isNotAvailable()) {
            return new ArrayList<EventType>();
        }
        JDKEvents.initialize();
        return Collections.unmodifiableList(MetadataRepository.getInstance().getRegisteredEventTypes());
    }

    public static long parseTimespan(String s) {
        return Utils.parseTimespan(s);
    }

    public static final String formatTimespan(Duration dValue, String separation) {
        return Utils.formatTimespan(dValue, separation);
    }

    public static void logError(String message) {
        Logger.log(LogTag.JFR, LogLevel.ERROR, message);
    }
}

