/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.jfc;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import jdk.internal.org.xml.sax.InputSource;
import jdk.internal.org.xml.sax.SAXException;
import jdk.internal.org.xml.sax.helpers.DefaultHandler;
import jdk.internal.util.xml.SAXParser;
import jdk.internal.util.xml.impl.SAXParserImpl;
import jdk.jfr.Configuration;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.jfc.JFCParserHandler;

final class JFCParser {
    static final String FILE_EXTENSION = ".jfc";
    private static final int MAXIMUM_FILE_SIZE = 0x100000;

    JFCParser() {
    }

    public static Configuration createConfiguration(String name, Reader reader) throws IOException, ParseException {
        return JFCParser.createConfiguration(name, JFCParser.readContent(reader));
    }

    public static Configuration createConfiguration(String name, String content) throws IOException, ParseException {
        try {
            JFCParserHandler ch = new JFCParserHandler();
            JFCParser.parseXML(content, ch);
            return PrivateAccess.getInstance().newConfiguration(name, ch.label, ch.description, ch.provider, ch.settings, content);
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException(iae.getMessage(), -1);
        }
        catch (SAXException e) {
            ParseException pe = new ParseException("Error reading JFC file. " + e.getMessage(), -1);
            pe.initCause(e);
            throw pe;
        }
    }

    private static void parseXML(String content, JFCParserHandler ch) throws SAXException, IOException {
        CharArrayReader r = new CharArrayReader(content.toCharArray());
        SAXParserImpl parser = new SAXParserImpl();
        ((SAXParser)parser).parse(new InputSource(r), (DefaultHandler)ch);
    }

    private static String readContent(Reader r) throws IOException {
        int ch;
        CharArrayWriter writer = new CharArrayWriter(1024);
        int count = 0;
        while ((ch = r.read()) != -1) {
            writer.write(ch);
            if (++count < 0x100000) continue;
            throw new IOException("Presets with more than 1048576 characters can't be read.");
        }
        return new String(writer.toCharArray());
    }
}

