/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import java.net.InetAddress;
import jdk.jfr.events.SocketReadEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;
import jdk.jfr.internal.instrument.JITypeMapping;

@JIInstrumentationTarget(value="java.net.SocketInputStream")
@JITypeMapping(from="jdk.jfr.internal.instrument.SocketInputStreamInstrumentor$AbstractPlainSocketImpl", to="java.net.AbstractPlainSocketImpl")
final class SocketInputStreamInstrumentor {
    private AbstractPlainSocketImpl impl = null;

    private SocketInputStreamInstrumentor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    int read(byte[] b, int off, int length, int timeout) throws IOException {
        SocketReadEvent event = SocketReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read(b, off, length, timeout);
        }
        int bytesRead = 0;
        try {
            event.begin();
            bytesRead = this.read(b, off, length, timeout);
        }
        finally {
            event.end();
            if (event.shouldCommit()) {
                String hostString = this.impl.address.toString();
                int delimiterIndex = hostString.lastIndexOf(47);
                event.host = hostString.substring(0, delimiterIndex);
                event.address = hostString.substring(delimiterIndex + 1);
                event.port = this.impl.port;
                if (bytesRead < 0) {
                    event.endOfStream = true;
                } else {
                    event.bytesRead = bytesRead;
                }
                event.timeout = timeout;
                event.commit();
                event.reset();
            }
        }
        return bytesRead;
    }

    void silenceFindBugsUnwrittenField(InetAddress dummy) {
        this.impl.address = dummy;
    }

    static class AbstractPlainSocketImpl {
        InetAddress address;
        int port;

        AbstractPlainSocketImpl() {
        }
    }
}

