/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import jdk.jfr.events.FileReadEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;

@JIInstrumentationTarget(value="java.io.FileInputStream")
final class FileInputStreamInstrumentor {
    private String path;

    private FileInputStreamInstrumentor() {
    }

    @JIInstrumentationMethod
    public int read() throws IOException {
        FileReadEvent event = FileReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read();
        }
        int result = 0;
        try {
            event.begin();
            result = this.read();
            if (result < 0) {
                event.endOfFile = true;
            } else {
                event.bytesRead = 1L;
            }
        }
        finally {
            event.path = this.path;
            event.commit();
            event.reset();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(byte[] b) throws IOException {
        FileReadEvent event = FileReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read(b);
        }
        int bytesRead = 0;
        try {
            event.begin();
            bytesRead = this.read(b);
        }
        finally {
            if (bytesRead < 0) {
                event.endOfFile = true;
            } else {
                event.bytesRead = bytesRead;
            }
            event.path = this.path;
            event.commit();
            event.reset();
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(byte[] b, int off, int len) throws IOException {
        FileReadEvent event = FileReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read(b, off, len);
        }
        int bytesRead = 0;
        try {
            event.begin();
            bytesRead = this.read(b, off, len);
        }
        finally {
            if (bytesRead < 0) {
                event.endOfFile = true;
            } else {
                event.bytesRead = bytesRead;
            }
            event.path = this.path;
            event.commit();
            event.reset();
        }
        return bytesRead;
    }
}

