/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TimerTask;
import java.util.TreeMap;
import jdk.jfr.Configuration;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.ChunkInputStream;
import jdk.jfr.internal.ChunksChannel;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.OldObjectSample;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.RepositoryChunk;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.WriteableUserPath;

public final class PlatformRecording
implements AutoCloseable {
    private final PlatformRecorder recorder;
    private final long id;
    private Map<String, String> settings = new LinkedHashMap<String, String>();
    private Duration duration;
    private Duration maxAge;
    private long maxSize;
    private WriteableUserPath destination;
    private boolean toDisk = true;
    private String name;
    private boolean dumpOnExit;
    private SecuritySupport.SafePath dumpOnExitDirectory = new SecuritySupport.SafePath(".");
    private Instant stopTime;
    private Instant startTime;
    private RecordingState state = RecordingState.NEW;
    private long size;
    private final LinkedList<RepositoryChunk> chunks = new LinkedList();
    private volatile Recording recording;
    private TimerTask stopTask;
    private TimerTask startTask;
    private AccessControlContext noDestinationDumpOnExitAccessControlContext = AccessController.getContext();
    private boolean shuoldWriteActiveRecordingEvent = true;

    PlatformRecording(PlatformRecorder recorder, long id) {
        this.id = id;
        this.recorder = recorder;
        this.name = String.valueOf(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        RecordingState newState;
        RecordingState oldState;
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            oldState = this.getState();
            if (!Utils.isBefore(this.state, RecordingState.RUNNING)) {
                throw new IllegalStateException("Recording can only be started once.");
            }
            if (this.startTask != null) {
                this.startTask.cancel();
                this.startTask = null;
                this.startTime = null;
            }
            this.recorder.start(this);
            Logger.log(LogTag.JFR, LogLevel.INFO, () -> {
                String optionText;
                StringJoiner options = new StringJoiner(", ");
                if (!this.toDisk) {
                    options.add("disk=false");
                }
                if (this.maxAge != null) {
                    options.add("maxage=" + Utils.formatTimespan(this.maxAge, ""));
                }
                if (this.maxSize != 0L) {
                    options.add("maxsize=" + Utils.formatBytesCompact(this.maxSize));
                }
                if (this.dumpOnExit) {
                    options.add("dumponexit=true");
                }
                if (this.duration != null) {
                    options.add("duration=" + Utils.formatTimespan(this.duration, ""));
                }
                if (this.destination != null) {
                    options.add("filename=" + this.destination.getText());
                }
                if ((optionText = options.toString()).length() != 0) {
                    optionText = "{" + optionText + "}";
                }
                return "Started recording \"" + this.getName() + "\" (" + this.getId() + ") " + optionText;
            });
            newState = this.getState();
        }
        this.notifyIfStateChanged(oldState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(String reason) {
        RecordingState newState;
        RecordingState oldState;
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            oldState = this.getState();
            if (this.stopTask != null) {
                this.stopTask.cancel();
                this.stopTask = null;
            }
            this.recorder.stop(this);
            String endText = reason == null ? "" : ". Reason \"" + reason + "\".";
            Logger.log(LogTag.JFR, LogLevel.INFO, "Stopped recording \"" + this.getName() + "\" (" + this.getId() + ")" + endText);
            this.stopTime = Instant.now();
            newState = this.getState();
        }
        WriteableUserPath dest = this.getDestination();
        if (dest != null) {
            try {
                this.dumpStopped(dest);
                Logger.log(LogTag.JFR, LogLevel.INFO, "Wrote recording \"" + this.getName() + "\" (" + this.getId() + ") to " + dest.getText());
                this.notifyIfStateChanged(newState, oldState);
                this.close();
            }
            catch (IOException iOException) {}
        } else {
            this.notifyIfStateChanged(newState, oldState);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleStart(Duration delay) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.ensureOkForSchedule();
            this.startTime = Instant.now().plus(delay);
            LocalDateTime now = LocalDateTime.now().plus(delay);
            this.setState(RecordingState.DELAYED);
            this.startTask = this.createStartTask();
            this.recorder.getTimer().schedule(this.startTask, delay.toMillis());
            Logger.log(LogTag.JFR, LogLevel.INFO, "Scheduled recording \"" + this.getName() + "\" (" + this.getId() + ") to start at " + now);
        }
    }

    private void ensureOkForSchedule() {
        if (this.getState() != RecordingState.NEW) {
            throw new IllegalStateException("Only a new recoridng can be scheduled for start");
        }
    }

    private TimerTask createStartTask() {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PlatformRecorder platformRecorder = PlatformRecording.this.recorder;
                synchronized (platformRecorder) {
                    if (PlatformRecording.this.getState() != RecordingState.DELAYED) {
                        return;
                    }
                    PlatformRecording.this.start();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleStart(Instant startTime) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.ensureOkForSchedule();
            this.startTime = startTime;
            this.setState(RecordingState.DELAYED);
            this.startTask = this.createStartTask();
            this.recorder.getTimer().schedule(this.startTask, startTime.toEpochMilli());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSettings() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.settings;
        }
    }

    public long getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instant getStopTime() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.stopTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instant getStartTime() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getMaxSize() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.maxSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration getMaxAge() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.maxAge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordingState getState() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RecordingState newState;
        RecordingState oldState;
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            oldState = this.getState();
            if (RecordingState.CLOSED != this.getState()) {
                if (this.startTask != null) {
                    this.startTask.cancel();
                    this.startTask = null;
                }
                this.recorder.finish(this);
                for (RepositoryChunk c : this.chunks) {
                    this.removed(c);
                }
                this.chunks.clear();
                this.setState(RecordingState.CLOSED);
                Logger.log(LogTag.JFR, LogLevel.INFO, "Closed recording \"" + this.getName() + "\" (" + this.getId() + ")");
            }
            newState = this.getState();
        }
        this.notifyIfStateChanged(newState, oldState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlatformRecording newSnapshotClone(String reason, Boolean pathToGcRoots) throws IOException {
        if (!Thread.holdsLock(this.recorder)) {
            throw new InternalError("Caller must have recorder lock");
        }
        RecordingState state = this.getState();
        if (state == RecordingState.CLOSED) {
            throw new IOException("Recording \"" + this.name + "\" (id=" + this.id + ") has been closed, no contents to write");
        }
        if (state == RecordingState.DELAYED || state == RecordingState.NEW) {
            throw new IOException("Recording \"" + this.name + "\" (id=" + this.id + ") has not started, no contents to write");
        }
        if (state == RecordingState.STOPPED) {
            PlatformRecording clone = this.recorder.newTemporaryRecording();
            for (RepositoryChunk r : this.chunks) {
                clone.add(r);
            }
            return clone;
        }
        PlatformRecording clone = this.recorder.newTemporaryRecording();
        clone.setShouldWriteActiveRecordingEvent(false);
        clone.setName(this.getName());
        clone.setDestination(this.destination);
        clone.setToDisk(true);
        if (!this.isToDisk()) {
            clone.start();
        } else {
            for (RepositoryChunk c : this.chunks) {
                clone.add(c);
            }
            clone.setState(RecordingState.RUNNING);
            clone.setStartTime(this.getStartTime());
        }
        if (pathToGcRoots == null) {
            clone.setSettings(this.getSettings());
            clone.stop(reason);
        } else {
            MetadataRepository metadataRepository = MetadataRepository.getInstance();
            synchronized (metadataRepository) {
                clone.setSettings(OldObjectSample.createSettingsForSnapshot(this, pathToGcRoots));
                clone.stop(reason);
            }
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isToDisk() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.toDisk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(long maxSize) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (this.getState() == RecordingState.CLOSED) {
                throw new IllegalStateException("Can't set max age when recording is closed");
            }
            this.maxSize = maxSize;
            this.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestination(WriteableUserPath userSuppliedPath) throws IOException {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (Utils.isState(this.getState(), RecordingState.STOPPED, RecordingState.CLOSED)) {
                throw new IllegalStateException("Destination can't be set on a recording that has been stopped/closed");
            }
            this.destination = userSuppliedPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteableUserPath getDestination() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.destination;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(RecordingState state) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStartTime(Instant startTime) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.startTime = startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStopTime(Instant timeStamp) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.stopTime = timeStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getId() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.ensureNotClosed();
            this.name = name;
        }
    }

    private void ensureNotClosed() {
        if (this.getState() == RecordingState.CLOSED) {
            throw new IllegalStateException("Can't change name on a closed recording");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDumpOnExit(boolean dumpOnExit) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.dumpOnExit = dumpOnExit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDumpOnExit() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.dumpOnExit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToDisk(boolean toDisk) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (!Utils.isState(this.getState(), RecordingState.NEW, RecordingState.DELAYED)) {
                throw new IllegalStateException("Recording option disk can't be changed after recording has started");
            }
            this.toDisk = toDisk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSetting(String id, String value) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.settings.put(id, value);
            if (this.getState() == RecordingState.RUNNING) {
                this.recorder.updateSettings();
            }
        }
    }

    public void setSettings(Map<String, String> settings) {
        this.setSettings(settings, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSettings(Map<String, String> settings, boolean update) {
        if (Logger.shouldLog(LogTag.JFR_SETTING, LogLevel.INFO) && update) {
            TreeMap<String, String> ordered = new TreeMap<String, String>(settings);
            Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, "New settings for recording \"" + this.getName() + "\" (" + this.getId() + ")");
            for (Map.Entry<String, String> entry : ordered.entrySet()) {
                String text = entry.getKey() + "=\"" + entry.getValue() + "\"";
                Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, text);
            }
        }
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.settings = new LinkedHashMap<String, String>(settings);
            if (this.getState() == RecordingState.RUNNING && update) {
                this.recorder.updateSettings();
            }
        }
    }

    private void notifyIfStateChanged(RecordingState newState, RecordingState oldState) {
        if (oldState == newState) {
            return;
        }
        for (FlightRecorderListener cl : PlatformRecorder.getListeners()) {
            try {
                cl.recordingStateChanged(this.getRecording());
            }
            catch (RuntimeException re) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Error notifying recorder listener:" + re.getMessage());
            }
        }
    }

    public void setRecording(Recording recording) {
        this.recording = recording;
    }

    public Recording getRecording() {
        return this.recording;
    }

    public String toString() {
        return this.getName() + " (id=" + this.getId() + ") " + (Object)((Object)this.getState());
    }

    public void setConfiguration(Configuration c) {
        this.setSettings(c.getSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxAge(Duration maxAge) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (this.getState() == RecordingState.CLOSED) {
                throw new IllegalStateException("Can't set max age when recording is closed");
            }
            this.maxAge = maxAge;
            if (maxAge != null) {
                this.trimToAge(Instant.now().minus(maxAge));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendChunk(RepositoryChunk chunk) {
        if (!chunk.isFinished()) {
            throw new Error("not finished chunk " + chunk.getStartTime());
        }
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (!this.toDisk) {
                return;
            }
            if (this.maxAge != null) {
                this.trimToAge(chunk.getEndTime().minus(this.maxAge));
            }
            this.chunks.addLast(chunk);
            this.added(chunk);
            this.trimToSize();
        }
    }

    private void trimToSize() {
        if (this.maxSize == 0L) {
            return;
        }
        while (this.size > this.maxSize && this.chunks.size() > 1) {
            RepositoryChunk c = this.chunks.removeFirst();
            this.removed(c);
        }
    }

    private void trimToAge(Instant oldest) {
        while (!this.chunks.isEmpty()) {
            RepositoryChunk oldestChunk = this.chunks.peek();
            if (oldestChunk.getEndTime().isAfter(oldest)) {
                return;
            }
            this.chunks.removeFirst();
            this.removed(oldestChunk);
        }
    }

    void add(RepositoryChunk c) {
        this.chunks.add(c);
        this.added(c);
    }

    private void added(RepositoryChunk c) {
        c.use();
        this.size += c.getSize();
        Logger.log(LogTag.JFR, LogLevel.DEBUG, () -> "Recording \"" + this.name + "\" (" + this.id + ") added chunk " + c.toString() + ", current size=" + this.size);
    }

    private void removed(RepositoryChunk c) {
        this.size -= c.getSize();
        Logger.log(LogTag.JFR, LogLevel.DEBUG, () -> "Recording \"" + this.name + "\" (" + this.id + ") removed chunk " + c.toString() + ", current size=" + this.size);
        c.release();
    }

    public List<RepositoryChunk> getChunks() {
        return this.chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream open(Instant start, Instant end) throws IOException {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (this.getState() != RecordingState.STOPPED) {
                throw new IOException("Recording must be stopped before it can be read.");
            }
            ArrayList<RepositoryChunk> chunksToUse = new ArrayList<RepositoryChunk>();
            for (RepositoryChunk chunk : this.chunks) {
                if (!chunk.isFinished()) continue;
                Instant chunkStart = chunk.getStartTime();
                Instant chunkEnd = chunk.getEndTime();
                if (start != null && chunkEnd.isBefore(start) || end != null && chunkStart.isAfter(end)) continue;
                chunksToUse.add(chunk);
            }
            if (chunksToUse.isEmpty()) {
                return null;
            }
            return new ChunkInputStream(chunksToUse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration getDuration() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.duration;
        }
    }

    void setInternalDuration(Duration duration) {
        this.duration = duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDuration(Duration duration) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (Utils.isState(this.getState(), RecordingState.STOPPED, RecordingState.CLOSED)) {
                throw new IllegalStateException("Duration can't be set after a recording has been stopped/closed");
            }
            this.setInternalDuration(duration);
            if (this.getState() != RecordingState.NEW) {
                this.updateTimer();
            }
        }
    }

    void updateTimer() {
        if (this.stopTask != null) {
            this.stopTask.cancel();
            this.stopTask = null;
        }
        if (this.getState() == RecordingState.CLOSED) {
            return;
        }
        if (this.duration != null) {
            this.stopTask = this.createStopTask();
            this.recorder.getTimer().schedule(this.stopTask, new Date(this.startTime.plus(this.duration).toEpochMilli()));
        }
    }

    TimerTask createStopTask() {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    PlatformRecording.this.stop("End of duration reached");
                }
                catch (Throwable t) {
                    Logger.log(LogTag.JFR, LogLevel.ERROR, "Could not stop recording.");
                }
            }
        };
    }

    public Recording newCopy(boolean stop) {
        return this.recorder.newCopy(this, stop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStopTask(TimerTask stopTask) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.stopTask = stopTask;
        }
    }

    void clearDestination() {
        this.destination = null;
    }

    public AccessControlContext getNoDestinationDumpOnExitAccessControlContext() {
        return this.noDestinationDumpOnExitAccessControlContext;
    }

    void setShouldWriteActiveRecordingEvent(boolean shouldWrite) {
        this.shuoldWriteActiveRecordingEvent = shouldWrite;
    }

    boolean shouldWriteMetadataEvent() {
        return this.shuoldWriteActiveRecordingEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(WriteableUserPath writeableUserPath) throws IOException {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            try (PlatformRecording p = this.newSnapshotClone("Dumped by user", null);){
                p.dumpStopped(writeableUserPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpStopped(WriteableUserPath userPath) throws IOException {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            userPath.doPriviligedIO(() -> {
                try (ChunksChannel cc = new ChunksChannel(this.chunks);
                     FileChannel fc = FileChannel.open(userPath.getReal(), StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
                    cc.transferTo(fc);
                    fc.force(true);
                }
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(Instant begin, Instant end, Long maxSize) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            List<RepositoryChunk> result = PlatformRecording.removeAfter(end, PlatformRecording.removeBefore(begin, new ArrayList<RepositoryChunk>(this.chunks)));
            if (maxSize != null) {
                result = begin != null && end == null ? PlatformRecording.reduceFromBeginning(maxSize, result) : PlatformRecording.reduceFromEnd(maxSize, result);
            }
            int size = 0;
            for (RepositoryChunk r : result) {
                size = (int)((long)size + r.getSize());
                r.use();
            }
            this.size = size;
            for (RepositoryChunk r : this.chunks) {
                r.release();
            }
            this.chunks.clear();
            this.chunks.addAll(result);
        }
    }

    private static List<RepositoryChunk> removeBefore(Instant time, List<RepositoryChunk> input) {
        if (time == null) {
            return input;
        }
        ArrayList<RepositoryChunk> result = new ArrayList<RepositoryChunk>(input.size());
        for (RepositoryChunk r : input) {
            if (r.getEndTime().isBefore(time)) continue;
            result.add(r);
        }
        return result;
    }

    private static List<RepositoryChunk> removeAfter(Instant time, List<RepositoryChunk> input) {
        if (time == null) {
            return input;
        }
        ArrayList<RepositoryChunk> result = new ArrayList<RepositoryChunk>(input.size());
        for (RepositoryChunk r : input) {
            if (r.getStartTime().isAfter(time)) continue;
            result.add(r);
        }
        return result;
    }

    private static List<RepositoryChunk> reduceFromBeginning(Long maxSize, List<RepositoryChunk> input) {
        if (maxSize == null || input.isEmpty()) {
            return input;
        }
        ArrayList<RepositoryChunk> result = new ArrayList<RepositoryChunk>(input.size());
        long total = 0L;
        for (RepositoryChunk r : input) {
            if ((total += r.getSize()) > maxSize) break;
            result.add(r);
        }
        if (result.isEmpty()) {
            result.add(input.get(0));
        }
        return result;
    }

    private static List<RepositoryChunk> reduceFromEnd(Long maxSize, List<RepositoryChunk> input) {
        Collections.reverse(input);
        List<RepositoryChunk> result = PlatformRecording.reduceFromBeginning(maxSize, input);
        Collections.reverse(result);
        return result;
    }

    public void setDumpOnExitDirectory(SecuritySupport.SafePath directory) {
        this.dumpOnExitDirectory = directory;
    }

    public SecuritySupport.SafePath getDumpOnExitDirectory() {
        return this.dumpOnExitDirectory;
    }
}

