/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import jdk.jfr.events.ActiveRecordingEvent;
import jdk.jfr.events.ActiveSettingEvent;
import jdk.jfr.internal.EventControl;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.OldObjectSample;
import jdk.jfr.internal.Options;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.RepositoryChunk;
import jdk.jfr.internal.RequestEngine;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.ShutdownHook;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.WriteableUserPath;
import jdk.jfr.internal.instrument.JDKEvents;

public final class PlatformRecorder {
    private final List<PlatformRecording> recordings = new ArrayList<PlatformRecording>();
    private static final List<SecuritySupport.SecureRecorderListener> changeListeners = new ArrayList<SecuritySupport.SecureRecorderListener>();
    private final Repository repository = Repository.getRepository();
    private final Timer timer;
    private static final JVM jvm = JVM.getJVM();
    private final EventType activeRecordingEvent;
    private final EventType activeSettingEvent;
    private final Thread shutdownHook;
    private long recordingCounter = 0L;
    private RepositoryChunk currentChunk;

    public PlatformRecorder() throws Exception {
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Initialized disk repository");
        this.repository.ensureRepository();
        jvm.createNativeJFR();
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Created native");
        JDKEvents.initialize();
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Registered JDK events");
        JDKEvents.addInstrumentation();
        this.startDiskMonitor();
        SecuritySupport.registerEvent(ActiveRecordingEvent.class);
        this.activeRecordingEvent = EventType.getEventType(ActiveRecordingEvent.class);
        SecuritySupport.registerEvent(ActiveSettingEvent.class);
        this.activeSettingEvent = EventType.getEventType(ActiveSettingEvent.class);
        this.shutdownHook = SecuritySupport.createThreadWitNoPermissions("JFR: Shutdown Hook", new ShutdownHook(this));
        SecuritySupport.setUncaughtExceptionHandler(this.shutdownHook, new ShutdownHook.ExceptionHandler());
        SecuritySupport.registerShutdownHook(this.shutdownHook);
        this.timer = PlatformRecorder.createTimer();
    }

    private static Timer createTimer() {
        try {
            CopyOnWriteArrayList result = new CopyOnWriteArrayList();
            Thread t = SecuritySupport.createThreadWitNoPermissions("Permissionless thread", () -> result.add(new Timer("JFR Recording Scheduler", true)));
            t.start();
            t.join();
            return (Timer)result.get(0);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Not able to create timer task. " + e.getMessage(), e);
        }
    }

    public synchronized PlatformRecording newRecording(Map<String, String> settings) {
        return this.newRecording(settings, ++this.recordingCounter);
    }

    public PlatformRecording newTemporaryRecording() {
        if (!Thread.holdsLock(this)) {
            throw new InternalError("Caller must have recorder lock");
        }
        return this.newRecording(new HashMap<String, String>(), 0L);
    }

    private synchronized PlatformRecording newRecording(Map<String, String> settings, long id) {
        PlatformRecording recording = new PlatformRecording(this, id);
        if (!settings.isEmpty()) {
            recording.setSettings(settings);
        }
        this.recordings.add(recording);
        return recording;
    }

    synchronized void finish(PlatformRecording recording) {
        if (recording.getState() == RecordingState.RUNNING) {
            recording.stop("Recording closed");
        }
        this.recordings.remove(recording);
    }

    public synchronized List<PlatformRecording> getRecordings() {
        return Collections.unmodifiableList(new ArrayList<PlatformRecording>(this.recordings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addListener(FlightRecorderListener changeListener) {
        AccessControlContext context = AccessController.getContext();
        SecuritySupport.SecureRecorderListener sl = new SecuritySupport.SecureRecorderListener(context, changeListener);
        Class<PlatformRecorder> clazz = PlatformRecorder.class;
        synchronized (PlatformRecorder.class) {
            boolean runInitialized = FlightRecorder.isInitialized();
            changeListeners.add(sl);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (runInitialized) {
                sl.recorderInitialized(FlightRecorder.getFlightRecorder());
            }
            return;
        }
    }

    public static synchronized boolean removeListener(FlightRecorderListener changeListener) {
        for (SecuritySupport.SecureRecorderListener s : new ArrayList<SecuritySupport.SecureRecorderListener>(changeListeners)) {
            if (s.getChangeListener() != changeListener) continue;
            changeListeners.remove(s);
            return true;
        }
        return false;
    }

    static synchronized List<FlightRecorderListener> getListeners() {
        return new ArrayList<FlightRecorderListener>(changeListeners);
    }

    Timer getTimer() {
        return this.timer;
    }

    public static void notifyRecorderInitialized(FlightRecorder recorder) {
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.TRACE, "Notifying listeners that Flight Recorder is initialized");
        for (FlightRecorderListener r : PlatformRecorder.getListeners()) {
            r.recorderInitialized(recorder);
        }
    }

    synchronized void destroy() {
        try {
            this.timer.cancel();
        }
        catch (Exception ex) {
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.WARN, "Shutdown hook could not cancel timer");
        }
        for (PlatformRecording p : this.getRecordings()) {
            if (p.getState() != RecordingState.RUNNING) continue;
            try {
                p.stop("Shutdown");
            }
            catch (Exception ex) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Recording " + p.getName() + ":" + p.getId() + " could not be stopped");
            }
        }
        JDKEvents.remove();
        if (jvm.hasNativeJFR()) {
            if (jvm.isRecording()) {
                jvm.endRecording_();
            }
            jvm.destroyNativeJFR();
        }
        this.repository.clear();
    }

    synchronized void start(PlatformRecording recording) {
        RepositoryChunk newChunk;
        Instant now = Instant.now();
        recording.setStartTime(now);
        recording.updateTimer();
        Duration duration = recording.getDuration();
        if (duration != null) {
            recording.setStopTime(now.plus(duration));
        }
        boolean toDisk = recording.isToDisk();
        boolean beginPhysical = true;
        for (PlatformRecording s : this.getRecordings()) {
            if (s.getState() != RecordingState.RUNNING) continue;
            beginPhysical = false;
            if (!s.isToDisk()) continue;
            toDisk = true;
        }
        if (beginPhysical) {
            newChunk = null;
            if (toDisk) {
                newChunk = this.repository.newChunk(now);
                MetadataRepository.getInstance().setOutput(newChunk.getUnfishedFile().toString());
            } else {
                MetadataRepository.getInstance().setOutput(null);
            }
            this.currentChunk = newChunk;
            jvm.beginRecording_();
            recording.setState(RecordingState.RUNNING);
            this.updateSettings();
            this.writeMetaEvents();
        } else {
            newChunk = null;
            if (toDisk) {
                newChunk = this.repository.newChunk(now);
                RequestEngine.doChunkEnd();
                MetadataRepository.getInstance().setOutput(newChunk.getUnfishedFile().toString());
            }
            recording.setState(RecordingState.RUNNING);
            this.updateSettings();
            this.writeMetaEvents();
            if (this.currentChunk != null) {
                this.finishChunk(this.currentChunk, now, recording);
            }
            this.currentChunk = newChunk;
        }
        RequestEngine.doChunkBegin();
    }

    synchronized void stop(PlatformRecording recording) {
        RecordingState state = recording.getState();
        if (Utils.isAfter(state, RecordingState.RUNNING)) {
            throw new IllegalStateException("Can't stop an already stopped recording.");
        }
        if (Utils.isBefore(state, RecordingState.RUNNING)) {
            throw new IllegalStateException("Recording must be started before it can be stopped.");
        }
        Instant now = Instant.now();
        boolean toDisk = false;
        boolean endPhysical = true;
        for (PlatformRecording s : this.getRecordings()) {
            RecordingState rs = s.getState();
            if (s == recording || RecordingState.RUNNING != rs) continue;
            endPhysical = false;
            if (!s.isToDisk()) continue;
            toDisk = true;
        }
        OldObjectSample.emit(recording);
        if (endPhysical) {
            RequestEngine.doChunkEnd();
            if (recording.isToDisk()) {
                if (this.currentChunk != null) {
                    MetadataRepository.getInstance().setOutput(null);
                    this.finishChunk(this.currentChunk, now, null);
                    this.currentChunk = null;
                }
            } else {
                this.dumpMemoryToDestination(recording);
            }
            jvm.endRecording_();
            this.disableEvents();
        } else {
            RepositoryChunk newChunk = null;
            RequestEngine.doChunkEnd();
            this.updateSettingsButIgnoreRecording(recording);
            if (toDisk) {
                newChunk = this.repository.newChunk(now);
                MetadataRepository.getInstance().setOutput(newChunk.getUnfishedFile().toString());
            } else {
                MetadataRepository.getInstance().setOutput(null);
            }
            this.writeMetaEvents();
            if (this.currentChunk != null) {
                this.finishChunk(this.currentChunk, now, null);
            }
            this.currentChunk = newChunk;
            RequestEngine.doChunkBegin();
        }
        recording.setState(RecordingState.STOPPED);
    }

    private void dumpMemoryToDestination(PlatformRecording recording) {
        WriteableUserPath dest = recording.getDestination();
        if (dest != null) {
            MetadataRepository.getInstance().setOutput(dest.getText());
            recording.clearDestination();
        }
    }

    private void disableEvents() {
        MetadataRepository.getInstance().disableEvents();
    }

    void updateSettings() {
        this.updateSettingsButIgnoreRecording(null);
    }

    void updateSettingsButIgnoreRecording(PlatformRecording ignoreMe) {
        List<PlatformRecording> recordings = this.getRunningRecordings();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(recordings.size());
        for (PlatformRecording r : recordings) {
            if (r == ignoreMe) continue;
            list.add(r.getSettings());
        }
        MetadataRepository.getInstance().setSettings(list);
    }

    synchronized void rotateDisk() {
        Instant now = Instant.now();
        RepositoryChunk newChunk = this.repository.newChunk(now);
        RequestEngine.doChunkEnd();
        MetadataRepository.getInstance().setOutput(newChunk.getUnfishedFile().toString());
        this.writeMetaEvents();
        if (this.currentChunk != null) {
            this.finishChunk(this.currentChunk, now, null);
        }
        this.currentChunk = newChunk;
        RequestEngine.doChunkBegin();
    }

    private List<PlatformRecording> getRunningRecordings() {
        ArrayList<PlatformRecording> runningRecordings = new ArrayList<PlatformRecording>();
        for (PlatformRecording recording : this.getRecordings()) {
            if (recording.getState() != RecordingState.RUNNING) continue;
            runningRecordings.add(recording);
        }
        return runningRecordings;
    }

    private List<RepositoryChunk> makeChunkList(Instant startTime, Instant endTime) {
        HashSet<RepositoryChunk> chunkSet = new HashSet<RepositoryChunk>();
        for (PlatformRecording r : this.getRecordings()) {
            chunkSet.addAll(r.getChunks());
        }
        if (chunkSet.size() > 0) {
            ArrayList<RepositoryChunk> chunks = new ArrayList<RepositoryChunk>(chunkSet.size());
            for (RepositoryChunk rc : chunkSet) {
                if (!rc.inInterval(startTime, endTime)) continue;
                chunks.add(rc);
            }
            Collections.sort(chunks, RepositoryChunk.END_TIME_COMPARATOR);
            return chunks;
        }
        return Collections.emptyList();
    }

    private void startDiskMonitor() {
        Thread t = SecuritySupport.createThreadWitNoPermissions("JFR Periodic Tasks", () -> this.periodicTask());
        SecuritySupport.setDaemonThread(t, true);
        t.start();
    }

    private void finishChunk(RepositoryChunk chunk, Instant time, PlatformRecording ignoreMe) {
        chunk.finish(time);
        for (PlatformRecording r : this.getRecordings()) {
            if (r == ignoreMe || r.getState() != RecordingState.RUNNING) continue;
            r.appendChunk(chunk);
        }
    }

    private void writeMetaEvents() {
        if (this.activeRecordingEvent.isEnabled()) {
            for (PlatformRecording r : this.getRecordings()) {
                if (r.getState() != RecordingState.RUNNING || !r.shouldWriteMetadataEvent()) continue;
                ActiveRecordingEvent event = new ActiveRecordingEvent();
                event.id = r.getId();
                event.name = r.getName();
                WriteableUserPath p = r.getDestination();
                event.destination = p == null ? null : p.getText();
                Duration d = r.getDuration();
                event.recordingDuration = d == null ? Long.MAX_VALUE : d.toMillis();
                Duration age = r.getMaxAge();
                event.maxAge = age == null ? Long.MAX_VALUE : age.toMillis();
                Long size = r.getMaxSize();
                event.maxSize = size == null ? Long.MAX_VALUE : size;
                Instant start = r.getStartTime();
                event.recordingStart = start == null ? Long.MAX_VALUE : start.toEpochMilli();
                event.commit();
            }
        }
        if (this.activeSettingEvent.isEnabled()) {
            for (EventControl ec : MetadataRepository.getInstance().getEventControls()) {
                ec.writeActiveSettingEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void periodicTask() {
        if (!jvm.hasNativeJFR()) {
            return;
        }
        while (true) {
            PlatformRecorder platformRecorder = this;
            synchronized (platformRecorder) {
                if (jvm.shouldRotateDisk()) {
                    this.rotateDisk();
                }
            }
            long minDelta = RequestEngine.doPeriodic();
            long wait = Math.min(minDelta, Options.getWaitInterval());
            this.takeNap(wait);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeNap(long duration) {
        try {
            Object object = JVM.FILE_DELTA_CHANGE;
            synchronized (object) {
                JVM.FILE_DELTA_CHANGE.wait(duration < 10L ? 10L : duration);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    synchronized Recording newCopy(PlatformRecording r, boolean stop) {
        Recording newRec = new Recording();
        PlatformRecording copy = PrivateAccess.getInstance().getPlatformRecording(newRec);
        copy.setSettings(r.getSettings());
        copy.setMaxAge(r.getMaxAge());
        copy.setMaxSize(r.getMaxSize());
        copy.setDumpOnExit(r.getDumpOnExit());
        copy.setName("Clone of " + r.getName());
        copy.setToDisk(r.isToDisk());
        copy.setInternalDuration(r.getDuration());
        copy.setStartTime(r.getStartTime());
        copy.setStopTime(r.getStopTime());
        if (r.getState() == RecordingState.NEW) {
            return newRec;
        }
        if (r.getState() == RecordingState.DELAYED) {
            copy.scheduleStart(r.getStartTime());
            return newRec;
        }
        copy.setState(r.getState());
        for (RepositoryChunk c : r.getChunks()) {
            copy.add(c);
        }
        if (r.getState() == RecordingState.RUNNING) {
            if (stop) {
                copy.stop("Stopped when cloning recording '" + r.getName() + "'");
            } else if (r.getStopTime() != null) {
                TimerTask stopTask = copy.createStopTask();
                copy.setStopTask(copy.createStopTask());
                this.getTimer().schedule(stopTask, r.getStopTime().toEpochMilli());
            }
        }
        return newRec;
    }

    public synchronized void fillWithRecordedData(PlatformRecording target, Boolean pathToGcRoots) {
        boolean running = false;
        boolean toDisk = false;
        for (PlatformRecording r : this.recordings) {
            if (r.getState() != RecordingState.RUNNING) continue;
            running = true;
            if (!r.isToDisk()) continue;
            toDisk = true;
        }
        if (running) {
            if (toDisk) {
                OldObjectSample.emit(this.recordings, pathToGcRoots);
                this.rotateDisk();
            } else {
                try (PlatformRecording snapshot = this.newTemporaryRecording();){
                    snapshot.setToDisk(true);
                    snapshot.setShouldWriteActiveRecordingEvent(false);
                    snapshot.start();
                    OldObjectSample.emit(this.recordings, pathToGcRoots);
                    snapshot.stop("Snapshot dump");
                    this.fillWithDiskChunks(target);
                }
                return;
            }
        }
        this.fillWithDiskChunks(target);
    }

    private void fillWithDiskChunks(PlatformRecording target) {
        for (RepositoryChunk c : this.makeChunkList(null, null)) {
            target.add(c);
        }
        target.setState(RecordingState.STOPPED);
        Instant startTime = null;
        Instant endTime = null;
        for (RepositoryChunk c : target.getChunks()) {
            if (startTime == null || c.getStartTime().isBefore(startTime)) {
                startTime = c.getStartTime();
            }
            if (endTime != null && !c.getEndTime().isAfter(endTime)) continue;
            endTime = c.getEndTime();
        }
        Instant now = Instant.now();
        if (startTime == null) {
            startTime = now;
        }
        if (endTime == null) {
            endTime = now;
        }
        target.setStartTime(startTime);
        target.setStopTime(endTime);
        target.setInternalDuration(Duration.between(startTime, endTime));
    }
}

