/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.commons.Method;
import jdk.jfr.Event;
import jdk.jfr.EventType;
import jdk.jfr.SettingControl;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.ASMToolkit;
import jdk.jfr.internal.EventControl;
import jdk.jfr.internal.EventHandlerProxyCreator;
import jdk.jfr.internal.EventInstrumentation;
import jdk.jfr.internal.EventWriter;
import jdk.jfr.internal.EventWriterMethod;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.StringPool;
import jdk.jfr.internal.TypeLibrary;
import jdk.jfr.internal.handlers.EventHandler;

final class EventHandlerCreator {
    private static final int CLASS_VERSION = 52;
    private static final String SUFFIX = "_" + System.currentTimeMillis() + "-" + JVM.getJVM().getPid();
    private static final String FIELD_EVENT_TYPE = "platformEventType";
    private static final String FIELD_PREFIX_STRING_POOL = "stringPool";
    private static final Class<? extends EventHandler> eventHandlerProxy = EventHandlerProxyCreator.proxyClass;
    private static final Type TYPE_STRING_POOL = Type.getType(StringPool.class);
    private static final Type TYPE_EVENT_WRITER = Type.getType(EventWriter.class);
    private static final Type TYPE_PLATFORM_EVENT_TYPE = Type.getType(PlatformEventType.class);
    private static final Type TYPE_EVENT_HANDLER = Type.getType(eventHandlerProxy);
    private static final Type TYPE_SETTING_CONTROL = Type.getType(SettingControl.class);
    private static final Type TYPE_EVENT_TYPE = Type.getType(EventType.class);
    private static final Type TYPE_EVENT_CONTROL = Type.getType(EventControl.class);
    private static final String DESCRIPTOR_EVENT_HANDLER = "(" + Type.BOOLEAN_TYPE.getDescriptor() + TYPE_EVENT_TYPE.getDescriptor() + TYPE_EVENT_CONTROL.getDescriptor() + ")V";
    private static final Method METHOD_GET_EVENT_WRITER = new Method("getEventWriter", "()" + TYPE_EVENT_WRITER.getDescriptor());
    private static final Method METHOD_EVENT_HANDLER_CONSTRUCTOR = new Method("<init>", DESCRIPTOR_EVENT_HANDLER);
    private static final Method METHOD_RESET = new Method("reset", "()V");
    private final ClassWriter classWriter = new ClassWriter(3);
    private final String className;
    private final String internalClassName;
    private final List<EventInstrumentation.SettingInfo> settingInfos;
    private final List<EventInstrumentation.FieldInfo> fields;

    public EventHandlerCreator(long id, List<EventInstrumentation.SettingInfo> settingInfos, List<EventInstrumentation.FieldInfo> fields) {
        this.className = EventHandlerCreator.makeEventHandlerName(id);
        this.internalClassName = ASMToolkit.getInternalName(this.className);
        this.settingInfos = settingInfos;
        this.fields = fields;
    }

    public static String makeEventHandlerName(long id) {
        return eventHandlerProxy.getName() + id + SUFFIX;
    }

    public EventHandlerCreator(long id, List<EventInstrumentation.SettingInfo> settingInfos, EventType type, Class<? extends Event> eventClass) {
        this(id, settingInfos, EventHandlerCreator.createFieldInfos(eventClass, type));
    }

    private static List<EventInstrumentation.FieldInfo> createFieldInfos(Class<? extends Event> eventClass, EventType type) throws Error {
        ArrayList<EventInstrumentation.FieldInfo> fieldInfos = new ArrayList<EventInstrumentation.FieldInfo>();
        for (ValueDescriptor v : type.getFields()) {
            if (v == TypeLibrary.STACK_TRACE_FIELD || v == TypeLibrary.THREAD_FIELD) continue;
            String fieldName = PrivateAccess.getInstance().getFieldName(v);
            String fieldDescriptor = ASMToolkit.getDescriptor(v.getTypeName());
            String internalName = null;
            for (Class<? extends Event> c = eventClass; c != Event.class; c = c.getSuperclass()) {
                try {
                    Field field = c.getDeclaredField(fieldName);
                    if (c != eventClass && Modifier.isPrivate(field.getModifiers())) continue;
                    internalName = ASMToolkit.getInternalName(c.getName());
                    break;
                }
                catch (NoSuchFieldException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (internalName != null) {
                fieldInfos.add(new EventInstrumentation.FieldInfo(fieldName, fieldDescriptor, internalName));
                continue;
            }
            throw new InternalError("Could not locate field " + fieldName + " for event type" + type.getName());
        }
        return fieldInfos;
    }

    public Class<? extends EventHandler> makeEventHandlerClass() {
        this.buildClassInfo();
        this.buildConstructor();
        this.buildWriteMethod();
        byte[] bytes = this.classWriter.toByteArray();
        ASMToolkit.logASM(this.className, bytes);
        return SecuritySupport.defineClass(this.className, bytes, Event.class.getClassLoader()).asSubclass(EventHandler.class);
    }

    public static EventHandler instantiateEventHandler(Class<? extends EventHandler> handlerClass, boolean registered, EventType eventType, EventControl eventControl) throws Error {
        Constructor<?> cc;
        try {
            cc = handlerClass.getDeclaredConstructors()[0];
        }
        catch (Exception e) {
            throw (Error)new InternalError("Could not get handler constructor for " + eventType.getName()).initCause(e);
        }
        SecuritySupport.setAccessible(cc);
        try {
            List<EventInstrumentation.SettingInfo> settingInfos = eventControl.getSettingInfos();
            Object[] arguments = new Object[3 + settingInfos.size()];
            arguments[0] = registered;
            arguments[1] = eventType;
            arguments[2] = eventControl;
            for (EventInstrumentation.SettingInfo si : settingInfos) {
                arguments[si.index + 3] = si.settingControl;
            }
            return (EventHandler)cc.newInstance(arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw (Error)new InternalError("Could not instantiate event handler for " + eventType.getName() + ". " + e.getMessage()).initCause(e);
        }
    }

    private void buildConstructor() {
        MethodVisitor mv = this.classWriter.visitMethod(2, METHOD_EVENT_HANDLER_CONSTRUCTOR.getName(), EventHandlerCreator.makeConstructorDescriptor(this.settingInfos), null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, Type.getInternalName(eventHandlerProxy), METHOD_EVENT_HANDLER_CONSTRUCTOR.getName(), METHOD_EVENT_HANDLER_CONSTRUCTOR.getDescriptor(), false);
        for (EventInstrumentation.SettingInfo si : this.settingInfos) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, si.index + 4);
            mv.visitFieldInsn(181, this.internalClassName, si.fieldName, TYPE_SETTING_CONTROL.getDescriptor());
        }
        int fieldIndex = 0;
        for (EventInstrumentation.FieldInfo field : this.fields) {
            if (field.isString()) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, Type.getInternalName(eventHandlerProxy), "createStringFieldWriter", "()" + TYPE_STRING_POOL.getDescriptor(), false);
                mv.visitFieldInsn(181, this.internalClassName, FIELD_PREFIX_STRING_POOL + fieldIndex, TYPE_STRING_POOL.getDescriptor());
            }
            ++fieldIndex;
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildClassInfo() {
        String internalSuperName = ASMToolkit.getInternalName(eventHandlerProxy.getName());
        this.classWriter.visit(52, 49, this.internalClassName, null, internalSuperName, null);
        for (EventInstrumentation.SettingInfo si : this.settingInfos) {
            this.classWriter.visitField(17, si.fieldName, TYPE_SETTING_CONTROL.getDescriptor(), null, null);
        }
        int fieldIndex = 0;
        for (EventInstrumentation.FieldInfo field : this.fields) {
            if (field.isString()) {
                this.classWriter.visitField(18, FIELD_PREFIX_STRING_POOL + fieldIndex, TYPE_STRING_POOL.getDescriptor(), null, null);
            }
            ++fieldIndex;
        }
    }

    private void visitMethod(MethodVisitor mv, int opcode, Type type, Method method) {
        mv.visitMethodInsn(opcode, type.getInternalName(), method.getName(), method.getDescriptor(), false);
    }

    private void buildWriteMethod() {
        int argIndex = 0;
        int slotIndex = 1;
        int fieldIndex = 0;
        Method desc = ASMToolkit.makeWriteMethod(this.fields);
        Type[] argumentTypes = Type.getArgumentTypes(desc.getDescriptor());
        MethodVisitor mv = this.classWriter.visitMethod(1, desc.getName(), desc.getDescriptor(), null, null);
        mv.visitCode();
        Label start = new Label();
        Label endTryBlock = new Label();
        Label exceptionHandler = new Label();
        mv.visitTryCatchBlock(start, endTryBlock, exceptionHandler, "java/lang/Throwable");
        mv.visitLabel(start);
        this.visitMethod(mv, 184, TYPE_EVENT_WRITER, METHOD_GET_EVENT_WRITER);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, TYPE_EVENT_HANDLER.getInternalName(), FIELD_EVENT_TYPE, TYPE_PLATFORM_EVENT_TYPE.getDescriptor());
        this.visitMethod(mv, 182, TYPE_EVENT_WRITER, EventWriterMethod.BEGIN_EVENT.asASM());
        Label recursive = new Label();
        mv.visitJumpInsn(153, recursive);
        mv.visitInsn(89);
        mv.visitVarInsn(argumentTypes[argIndex].getOpcode(21), slotIndex);
        int n = argIndex++;
        this.visitMethod(mv, 182, TYPE_EVENT_WRITER, EventWriterMethod.PUT_LONG.asASM());
        ++fieldIndex;
        mv.visitInsn(89);
        mv.visitVarInsn(argumentTypes[argIndex].getOpcode(21), slotIndex += argumentTypes[n].getSize());
        slotIndex += argumentTypes[argIndex++].getSize();
        this.visitMethod(mv, 182, TYPE_EVENT_WRITER, EventWriterMethod.PUT_LONG.asASM());
        ++fieldIndex;
        mv.visitInsn(89);
        this.visitMethod(mv, 182, TYPE_EVENT_WRITER, EventWriterMethod.PUT_EVENT_THREAD.asASM());
        mv.visitInsn(89);
        this.visitMethod(mv, 182, TYPE_EVENT_WRITER, EventWriterMethod.PUT_STACK_TRACE.asASM());
        while (fieldIndex < this.fields.size()) {
            mv.visitInsn(89);
            mv.visitVarInsn(argumentTypes[argIndex].getOpcode(21), slotIndex);
            slotIndex += argumentTypes[argIndex++].getSize();
            EventInstrumentation.FieldInfo field = this.fields.get(fieldIndex);
            if (field.isString()) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.internalClassName, FIELD_PREFIX_STRING_POOL + fieldIndex, TYPE_STRING_POOL.getDescriptor());
            }
            EventWriterMethod eventMethod = EventWriterMethod.lookupMethod(field);
            this.visitMethod(mv, 182, TYPE_EVENT_WRITER, eventMethod.asASM());
            ++fieldIndex;
        }
        this.visitMethod(mv, 182, TYPE_EVENT_WRITER, EventWriterMethod.END_EVENT.asASM());
        mv.visitJumpInsn(153, start);
        mv.visitLabel(endTryBlock);
        Label end = new Label();
        mv.visitJumpInsn(167, end);
        mv.visitLabel(exceptionHandler);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
        this.visitMethod(mv, 184, TYPE_EVENT_WRITER, METHOD_GET_EVENT_WRITER);
        mv.visitInsn(89);
        Label rethrow = new Label();
        mv.visitJumpInsn(198, rethrow);
        mv.visitInsn(89);
        this.visitMethod(mv, 182, TYPE_EVENT_WRITER, METHOD_RESET);
        mv.visitLabel(rethrow);
        mv.visitFrame(3, 0, null, 2, new Object[]{"java/lang/Throwable", TYPE_EVENT_WRITER.getInternalName()});
        mv.visitInsn(87);
        mv.visitInsn(191);
        mv.visitLabel(recursive);
        mv.visitFrame(3, 0, null, 1, new Object[]{TYPE_EVENT_WRITER.getInternalName()});
        mv.visitInsn(87);
        mv.visitLabel(end);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static String makeConstructorDescriptor(List<EventInstrumentation.SettingInfo> settingsInfos) {
        StringJoiner constructordescriptor = new StringJoiner("", "(", ")V");
        constructordescriptor.add(Type.BOOLEAN_TYPE.getDescriptor());
        constructordescriptor.add(Type.getType(EventType.class).getDescriptor());
        constructordescriptor.add(Type.getType(EventControl.class).getDescriptor());
        for (int i = 0; i < settingsInfos.size(); ++i) {
            constructordescriptor.add(TYPE_SETTING_CONTROL.getDescriptor());
        }
        return constructordescriptor.toString();
    }
}

