/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;

public abstract class Control {
    private final AccessControlContext context;
    private static final int CACHE_SIZE = 5;
    private final Set<?>[] cachedUnions = new HashSet[5];
    private final String[] cachedValues = new String[5];
    private String defaultValue;
    private String lastValue;

    public Control(AccessControlContext acc) {
        Objects.requireNonNull(acc);
        this.context = acc;
    }

    public Control(String defaultValue) {
        this.defaultValue = defaultValue;
        this.context = null;
    }

    public abstract String combine(Set<String> var1);

    public abstract void setValue(String var1);

    public abstract String getValue();

    final void apply(Set<String> values) {
        this.setValueSafe(this.findCombineSafe(values));
    }

    final void setDefault() {
        if (this.defaultValue == null) {
            this.defaultValue = this.getValueSafe();
        }
        this.apply(this.defaultValue);
    }

    final String getValueSafe() {
        if (this.context == null) {
            return this.getValue();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return Control.this.getValue();
                }
                catch (Throwable t) {
                    Logger.log(LogTag.JFR_SETTING, LogLevel.WARN, "Exception occured when trying to get value for " + this.getClass());
                    return Control.this.defaultValue != null ? Control.this.defaultValue : "";
                }
            }
        }, this.context);
    }

    private void apply(String value) {
        if (this.lastValue != null && Objects.equals(value, this.lastValue)) {
            return;
        }
        this.setValueSafe(value);
    }

    final void setValueSafe(final String value) {
        if (this.context == null) {
            try {
                this.setValue(value);
            }
            catch (Throwable t) {
                Logger.log(LogTag.JFR_SETTING, LogLevel.WARN, "Exception occured when setting value \"" + value + "\" for " + this.getClass());
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        Control.this.setValue(value);
                    }
                    catch (Throwable t) {
                        Logger.log(LogTag.JFR_SETTING, LogLevel.WARN, "Exception occured when setting value \"" + value + "\" for " + this.getClass());
                    }
                    return null;
                }
            }, this.context);
        }
        this.lastValue = value;
    }

    private String combineSafe(final Set<String> values) {
        if (this.context == null) {
            return this.combine(values);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    Control.this.combine(Collections.unmodifiableSet(values));
                }
                catch (Throwable t) {
                    Logger.log(LogTag.JFR_SETTING, LogLevel.WARN, "Exception occured when combining " + values + " for " + this.getClass());
                }
                return null;
            }
        }, this.context);
    }

    private final String findCombineSafe(Set<String> values) {
        if (values.size() == 1) {
            return values.iterator().next();
        }
        for (int i = 0; i < 5; ++i) {
            if (!Objects.equals(this.cachedUnions[i], values)) continue;
            return this.cachedValues[i];
        }
        String result = this.combineSafe(values);
        for (int i = 0; i < 4; ++i) {
            this.cachedUnions[i + 1] = this.cachedUnions[i];
            this.cachedValues[i + 1] = this.cachedValues[i];
        }
        this.cachedValues[0] = result;
        this.cachedUnions[0] = values;
        return result;
    }

    final String getDefaultValue() {
        return this.defaultValue;
    }

    final String getLastValue() {
        return this.lastValue;
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("Object cannot be serialized");
    }

    private final void readObject(ObjectInputStream in) throws IOException {
        throw new IOException("Class cannot be deserialized");
    }
}

