/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.nio.ByteOrder;
import sun.misc.Unsafe;

final class Bits {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final boolean unalignedAccess = false;
    private static final boolean bigEndian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private Bits() {
    }

    private static short swap(short x) {
        return Short.reverseBytes(x);
    }

    private static char swap(char x) {
        return Character.reverseBytes(x);
    }

    private static int swap(int x) {
        return Integer.reverseBytes(x);
    }

    private static long swap(long x) {
        return Long.reverseBytes(x);
    }

    private static float swap(float x) {
        return Float.intBitsToFloat(Bits.swap(Float.floatToIntBits(x)));
    }

    private static double swap(double x) {
        return Double.longBitsToDouble(Bits.swap(Double.doubleToLongBits(x)));
    }

    private static boolean isAddressAligned(long a, int datumSize) {
        return (a & (long)(datumSize - 1)) == 0L;
    }

    private static byte char1(char x) {
        return (byte)(x >> 8);
    }

    private static byte char0(char x) {
        return (byte)x;
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)x;
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    private static byte long7(long x) {
        return (byte)(x >> 56);
    }

    private static byte long6(long x) {
        return (byte)(x >> 48);
    }

    private static byte long5(long x) {
        return (byte)(x >> 40);
    }

    private static byte long4(long x) {
        return (byte)(x >> 32);
    }

    private static byte long3(long x) {
        return (byte)(x >> 24);
    }

    private static byte long2(long x) {
        return (byte)(x >> 16);
    }

    private static byte long1(long x) {
        return (byte)(x >> 8);
    }

    private static byte long0(long x) {
        return (byte)x;
    }

    private static void putCharBigEndianUnaligned(long a, char x) {
        Bits.putByte_(a, Bits.char1(x));
        Bits.putByte_(a + 1L, Bits.char0(x));
    }

    private static void putShortBigEndianUnaligned(long a, short x) {
        Bits.putByte_(a, Bits.short1(x));
        Bits.putByte_(a + 1L, Bits.short0(x));
    }

    private static void putIntBigEndianUnaligned(long a, int x) {
        Bits.putByte_(a, Bits.int3(x));
        Bits.putByte_(a + 1L, Bits.int2(x));
        Bits.putByte_(a + 2L, Bits.int1(x));
        Bits.putByte_(a + 3L, Bits.int0(x));
    }

    private static void putLongBigEndianUnaligned(long a, long x) {
        Bits.putByte_(a, Bits.long7(x));
        Bits.putByte_(a + 1L, Bits.long6(x));
        Bits.putByte_(a + 2L, Bits.long5(x));
        Bits.putByte_(a + 3L, Bits.long4(x));
        Bits.putByte_(a + 4L, Bits.long3(x));
        Bits.putByte_(a + 5L, Bits.long2(x));
        Bits.putByte_(a + 6L, Bits.long1(x));
        Bits.putByte_(a + 7L, Bits.long0(x));
    }

    private static void putFloatBigEndianUnaligned(long a, float x) {
        Bits.putIntBigEndianUnaligned(a, Float.floatToRawIntBits(x));
    }

    private static void putDoubleBigEndianUnaligned(long a, double x) {
        Bits.putLongBigEndianUnaligned(a, Double.doubleToRawLongBits(x));
    }

    private static void putByte_(long a, byte b) {
        unsafe.putByte(a, b);
    }

    private static void putBoolean_(long a, boolean x) {
        unsafe.putBoolean(null, a, x);
    }

    private static void putChar_(long a, char x) {
        unsafe.putChar(a, bigEndian ? x : Bits.swap(x));
    }

    private static void putShort_(long a, short x) {
        unsafe.putShort(a, bigEndian ? x : Bits.swap(x));
    }

    private static void putInt_(long a, int x) {
        unsafe.putInt(a, bigEndian ? x : Bits.swap(x));
    }

    private static void putLong_(long a, long x) {
        unsafe.putLong(a, bigEndian ? x : Bits.swap(x));
    }

    private static void putFloat_(long a, float x) {
        unsafe.putFloat(a, bigEndian ? x : Bits.swap(x));
    }

    private static void putDouble_(long a, double x) {
        unsafe.putDouble(a, bigEndian ? x : Bits.swap(x));
    }

    static int putByte(long a, byte x) {
        Bits.putByte_(a, x);
        return 1;
    }

    static int putBoolean(long a, boolean x) {
        Bits.putBoolean_(a, x);
        return 1;
    }

    static int putChar(long a, char x) {
        if (Bits.isAddressAligned(a, 2)) {
            Bits.putChar_(a, x);
            return 2;
        }
        Bits.putCharBigEndianUnaligned(a, x);
        return 2;
    }

    static int putShort(long a, short x) {
        if (Bits.isAddressAligned(a, 2)) {
            Bits.putShort_(a, x);
            return 2;
        }
        Bits.putShortBigEndianUnaligned(a, x);
        return 2;
    }

    static int putInt(long a, int x) {
        if (Bits.isAddressAligned(a, 4)) {
            Bits.putInt_(a, x);
            return 4;
        }
        Bits.putIntBigEndianUnaligned(a, x);
        return 4;
    }

    static int putLong(long a, long x) {
        if (Bits.isAddressAligned(a, 8)) {
            Bits.putLong_(a, x);
            return 8;
        }
        Bits.putLongBigEndianUnaligned(a, x);
        return 8;
    }

    static int putFloat(long a, float x) {
        if (Bits.isAddressAligned(a, 4)) {
            Bits.putFloat_(a, x);
            return 4;
        }
        Bits.putFloatBigEndianUnaligned(a, x);
        return 4;
    }

    static int putDouble(long a, double x) {
        if (Bits.isAddressAligned(a, 8)) {
            Bits.putDouble_(a, x);
            return 8;
        }
        Bits.putDoubleBigEndianUnaligned(a, x);
        return 8;
    }
}

