/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jdk.jfr.EventType;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.ConstantMap;
import jdk.jfr.consumer.EventParser;
import jdk.jfr.consumer.LongMap;
import jdk.jfr.consumer.ObjectFactory;
import jdk.jfr.consumer.Parser;
import jdk.jfr.consumer.TimeConverter;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.consumer.RecordingInput;

final class ParserFactory {
    private final LongMap<Parser> parsers = new LongMap();
    private final TimeConverter timeConverter;
    private final LongMap<Type> types = new LongMap();
    private final LongMap<ConstantMap> constantPools = new LongMap();

    public ParserFactory(MetadataDescriptor metadata, TimeConverter timeConverter) throws IOException {
        this.timeConverter = timeConverter;
        for (Type type : metadata.getTypes()) {
            this.types.put(type.getId(), type);
        }
        for (Type type : this.types) {
            if (type.getFields().isEmpty()) continue;
            CompositeParser cp = this.createCompositeParser(type);
            if (!type.isSimpleType()) continue;
            this.parsers.put(type.getId(), cp.parsers[0]);
        }
        for (EventType eventType : metadata.getEventTypes()) {
            this.parsers.put(eventType.getId(), this.createEventParser(eventType));
        }
    }

    public LongMap<Parser> getParsers() {
        return this.parsers;
    }

    public LongMap<ConstantMap> getConstantPools() {
        return this.constantPools;
    }

    public LongMap<Type> getTypeMap() {
        return this.types;
    }

    private EventParser createEventParser(EventType eventType) throws IOException {
        ArrayList<Parser> parsers = new ArrayList<Parser>();
        for (ValueDescriptor f : eventType.getFields()) {
            parsers.add(this.createParser(f));
        }
        return new EventParser(this.timeConverter, eventType, parsers.toArray(new Parser[0]));
    }

    private Parser createParser(ValueDescriptor v) throws IOException {
        boolean constantPool = PrivateAccess.getInstance().isConstantPool(v);
        if (v.isArray()) {
            Type valueType = PrivateAccess.getInstance().getType(v);
            ValueDescriptor element = PrivateAccess.getInstance().newValueDescriptor(v.getName(), valueType, v.getAnnotationElements(), 0, constantPool, null);
            return new ArrayParser(this.createParser(element));
        }
        long id = v.getTypeId();
        Type type = this.types.get(id);
        if (type == null) {
            throw new IOException("Type '" + v.getTypeName() + "' is not defined");
        }
        if (constantPool) {
            ConstantMap pool = this.constantPools.get(id);
            if (pool == null) {
                pool = new ConstantMap(ObjectFactory.create(type, this.timeConverter), type.getName());
                this.constantPools.put(id, pool);
            }
            return new ConstantMapValueParser(pool);
        }
        Parser parser = this.parsers.get(id);
        if (parser == null) {
            if (!v.getFields().isEmpty()) {
                return this.createCompositeParser(type);
            }
            return this.registerParserType(type, this.createPrimitiveParser(type));
        }
        return parser;
    }

    private Parser createPrimitiveParser(Type type) throws IOException {
        switch (type.getName()) {
            case "int": {
                return new IntegerParser();
            }
            case "long": {
                return new LongParser();
            }
            case "float": {
                return new FloatParser();
            }
            case "double": {
                return new DoubleParser();
            }
            case "char": {
                return new CharacterParser();
            }
            case "boolean": {
                return new BooleanParser();
            }
            case "short": {
                return new ShortParser();
            }
            case "byte": {
                return new ByteParser();
            }
            case "java.lang.String": {
                ConstantMap pool = new ConstantMap(ObjectFactory.create(type, this.timeConverter), type.getName());
                this.constantPools.put(type.getId(), pool);
                return new StringParser(pool);
            }
        }
        throw new IOException("Unknown primitive type " + type.getName());
    }

    private Parser registerParserType(Type t, Parser parser) {
        Parser p = this.parsers.get(t.getId());
        if (p != null) {
            return p;
        }
        this.parsers.put(t.getId(), parser);
        return parser;
    }

    private CompositeParser createCompositeParser(Type type) throws IOException {
        List<ValueDescriptor> vds = type.getFields();
        Parser[] parsers = new Parser[vds.size()];
        CompositeParser composite = new CompositeParser(parsers);
        this.registerParserType(type, composite);
        int index = 0;
        for (ValueDescriptor vd : vds) {
            parsers[index++] = this.createParser(vd);
        }
        return composite;
    }

    private static final class ConstantMapValueParser
    extends Parser {
        private final ConstantMap pool;

        ConstantMapValueParser(ConstantMap pool) {
            this.pool = pool;
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            return this.pool.get(input.readLong());
        }
    }

    private static final class CompositeParser
    extends Parser {
        private final Parser[] parsers;

        public CompositeParser(Parser[] valueParsers) {
            this.parsers = valueParsers;
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            Object[] values = new Object[this.parsers.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.parsers[i].parse(input);
            }
            return values;
        }
    }

    private static final class ArrayParser
    extends Parser {
        private final Parser elementParser;

        public ArrayParser(Parser elementParser) {
            this.elementParser = elementParser;
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            int size = input.readInt();
            Object[] array = new Object[size];
            for (int i = 0; i < size; ++i) {
                array[i] = this.elementParser.parse(input);
            }
            return array;
        }
    }

    private static final class StringParser
    extends Parser {
        private final ConstantMap stringConstantMap;
        private String last;

        StringParser(ConstantMap stringConstantMap) {
            this.stringConstantMap = stringConstantMap;
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            String s = this.parseEncodedString(input);
            if (!Objects.equals(s, this.last)) {
                this.last = s;
            }
            return this.last;
        }

        private String parseEncodedString(RecordingInput input) throws IOException {
            byte encoding = input.readByte();
            if (encoding == 2) {
                long id = input.readLong();
                return (String)this.stringConstantMap.get(id);
            }
            return input.readEncodedString(encoding);
        }
    }

    private static final class DoubleParser
    extends Parser {
        private DoubleParser() {
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            return input.readDouble();
        }
    }

    private static final class FloatParser
    extends Parser {
        private FloatParser() {
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            return Float.valueOf(input.readFloat());
        }
    }

    private static final class CharacterParser
    extends Parser {
        private CharacterParser() {
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            return Character.valueOf(input.readChar());
        }
    }

    private static final class ShortParser
    extends Parser {
        private ShortParser() {
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            return input.readShort();
        }
    }

    private static final class IntegerParser
    extends Parser {
        private IntegerParser() {
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            return input.readInt();
        }
    }

    private static final class LongParser
    extends Parser {
        private LongParser() {
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            return input.readLong();
        }
    }

    private static final class ByteParser
    extends Parser {
        private ByteParser() {
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            return input.readByte();
        }
    }

    private static final class BooleanParser
    extends Parser {
        private BooleanParser() {
        }

        @Override
        public Object parse(RecordingInput input) throws IOException {
            return input.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

