/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils.httpclient;

import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import java.security.KeyManagementException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDKHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SDKHttpClient.class);
    private static final TrustManager TM = new /* Unavailable Anonymous Inner Class!! */;
    private HttpClientBuilder clientBuilder;
    private CloseableHttpClient httpClient = null;

    public void init(int maxCacheNum, int connectTimeout, int soTimeout) throws KeyManagementException {
        this.configFirst(maxCacheNum, (long)connectTimeout, (long)soTimeout);
        this.buildClient();
    }

    public SDKHttpClient configFirst(int maxCacheNum, long connectTimeout, long soTimeout) throws KeyManagementException {
        HostnameVerifier hostnameVerifier = (urlHostName, session) -> {
            LOGGER.info("url host name[{}], session peer host[{}]", (Object)urlHostName, (Object)session.getPeerHost());
            return true;
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        SSLContext sslContext = SSLContexts.createDefault();
        sslContext.init(null, new TrustManager[]{TM}, null);
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, hostnameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        cm.setMaxTotal(maxCacheNum);
        cm.setDefaultMaxPerRoute(20);
        this.clientBuilder = HttpClients.custom();
        this.clientBuilder.setConnectionManager((HttpClientConnectionManager)cm).setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(3, TimeValue.ofSeconds((long)2L)));
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(Timeout.ofMilliseconds((long)connectTimeout));
        configBuilder.setConnectionRequestTimeout(Timeout.ofSeconds((long)200L));
        configBuilder.setResponseTimeout(Timeout.ofMilliseconds((long)soTimeout));
        this.clientBuilder.setDefaultRequestConfig(configBuilder.build());
        configBuilder.setCookieSpec("ignoreCookies");
        BasicCookieStore basicCookieStore = new BasicCookieStore();
        this.clientBuilder.setDefaultCookieStore((CookieStore)basicCookieStore);
        return this;
    }

    public SDKHttpClient configSecond(HttpRequestInterceptor httpRequestInterceptor, HttpResponseInterceptor httpResponseInterceptor) {
        if (this.clientBuilder != null) {
            this.clientBuilder.addRequestInterceptorFirst(httpRequestInterceptor);
            this.clientBuilder.addResponseInterceptorFirst(httpResponseInterceptor);
        }
        return this;
    }

    public void buildClient() {
        this.httpClient = this.clientBuilder.setConnectionManagerShared(true).build();
    }

    public CloseableHttpClient getHttpClient() throws SDKException {
        if (null == this.httpClient) {
            throw new SDKException("3", "sdk not init or init fail.");
        }
        return this.httpClient;
    }
}

