/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils.httpclient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.IOUtils;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.utils.DigestUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.FileUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ClientRequest;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ClientSessionContext;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.HttpRequestUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.HttpUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.InputStreamMsg;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgResponseHandler;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SDKClientApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(SDKClientApi.class);
    private static final int TIMEOUT = 12;

    private SDKClientApi() {
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor) throws SDKException {
        return (T)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, null, objectToMsgConvertor, msgToObjectConvertor);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        return (T)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, null, objectToMsgConvertor, msgToObjectConvertor, headers);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpUrlParam, MsgToObjectConvertor<T> msgToObjectConvertor) throws SDKException {
        return (T)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, (HttpUrlParam)httpUrlParam, null, msgToObjectConvertor);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpUrlParam, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        return (T)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, (HttpUrlParam)httpUrlParam, null, msgToObjectConvertor, headers);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgToObjectConvertor<T> msgToObjectConvertor) throws SDKException {
        return (T)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, null, null, msgToObjectConvertor);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        return (T)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, null, null, msgToObjectConvertor, headers);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpUrlParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor) throws SDKException {
        ClientSessionContext clientSessionContext = new ClientSessionContext(vcmReqBaseInfo);
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (MsgType)msgType, (HttpUrlParam)httpUrlParam, objectToMsgConvertor, msgToObjectConvertor);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpUrlParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        ClientSessionContext clientSessionContext = new ClientSessionContext(vcmReqBaseInfo);
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (MsgType)msgType, (HttpUrlParam)httpUrlParam, objectToMsgConvertor, msgToObjectConvertor, headers);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgResponseHandler<T> respHandler) throws SDKException {
        return (T)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, null, objectToMsgConvertor, respHandler);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpUrlParam, MsgResponseHandler<T> respHandler) throws SDKException {
        return (T)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, (HttpUrlParam)httpUrlParam, null, respHandler);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgResponseHandler<T> respHandler) throws SDKException {
        return (T)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, null, null, respHandler);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, HttpServletRequest httpServletRequest, MsgResponseHandler<T> respHandler) throws SDKException {
        ClientRequest clientRequest;
        ClientSessionContext clientSessionContext = new ClientSessionContext(vcmReqBaseInfo);
        MsgType msgType = MsgType.parse((HttpServletRequest)httpServletRequest);
        HttpUrlParam httpUrlParam = SDKClientApi.parseUrlParam((HttpServletRequest)httpServletRequest);
        try {
            clientRequest = new ClientRequest(msgType, httpUrlParam, (ObjectToMsgConvertor)new InputStreamMsg((InputStream)httpServletRequest.getInputStream(), null));
            clientRequest.parseHeaders(httpServletRequest);
        }
        catch (IOException e) {
            LOGGER.error("respHandler request error", (Throwable)e);
            throw new SDKException("500", "io exception.");
        }
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, respHandler);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, ClientRequest clientRequest, long connectTimeout, long socketTimeout, MsgToObjectConvertor<T> msgObjectConvertor) throws SDKException {
        ClientSessionContext clientSessionContext = new ClientSessionContext(vcmReqBaseInfo);
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (long)connectTimeout, (long)socketTimeout, msgObjectConvertor);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, ClientRequest clientRequest, long timeout, MsgToObjectConvertor<T> msgObjectConvertor) throws SDKException {
        long connectTimeout = timeout <= 3L ? timeout : timeout / 3L;
        return (T)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (ClientRequest)clientRequest, (long)connectTimeout, (long)timeout, msgObjectConvertor);
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpUrlParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgResponseHandler<T> respHandler) throws SDKException {
        ClientSessionContext clientSessionContext = new ClientSessionContext(vcmReqBaseInfo);
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (MsgType)msgType, (HttpUrlParam)httpUrlParam, objectToMsgConvertor, respHandler);
    }

    public static <T> T request(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, msgToObjectConvertor);
    }

    public static <T> T request(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, int timeout) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (int)(timeout * 1000), msgToObjectConvertor);
    }

    public static <T> T request(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        clientRequest.addHeaders(headers);
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, msgToObjectConvertor);
    }

    public static <T> T requestJsonOrder(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        clientRequest.addHeaders(headers);
        return (T)SDKClientApi.requestJsonOrder((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, msgToObjectConvertor);
    }

    public static <T> T requestDigest(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        clientRequest.addHeaders(headers);
        int connectTimeout = 4000;
        int socketTimeout = 12000;
        HttpUriRequestBase httpRequest = clientRequest.buildRequest(clientSessionContext.buildUrl());
        return (T)SDKClientApi.doRequestDigest((ClientSessionContext)clientSessionContext, msgToObjectConvertor, (int)connectTimeout, (int)socketTimeout, (HttpUriRequestBase)httpRequest);
    }

    public static <T> T requestDigest(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, File file, String jsonContent, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, null);
        clientRequest.addHeaders(headers);
        int connectTimeout = 4000;
        int socketTimeout = 12000;
        HttpUriRequestBase httpRequest = clientRequest.buildRequestMultipart(clientSessionContext.buildUrl(), file, jsonContent);
        return (T)SDKClientApi.doRequestDigest((ClientSessionContext)clientSessionContext, msgToObjectConvertor, (int)connectTimeout, (int)socketTimeout, (HttpUriRequestBase)httpRequest);
    }

    public static <T> T requestDigest(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers, int connectTimeout) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        clientRequest.addHeaders(headers);
        int socketTimeout = 12000;
        HttpUriRequestBase httpRequest = clientRequest.buildRequest(clientSessionContext.buildUrl());
        return (T)SDKClientApi.doRequestDigest((ClientSessionContext)clientSessionContext, msgToObjectConvertor, (int)(connectTimeout *= 1000), (int)socketTimeout, (HttpUriRequestBase)httpRequest);
    }

    private static <T> T doRequestDigest(ClientSessionContext clientSessionContext, MsgToObjectConvertor<T> msgToObjectConvertor, int connectTimeout, int responseTimeout, HttpUriRequestBase httpRequest) throws SDKException {
        Object classt;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).setResponseTimeout((long)responseTimeout, TimeUnit.MILLISECONDS).build();
        httpRequest.setConfig(requestConfig);
        try {
            CloseableHttpResponse httpResponse = SDKClientApi.requestDigest((ClientSessionContext)clientSessionContext, (HttpUriRequestBase)httpRequest);
            int status = HttpUtils.parseStatusCode((ClassicHttpResponse)httpResponse);
            if (200 != status) {
                if (400 == status || 500 == status) {
                    String msg = SDKClientApi.parseStrEntity((HttpEntity)httpResponse.getEntity());
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                    throw new SDKException(String.valueOf(status), msg);
                }
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                throw new SDKException(String.valueOf(status), String.valueOf(status));
            }
            if ("image/jpeg".equals(httpResponse.getHeader("Content-Type").getValue())) {
                return (T)httpResponse;
            }
            classt = msgToObjectConvertor.toObject(httpResponse.getEntity());
        }
        catch (ClientProtocolException e) {
            LOGGER.error("do request digest connection timeout,url:{}", (Object)httpRequest.getRequestUri());
            throw new InvokeException("-1001", "connect remote fail.");
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("do request digest device return timeout,url:{}", (Object)httpRequest.getRequestUri());
            throw new InvokeException("-1002", "response timeout.");
        }
        catch (IOException | ParseException e) {
            LOGGER.error("do request digest error", e);
            throw new SDKException("request error.", e.getMessage());
        }
        catch (ProtocolException e) {
            LOGGER.error("do request digest error", (Throwable)e);
            throw new SDKException("request error.", e.getMessage());
        }
        return (T)classt;
    }

    public static <T> T request(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers, int timeout) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        clientRequest.addHeaders(headers);
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (int)timeout, msgToObjectConvertor);
    }

    public static <T> T request(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, File file, String jsonContent, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, null);
        clientRequest.addHeaders(headers);
        int connectTimeout = 4000;
        int socketTimeout = 12000;
        HttpUriRequestBase httpRequest = clientRequest.buildAudioRequestMultipart(clientSessionContext.buildUrl(), file, jsonContent);
        return (T)SDKClientApi.doRequest((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (long)connectTimeout, (long)socketTimeout, msgToObjectConvertor, (HttpUriRequestBase)httpRequest);
    }

    public static <T> T requestForm(ClientSessionContext clientSessionContext, MsgType msgType, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers, HttpEntity httpEntity, int socketTimeout) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, null, null);
        clientRequest.addHeaders(headers);
        HttpUriRequestBase httpRequest = clientRequest.buildRequestForm(clientSessionContext.buildUrl(), httpEntity);
        return (T)SDKClientApi.doRequest((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (long)4000L, (long)((long)socketTimeout * 1000L), msgToObjectConvertor, (HttpUriRequestBase)httpRequest);
    }

    private static <T> T doRequest(ClientSessionContext clientSessionContext, ClientRequest clientRequest, long connectTimeout, long socketTimeout, MsgToObjectConvertor<T> msgObjectConvertor, HttpUriRequestBase httpRequest) throws SDKException {
        Object classt;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout, TimeUnit.MILLISECONDS).setConnectionRequestTimeout(connectTimeout, TimeUnit.MILLISECONDS).setResponseTimeout(socketTimeout, TimeUnit.MILLISECONDS).build();
        httpRequest.setConfig(requestConfig);
        try {
            CloseableHttpResponse httpResponse = SDKClientApi.request((ClientSessionContext)clientSessionContext, (HttpUriRequestBase)httpRequest);
            int status = HttpUtils.parseStatusCode((ClassicHttpResponse)httpResponse);
            if (200 != status) {
                if (400 == status || 500 == status) {
                    String msg = SDKClientApi.parseStrEntity((HttpEntity)httpResponse.getEntity());
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                    throw new SDKException(String.valueOf(status), msg);
                }
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                throw new SDKException(String.valueOf(status), "request fail, status: " + status);
            }
            classt = msgObjectConvertor.toObject(httpResponse.getEntity());
        }
        catch (ClientProtocolException e) {
            throw new InvokeException("cu_connect_timeout", "connect remote fail.");
        }
        catch (SocketTimeoutException e) {
            throw new InvokeException("cu_device_not_return", "response timeout.");
        }
        catch (IOException | ParseException e) {
            LOGGER.error("request error", e);
            throw new SDKException("request error.", e.getMessage());
        }
        return (T)classt;
    }

    public static <T> T request(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgResponseHandler<T> respHandler) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, respHandler);
    }

    private static <T> T request(ClientSessionContext clientSessionContext, ClientRequest clientRequest, MsgToObjectConvertor<T> msgObjectConvertor) throws SDKException {
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (int)12000, msgObjectConvertor);
    }

    private static <T> T requestJsonOrder(ClientSessionContext clientSessionContext, ClientRequest clientRequest, MsgToObjectConvertor<T> msgObjectConvertor) throws SDKException {
        return (T)SDKClientApi.requestJsonOrder((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (int)12000, msgObjectConvertor);
    }

    private static <T> T request(ClientSessionContext clientSessionContext, ClientRequest clientRequest, MsgResponseHandler<T> respHandler) throws SDKException {
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (int)12000, respHandler);
    }

    private static <T> T request(ClientSessionContext clientSessionContext, ClientRequest clientRequest, int timeout, MsgToObjectConvertor<T> msgObjectConvertor) throws SDKException {
        int connectTimeout = timeout <= 3 ? timeout : timeout / 3;
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (long)connectTimeout, (long)timeout, msgObjectConvertor);
    }

    private static <T> T requestJsonOrder(ClientSessionContext clientSessionContext, ClientRequest clientRequest, int timeout, MsgToObjectConvertor<T> msgObjectConvertor) throws SDKException {
        int connectTimeout = timeout <= 3 ? timeout : timeout / 3;
        return (T)SDKClientApi.requestJsonOrder((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (long)connectTimeout, (long)timeout, msgObjectConvertor);
    }

    private static <T> T requestJsonOrder(ClientSessionContext clientSessionContext, ClientRequest clientRequest, long connectTimeout, long socketTimeout, MsgToObjectConvertor<T> msgObjectConvertor) throws SDKException {
        Object classt;
        HttpUriRequestBase httpRequest = clientRequest.buildRequest(clientSessionContext.buildUrl());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout, TimeUnit.MILLISECONDS).setResponseTimeout(socketTimeout, TimeUnit.MILLISECONDS).build();
        httpRequest.setConfig(requestConfig);
        try {
            CloseableHttpResponse httpResponse = SDKClientApi.request((ClientSessionContext)clientSessionContext, (HttpUriRequestBase)httpRequest);
            int status = HttpUtils.parseStatusCode((ClassicHttpResponse)httpResponse);
            if (200 != status && 201 != status) {
                if (400 == status || 500 == status) {
                    String msg = SDKClientApi.parseStrEntity((HttpEntity)httpResponse.getEntity());
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                    throw new SDKException(String.valueOf(status), msg);
                }
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                throw new SDKException(String.valueOf(status), "request fail, status: " + status);
            }
            classt = msgObjectConvertor.toJsonObject(httpResponse.getEntity());
        }
        catch (ClientProtocolException e) {
            LOGGER.error("device connect fail, error URI:" + httpRequest.getRequestUri());
            throw new InvokeException("cu_connect_timeout", "connect remote fail.");
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("device not return, error URI:" + httpRequest.getRequestUri());
            throw new InvokeException("cu_device_not_return", "response timeout.");
        }
        catch (IOException | ParseException e) {
            LOGGER.error("request error, error URI:" + httpRequest.getRequestUri(), e);
            throw new SDKException("request error.", e.getMessage());
        }
        return (T)classt;
    }

    private static <T> T request(ClientSessionContext clientSessionContext, ClientRequest clientRequest, long connectTimeout, long socketTimeout, MsgToObjectConvertor<T> msgObjectConvertor) throws SDKException {
        Object classt;
        HttpUriRequestBase httpRequest = clientRequest.buildRequest(clientSessionContext.buildUrl());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout, TimeUnit.MILLISECONDS).setResponseTimeout(socketTimeout, TimeUnit.MILLISECONDS).build();
        httpRequest.setConfig(requestConfig);
        try {
            CloseableHttpResponse httpResponse = SDKClientApi.request((ClientSessionContext)clientSessionContext, (HttpUriRequestBase)httpRequest);
            int status = HttpUtils.parseStatusCode((ClassicHttpResponse)httpResponse);
            if (200 != status && 201 != status) {
                if (400 == status || 500 == status || 401 == status || 403 == status) {
                    String msg = SDKClientApi.parseStrEntity((HttpEntity)httpResponse.getEntity());
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                    throw new SDKException(String.valueOf(status), msg);
                }
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                throw new SDKException(String.valueOf(status), "request fail, status: " + status);
            }
            classt = msgObjectConvertor.toObject(httpResponse.getEntity());
        }
        catch (ClientProtocolException e) {
            LOGGER.error("device connect fail, error URI:" + httpRequest.getRequestUri());
            throw new InvokeException("cu_connect_timeout", "connect remote fail.");
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("device not return, error URI:" + httpRequest.getRequestUri());
            throw new InvokeException("cu_device_not_return", "response timeout.");
        }
        catch (IOException | ParseException e) {
            LOGGER.error("request error, error URI:" + httpRequest.getRequestUri(), e);
            throw new SDKException("request error.", e.getMessage());
        }
        return (T)classt;
    }

    private static <T> T request(ClientSessionContext clientSessionContext, ClientRequest clientRequest, int timeout, MsgResponseHandler<T> respHandler) throws SDKException {
        int connectTimeout = timeout <= 3 ? timeout : timeout / 3;
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (int)connectTimeout, (int)timeout, respHandler);
    }

    public static <T> T request(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgResponseHandler<T> respHandler, List<Header> headers) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        clientRequest.addHeaders(headers);
        return (T)SDKClientApi.request((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, respHandler);
    }

    private static <T> T request(ClientSessionContext clientSessionContext, ClientRequest clientRequest, int connectTimeout, int socketTimeout, MsgResponseHandler<T> respHandler) throws SDKException {
        Object classt;
        HttpUriRequestBase httpRequest = clientRequest.buildRequest(clientSessionContext.buildUrl());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).setResponseTimeout((long)socketTimeout, TimeUnit.MILLISECONDS).build();
        httpRequest.setConfig(requestConfig);
        try {
            CloseableHttpResponse httpResponse = SDKClientApi.request((ClientSessionContext)clientSessionContext, (HttpUriRequestBase)httpRequest);
            int status = HttpUtils.parseStatusCode((ClassicHttpResponse)httpResponse);
            if (200 != status && 201 != status) {
                if (400 == status || 500 == status || 401 == status) {
                    String msg = SDKClientApi.parseStrEntity((HttpEntity)httpResponse.getEntity());
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                    throw new SDKException(String.valueOf(status), msg);
                }
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                throw new SDKException(String.valueOf(status), "request fail, status: " + status);
            }
            classt = respHandler.hanlde((HttpResponse)httpResponse);
        }
        catch (ClientProtocolException e) {
            LOGGER.error("request error", (Throwable)e);
            throw new InvokeException("500", "cu_connect_timeout");
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("device not return, error URI:" + httpRequest.getRequestUri());
            throw new InvokeException("500", "cu_device_not_return");
        }
        catch (IOException | ParseException e) {
            LOGGER.error("request error", e);
            throw new SDKException("request error.", e.getMessage());
        }
        return (T)classt;
    }

    private static CloseableHttpResponse request(ClientSessionContext clientSessionContext, HttpUriRequestBase httpRequest) throws SDKException {
        return SDKClientApi.closeableHttpClientReq((ClientSessionContext)clientSessionContext, (HttpUriRequestBase)httpRequest);
    }

    private static CloseableHttpResponse closeableHttpClientReq(ClientSessionContext clientSessionContext, HttpUriRequestBase httpRequest) throws SDKException {
        CloseableHttpResponse httpResponse;
        CloseableHttpClient httpClient = clientSessionContext.getHttpClient();
        try {
            httpRequest.addHeader("Cookie", (Object)clientSessionContext.getVcmReqBaseInfo().getVcmSession());
            httpRequest.setHeader("User-Agent", (Object)"curl/7.55.1");
            httpResponse = httpClient.execute((ClassicHttpRequest)httpRequest);
        }
        catch (ClientProtocolException e) {
            LOGGER.error("request error", (Throwable)e);
            throw new SDKException("request error.", e.getMessage());
        }
        catch (ConnectException e) {
            LOGGER.error("device connect fail, error URI:" + httpRequest.getRequestUri() + "IP:" + clientSessionContext.getVcmReqBaseInfo().getVcmIp());
            throw new InvokeException("500", "cu_connect_timeout");
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("device not return, error URI:" + httpRequest.getRequestUri() + "IP:" + clientSessionContext.getVcmReqBaseInfo().getVcmIp());
            throw new InvokeException("500", "cu_device_not_return");
        }
        catch (IOException e) {
            LOGGER.error("closeableHttpClientReq request error,url:" + httpRequest.getPath(), (Throwable)e);
            throw new SDKException("-1001", "request error.");
        }
        return httpResponse;
    }

    private static CloseableHttpResponse requestDigest(ClientSessionContext clientSessionContext, HttpUriRequestBase httpRequest) throws SDKException {
        VcmReqBaseInfo vcmReqBaseInfo = clientSessionContext.getVcmReqBaseInfo();
        CloseableHttpResponse response = null;
        try {
            HttpClientBuilder builder = HttpRequestUtils.configFirst((int)3000, (long)10000L, (long)12000L);
            if (DeviceTypeEnum.ZKNVR.val() == vcmReqBaseInfo.getVcmType().intValue() || DeviceTypeEnum.ZKIPC.val() == vcmReqBaseInfo.getVcmType().intValue()) {
                BasicCredentialsProvider credentialsStore = new BasicCredentialsProvider();
                String password = "";
                if (StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getSdcPassword())) {
                    password = vcmReqBaseInfo.getSdcPassword();
                }
                String userName = "";
                if (StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getSdcUserName())) {
                    userName = vcmReqBaseInfo.getSdcUserName();
                }
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(userName, password.toCharArray());
                credentialsStore.setCredentials(new AuthScope(vcmReqBaseInfo.getVcmIp(), Integer.parseInt(vcmReqBaseInfo.getVcmPort())), (Credentials)usernamePasswordCredentials);
                JSONObject session = (JSONObject)JSON.parse((String)vcmReqBaseInfo.getVcmSession());
                httpRequest.setHeader("X-HASH", (Object)session.getString("X-HASH"));
                httpRequest.setHeader("C-HASH", (Object)session.getString("C-HASH"));
                httpRequest.setHeader("S-HASH", (Object)session.getString("S-HASH"));
                httpRequest.setHeader("User-Agent", (Object)"curl/7.55.1");
                CloseableHttpClient httpClient = builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsStore).build();
                response = httpClient.execute((ClassicHttpRequest)httpRequest);
            } else if (DeviceTypeEnum.ONVIFNVR.val() == vcmReqBaseInfo.getVcmType().intValue() || DeviceTypeEnum.ONVIFIPC.val() == vcmReqBaseInfo.getVcmType().intValue()) {
                CloseableHttpClient httpClient = builder.build();
                response = httpClient.execute((ClassicHttpRequest)httpRequest);
                if (401 == response.getCode()) {
                    Header header = response.getFirstHeader("WWW-Authenticate");
                    String[] value = header.getValue().split(",");
                    String realm = "";
                    String nonce = "";
                    String algorithm = "";
                    String opaque = "";
                    for (String auth : value) {
                        if (auth.contains("realm")) {
                            realm = auth.split("=")[1].replaceAll("\"", "");
                        }
                        if (auth.contains("nonce")) {
                            nonce = auth.split("=")[1].replaceAll("\"", "");
                        }
                        if (auth.contains("algorithm")) {
                            algorithm = auth.split("=")[1].replaceAll("\"", "");
                        }
                        if (!auth.contains("opaque")) continue;
                        opaque = auth.split("=")[1].replaceAll("\"", "");
                    }
                    if (StringUtils.isBlank((CharSequence)algorithm)) {
                        algorithm = "MD5";
                    }
                    httpRequest.setHeader("Authorization", (Object)DigestUtils.getAuthorization((String)vcmReqBaseInfo.getSdcUserName(), (String)realm, (String)vcmReqBaseInfo.getSdcPassword(), (String)nonce, (String)httpRequest.getMethod(), (String)httpRequest.getRequestUri(), (String)algorithm, (String)"63f8297fe918541dd3c2", (String)"00000001", (String)"auth", (String)opaque));
                    response = httpClient.execute((ClassicHttpRequest)httpRequest);
                }
            } else if (DeviceTypeEnum.DHNVR.val() == vcmReqBaseInfo.getVcmType().intValue()) {
                CloseableHttpClient httpClient = builder.build();
                response = httpClient.execute((ClassicHttpRequest)httpRequest);
                if (401 == response.getCode()) {
                    Header header = response.getFirstHeader("WWW-Authenticate");
                    String value = header.getValue().replaceAll("\"", "");
                    String[] authMessage = value.split(",");
                    String digest = authMessage[0].split(" ")[0];
                    String realm = authMessage[0].split("=")[1];
                    String nonce = authMessage[2].split("=")[1];
                    String opaque = "";
                    String algorithm = "MD5";
                    String qop = authMessage[1].split("=")[1];
                    httpRequest.setHeader("Authorization", (Object)DigestUtils.getAuthorization((String)vcmReqBaseInfo.getSdcUserName(), (String)realm, (String)vcmReqBaseInfo.getSdcPassword(), (String)nonce, (String)httpRequest.getMethod(), (String)httpRequest.getRequestUri(), (String)algorithm, (String)"63f8297fe918541dd3c2", (String)"00000001", (String)qop, (String)opaque));
                    response = httpClient.execute((ClassicHttpRequest)httpRequest);
                }
            } else {
                CloseableHttpClient httpClient = builder.build();
                response = httpClient.execute((ClassicHttpRequest)httpRequest);
                int statusCode = response.getCode();
                if (401 == statusCode) {
                    Header header = response.getFirstHeader("WWW-Authenticate");
                    String value = header.getValue().replaceAll("\"", "");
                    String digest = value.split(" ")[0];
                    String[] kvAr = value.split(" ")[1].split(",");
                    String realm = kvAr[0].split("=")[1];
                    String nonce = kvAr[1].split("=")[1];
                    String algorithm = value.split(" ")[2].split("=")[1];
                    IOUtils.close((Closeable)response);
                    URI serverURI = new URI(httpRequest.getUri().toString());
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(serverURI.getHost(), serverURI.getPort()), (Credentials)new UsernamePasswordCredentials(vcmReqBaseInfo.getSdcUserName(), vcmReqBaseInfo.getSdcPassword().toCharArray()));
                    String response1 = DigestUtils.digest((String)vcmReqBaseInfo.getSdcUserName(), (String)realm, (String)vcmReqBaseInfo.getSdcPassword(), (String)nonce, (String)httpRequest.getMethod(), (String)httpRequest.getRequestUri(), (String)algorithm);
                    httpRequest.setHeader("Authorization", (Object)(digest + " username=\"" + vcmReqBaseInfo.getSdcUserName() + "\",realm=\"" + realm + "\",nonce=\"" + nonce + "\",uri=\"" + serverURI.getPath() + "\",response=\"" + response1 + "\",algorithm=\"" + algorithm + "\""));
                    response = httpClient.execute((ClassicHttpRequest)httpRequest);
                }
            }
        }
        catch (ClientProtocolException | AuthenticationException e) {
            LOGGER.error("request error", e);
            throw new SDKException("request error.", e.getMessage());
        }
        catch (ConnectException e) {
            LOGGER.error("device connect fail, error URI:" + httpRequest.getRequestUri());
            throw new InvokeException("500", "cu_connect_timeout");
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("device not return, error URI:" + httpRequest.getRequestUri());
            throw new InvokeException("500", "cu_device_not_return");
        }
        catch (IOException e) {
            LOGGER.error("request digest IOException error", (Throwable)e);
            throw new SDKException("cu_connect_timeout", "request error.");
        }
        catch (URISyntaxException | NoSuchAlgorithmException e) {
            LOGGER.error("httpsSendByGigest error", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOGGER.error("request error", (Throwable)e);
        }
        return response;
    }

    private static HttpUrlParam parseUrlParam(HttpServletRequest request) {
        Map paramsMap = request.getParameterMap();
        if (null == paramsMap || paramsMap.isEmpty()) {
            return null;
        }
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        for (Map.Entry entry : paramsMap.entrySet()) {
            String name = (String)entry.getKey();
            String[] value = (String[])entry.getValue();
            if (null == value || value.length == 0) continue;
            httpUrlParam.addParam(name, value[0]);
        }
        return httpUrlParam;
    }

    private static String parseStrEntity(HttpEntity entyity) throws ParseException, IOException {
        return null != entyity ? EntityUtils.toString((HttpEntity)entyity, (String)"UTF-8") : null;
    }

    public static <T> T requestDigestForTianDy(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        clientRequest.addHeaders(headers);
        int connectTimeout = 4000;
        int socketTimeout = 12000;
        HttpUriRequestBase httpRequest = clientRequest.buildXmlRequest(clientSessionContext.buildUrl());
        return (T)SDKClientApi.doRequestDigestForTianDy((ClientSessionContext)clientSessionContext, msgToObjectConvertor, (int)connectTimeout, (int)socketTimeout, (HttpUriRequestBase)httpRequest);
    }

    private static <T> T doRequestDigestForTianDy(ClientSessionContext clientSessionContext, MsgToObjectConvertor<T> msgToObjectConvertor, int connectTimeout, int responseTimeout, HttpUriRequestBase httpRequest) throws SDKException {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).setResponseTimeout((long)responseTimeout, TimeUnit.MILLISECONDS).build();
        httpRequest.setConfig(requestConfig);
        Object classt = null;
        try {
            CloseableHttpResponse httpResponse = SDKClientApi.requestDigestForTianDy((ClientSessionContext)clientSessionContext, (HttpUriRequestBase)httpRequest);
            int status = HttpUtils.parseStatusCode((ClassicHttpResponse)httpResponse);
            if (200 != status) {
                String msg = SDKClientApi.parseStrEntity((HttpEntity)httpResponse.getEntity());
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    throw new SDKException(String.valueOf(status), msg);
                }
                throw new SDKException(String.valueOf(status), String.valueOf(status));
            }
            if ("image/jpeg".equals(httpResponse.getEntity().getContentType())) {
                String content = "";
                try (InputStream inputStream = httpResponse.getEntity().getContent();){
                    content = FileUtil.getContentFromInputStream((InputStream)inputStream, (CloseableHttpResponse)httpResponse);
                }
                catch (IOException e) {
                    LOGGER.error("stream failed", (Throwable)e);
                    throw new InvokeException("500", e.getMessage());
                }
                if (content.length() > 0) {
                    content = content.replaceAll("[\\s*\t\n\r]", "");
                }
                return (T)content;
            }
            classt = msgToObjectConvertor.xmlToObjectOrString(httpResponse.getEntity());
        }
        catch (ClientProtocolException e) {
            LOGGER.error("do request digest connection timeout,url:{}", (Object)httpRequest.getRequestUri());
            throw new InvokeException("-1001", "connect remote fail.");
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("do request digest device return timeout,url:{}", (Object)httpRequest.getRequestUri());
            throw new InvokeException("-1002", "response timeout.");
        }
        catch (IOException e) {
            LOGGER.error("do request digest error", (Throwable)e);
            throw new SDKException("request error.", e.getMessage());
        }
        catch (ParseException e) {
            LOGGER.error("parseStrEntity error", (Throwable)e);
        }
        return (T)classt;
    }

    private static CloseableHttpResponse requestDigestForTianDy(ClientSessionContext clientSessionContext, HttpUriRequestBase httpRequest) throws SDKException {
        VcmReqBaseInfo vcmReqBaseInfo = clientSessionContext.getVcmReqBaseInfo();
        CloseableHttpResponse response = null;
        try {
            HttpClientBuilder builder = HttpRequestUtils.configFirst((int)3000, (long)10000L, (long)12000L);
            BasicCredentialsProvider credentialsStore = new BasicCredentialsProvider();
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(vcmReqBaseInfo.getSdcUserName(), vcmReqBaseInfo.getSdcPassword().toCharArray());
            credentialsStore.setCredentials(new AuthScope(vcmReqBaseInfo.getVcmIp(), Integer.parseInt(vcmReqBaseInfo.getVcmPort())), (Credentials)usernamePasswordCredentials);
            CloseableHttpClient httpClient = builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsStore).build();
            response = httpClient.execute((ClassicHttpRequest)httpRequest);
        }
        catch (ClientProtocolException e) {
            LOGGER.error("request error", (Throwable)e);
            throw new SDKException("request error.", e.getMessage());
        }
        catch (ConnectException e) {
            throw new InvokeException("500", "cu_connect_timeout");
        }
        catch (SocketTimeoutException e) {
            throw new InvokeException("500", "cu_device_not_return");
        }
        catch (IOException e) {
            LOGGER.error("request digest IOException error", (Throwable)e);
            throw new SDKException("cu_connect_timeout", "request error.");
        }
        catch (KeyManagementException e) {
            LOGGER.error("request error", (Throwable)e);
        }
        return response;
    }

    public static <T> T requestDigestForTianDy(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgResponseHandler<T> respHandler) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        int timeout = 12000;
        int connectTimeout = timeout <= 3 ? timeout : timeout / 3;
        return (T)SDKClientApi.requestDigestForTianDy((ClientSessionContext)clientSessionContext, (ClientRequest)clientRequest, (int)connectTimeout, (int)timeout, respHandler);
    }

    private static <T> T requestDigestForTianDy(ClientSessionContext clientSessionContext, ClientRequest clientRequest, int connectTimeout, int socketTimeout, MsgResponseHandler<T> respHandler) throws SDKException {
        Object classt;
        HttpUriRequestBase httpRequest = clientRequest.buildRequest(clientSessionContext.buildUrl());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).setResponseTimeout((long)socketTimeout, TimeUnit.MILLISECONDS).build();
        httpRequest.setConfig(requestConfig);
        try {
            CloseableHttpResponse httpResponse = SDKClientApi.requestDigestForTianDy((ClientSessionContext)clientSessionContext, (HttpUriRequestBase)httpRequest);
            int status = HttpUtils.parseStatusCode((ClassicHttpResponse)httpResponse);
            if (200 != status) {
                String msg = SDKClientApi.parseStrEntity((HttpEntity)httpResponse.getEntity());
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    throw new SDKException(String.valueOf(status), msg);
                }
                throw new SDKException(String.valueOf(status), String.valueOf(status));
            }
            classt = respHandler.hanlde((HttpResponse)httpResponse);
        }
        catch (ClientProtocolException e) {
            LOGGER.error("request error", (Throwable)e);
            throw new InvokeException("500", "cu_connect_timeout");
        }
        catch (SocketTimeoutException e) {
            throw new InvokeException("500", "cu_device_not_return");
        }
        catch (IOException | ParseException e) {
            LOGGER.error("request error", e);
            throw new SDKException("request error.", e.getMessage());
        }
        return (T)classt;
    }

    public static <T> T requestDigestForDaHua(ClientSessionContext clientSessionContext, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        ClientRequest clientRequest = new ClientRequest(msgType, httpParam, objectToMsgConvertor);
        clientRequest.addHeaders(headers);
        int connectTimeout = 4000;
        int socketTimeout = 12000;
        HttpUriRequestBase httpRequest = clientRequest.buildRequest(clientSessionContext.buildUrl());
        return (T)SDKClientApi.doRequestDigestForDaHua((ClientSessionContext)clientSessionContext, msgToObjectConvertor, (int)connectTimeout, (int)socketTimeout, (HttpUriRequestBase)httpRequest);
    }

    private static <T> T doRequestDigestForDaHua(ClientSessionContext clientSessionContext, MsgToObjectConvertor<T> msgToObjectConvertor, int connectTimeout, int responseTimeout, HttpUriRequestBase httpRequest) throws SDKException {
        String classt;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).setResponseTimeout((long)responseTimeout, TimeUnit.MILLISECONDS).build();
        httpRequest.setConfig(requestConfig);
        try {
            CloseableHttpResponse httpResponse = SDKClientApi.requestDigest((ClientSessionContext)clientSessionContext, (HttpUriRequestBase)httpRequest);
            int status = HttpUtils.parseStatusCode((ClassicHttpResponse)httpResponse);
            if (200 != status) {
                if (400 == status || 500 == status) {
                    String msg = SDKClientApi.parseStrEntity((HttpEntity)httpResponse.getEntity());
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                    throw new SDKException(String.valueOf(status), msg);
                }
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                throw new SDKException(String.valueOf(status), String.valueOf(status));
            }
            if ("image/jpeg".equals(httpResponse.getEntity().getContentType())) {
                String content = "";
                try (InputStream inputStream = httpResponse.getEntity().getContent();){
                    content = FileUtil.getContentFromInputStream((InputStream)inputStream, (CloseableHttpResponse)httpResponse);
                }
                catch (IOException e) {
                    LOGGER.error("stream failed", (Throwable)e);
                    throw new InvokeException("500", e.getMessage());
                }
                if (content.length() > 0) {
                    content = content.replaceAll("[\\s*\t\n\r]", "");
                }
                return (T)content;
            }
            classt = DigestUtils.inputStreamToString((InputStream)httpResponse.getEntity().getContent());
        }
        catch (ClientProtocolException e) {
            LOGGER.error("do request digest connection timeout,url:{}", (Object)httpRequest.getRequestUri());
            throw new InvokeException("-1001", "connect remote fail.");
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("do request digest device return timeout,url:{}", (Object)httpRequest.getRequestUri());
            throw new InvokeException("-1002", "response timeout.");
        }
        catch (IOException | ParseException e) {
            LOGGER.error("do request digest error", e);
            throw new SDKException("request error.", e.getMessage());
        }
        catch (ProtocolException e) {
            LOGGER.error("do request digest error", (Throwable)e);
            throw new SDKException("request error.", e.getMessage());
        }
        return (T)classt;
    }
}

