/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils.httpclient;

import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.SDKClientApi;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.SDKHttpClient;
import java.security.KeyManagementException;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSessionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SDKClientApi.class);
    private VcmReqBaseInfo vcmReqBaseInfo;
    public Integer retryTimes = 3;
    private static SDKHttpClient sdkHttpClient = new SDKHttpClient();

    public ClientSessionContext(VcmReqBaseInfo vcmReqBaseInfo) {
        this.vcmReqBaseInfo = vcmReqBaseInfo;
    }

    public CloseableHttpClient getHttpClient() throws SDKException {
        return sdkHttpClient.getHttpClient();
    }

    public VcmReqBaseInfo getVcmReqBaseInfo() {
        return this.vcmReqBaseInfo;
    }

    public void setVcmReqBaseInfo(VcmReqBaseInfo vcmReqBaseInfo) {
        this.vcmReqBaseInfo = vcmReqBaseInfo;
    }

    public String buildUrl() {
        if (DeviceTypeEnum.CLOUD.val() == this.vcmReqBaseInfo.getVcmType().intValue() || DeviceTypeEnum.ONVIFNVR.val() == this.vcmReqBaseInfo.getVcmType().intValue() || DeviceTypeEnum.ONVIFIPC.val() == this.vcmReqBaseInfo.getVcmType().intValue()) {
            return this.vcmReqBaseInfo.getVcmIp();
        }
        if (DeviceTypeEnum.NVR800.val() == this.vcmReqBaseInfo.getVcmType().intValue() && "80".equals(this.vcmReqBaseInfo.getVcmPort())) {
            return "http://" + this.vcmReqBaseInfo.getVcmIp() + ":" + this.vcmReqBaseInfo.getVcmPort();
        }
        if (DeviceTypeEnum.TIANDY.val() == this.vcmReqBaseInfo.getVcmType().intValue()) {
            return "http://" + this.vcmReqBaseInfo.getVcmIp() + ":" + this.vcmReqBaseInfo.getVcmPort();
        }
        if (DeviceTypeEnum.HIKVISION.val() == this.vcmReqBaseInfo.getVcmType().intValue()) {
            return "http://" + this.vcmReqBaseInfo.getVcmIp();
        }
        if ("80".equals(this.vcmReqBaseInfo.getVcmPort())) {
            return "http://" + this.vcmReqBaseInfo.getVcmIp() + ":" + this.vcmReqBaseInfo.getVcmPort();
        }
        return "https://" + this.vcmReqBaseInfo.getVcmIp() + ":" + this.vcmReqBaseInfo.getVcmPort();
    }

    static {
        try {
            sdkHttpClient.init(3000, 10000, 12000);
        }
        catch (KeyManagementException e) {
            LOGGER.error("SDKHttpClient init error1", (Throwable)e);
        }
    }
}

