/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils.httpclient;

import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ClientRequest;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.HttpDeleteWithBody;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;

public class ClientRequest {
    private final MsgType msgType;
    private final HttpUrlParam urlParam;
    private final ObjectToMsgConvertor<?> objectMsg;
    private List<Header> headerList = new ArrayList();
    private final String[] HTTP_HEADERS = new String[]{"Content-Disposition", "Content-Type", "Accept-Ranges", "Range", "Domain-Route"};

    public ClientRequest(MsgType msgType, HttpUrlParam urlParam, ObjectToMsgConvertor<?> objectMsg) {
        this.msgType = msgType;
        this.urlParam = urlParam;
        this.objectMsg = objectMsg;
    }

    public HttpUriRequestBase buildAudioRequestMultipart(String preUrl, File file, String jsonContent) {
        HttpPost request = new HttpPost(this.buildRequestUrl(preUrl));
        HttpEntity httpEntity = MultipartEntityBuilder.create().addPart("name", (ContentBody)new FileBody(file, ContentType.create((String)"audio/wav", (String)"UTF-8"))).addPart("json", (ContentBody)new StringBody(jsonContent, ContentType.APPLICATION_JSON)).build();
        request.setEntity(httpEntity);
        return request;
    }

    public HttpUriRequestBase buildRequestForm(String preUrl, HttpEntity entity) {
        HttpPost request = new HttpPost(this.buildRequestUrl(preUrl));
        request.setEntity(entity);
        for (Header header : this.headerList) {
            request.setHeader(header);
        }
        return request;
    }

    public void addHeader(Header header) {
        if (null != header) {
            this.headerList.add(header);
        }
    }

    public void addHeaders(List<Header> headers) {
        if (null != headers) {
            this.headerList = headers;
        }
    }

    public void parseHeaders(HttpServletRequest httpServletRequest) {
        if (null == httpServletRequest) {
            return;
        }
        for (String headerName : this.HTTP_HEADERS) {
            String headerValues = httpServletRequest.getHeader(headerName);
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{headerValues})) continue;
            this.addHeader((Header)new BasicHeader(headerName, (Object)headerValues));
        }
    }

    public HttpUriRequestBase buildRequest(String preUrl) throws SDKException {
        HttpUriRequestBase request = null;
        switch (1.$SwitchMap$com$zkteco$zkbiosecurity$cuserver$enums$HttpMethodEnum[this.msgType.getMethod().ordinal()]) {
            case 1: {
                request = this.buildGetRequest(preUrl);
                break;
            }
            case 2: {
                request = this.buildPostRequest(preUrl);
                break;
            }
            case 3: {
                request = this.buildFormRequest(preUrl);
                break;
            }
            case 4: {
                request = this.buildPutRequest(preUrl);
                break;
            }
            case 5: {
                request = this.buildPatchRequest(preUrl);
                break;
            }
            case 6: {
                request = this.buildDeleteRequest(preUrl);
                break;
            }
        }
        if (null != request) {
            for (Header header : this.headerList) {
                request.addHeader(header);
            }
        }
        return request;
    }

    public HttpUriRequestBase buildRequestMultipart(String preUrl, File file, String jsonContent) {
        HttpPost request = new HttpPost(this.buildRequestUrl(preUrl));
        HttpEntity httpEntity = MultipartEntityBuilder.create().addPart("file", (ContentBody)new FileBody(file)).addPart("json", (ContentBody)new StringBody(jsonContent, ContentType.APPLICATION_JSON)).build();
        request.setEntity(httpEntity);
        return request;
    }

    private HttpUriRequestBase buildPostRequest(String url) throws SDKException {
        HttpPost request = new HttpPost(this.buildRequestUrl(url));
        if (null != this.objectMsg) {
            request.setEntity(this.objectMsg.toMsg());
        }
        return request;
    }

    private HttpUriRequestBase buildPatchRequest(String url) throws SDKException {
        HttpPatch request = new HttpPatch(this.buildRequestUrl(url));
        for (Header header : this.headerList) {
            request.addHeader(header);
        }
        if (null != this.objectMsg) {
            request.setEntity(this.objectMsg.toMsg());
        }
        return request;
    }

    private HttpUriRequestBase buildPutRequest(String url) throws SDKException {
        HttpPut request = new HttpPut(this.buildRequestUrl(url));
        if (null != this.objectMsg) {
            request.setEntity(this.objectMsg.toMsg());
        }
        return request;
    }

    private HttpUriRequestBase buildDeleteRequest(String url) throws SDKException {
        HttpDeleteWithBody request = new HttpDeleteWithBody(this.buildRequestUrl(url));
        for (Header header : this.headerList) {
            request.addHeader(header);
        }
        if (null != this.objectMsg) {
            request.setEntity(this.objectMsg.toMsg());
        }
        return request;
    }

    private HttpUriRequestBase buildFormRequest(String url) throws SDKException {
        this.headerList.add(new BasicHeader("Content-Type", (Object)"application/x-www-form-urlencoded; charset=UTF-8"));
        return this.buildPostRequest(url);
    }

    private HttpUriRequestBase buildGetRequest(String url) throws SDKException {
        HttpGet request = new HttpGet(this.buildRequestUrl(url));
        if (null != this.objectMsg) {
            request.setEntity(this.objectMsg.toMsg());
        }
        return request;
    }

    private String buildRequestUrl(String url) {
        String urlCopy = this.msgType.isFullUrl() ? this.msgType.getUri() : url + this.msgType.getUri();
        return null == this.urlParam ? urlCopy : urlCopy + "?" + this.urlParam.encodeUrlParam();
    }

    public HttpUriRequestBase buildPutXMLRequest(String preUrl) {
        HttpPut request = new HttpPut(this.buildRequestUrl(preUrl));
        if (Objects.nonNull(this.objectMsg)) {
            StringEntity entity = new StringEntity((String)this.objectMsg.getObj(), ContentType.APPLICATION_XML);
            request.setEntity((HttpEntity)entity);
        }
        return request;
    }

    public HttpUriRequestBase buildPostXMLRequest(String preUrl) {
        HttpPost request = new HttpPost(this.buildRequestUrl(preUrl));
        if (Objects.nonNull(this.objectMsg)) {
            StringEntity entity = new StringEntity((String)this.objectMsg.getObj(), ContentType.APPLICATION_XML);
            request.setEntity((HttpEntity)entity);
        }
        return request;
    }

    public HttpUriRequestBase buildXmlRequest(String preUrl) throws SDKException {
        HttpUriRequestBase request = null;
        switch (1.$SwitchMap$com$zkteco$zkbiosecurity$cuserver$enums$HttpMethodEnum[this.msgType.getMethod().ordinal()]) {
            case 1: {
                request = this.buildGetRequest(preUrl);
                break;
            }
            case 2: {
                request = this.buildPostXMLRequest(preUrl);
                break;
            }
            case 4: {
                request = this.buildPutXMLRequest(preUrl);
                break;
            }
            case 6: {
                request = this.buildDeleteRequest(preUrl);
                break;
            }
        }
        return request;
    }
}

