/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrAlarmTime;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrMotionHandleType;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrPtz;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZKNvrUtils {
    private static final Map<String, String> CONFIG_MAP = new HashMap();

    public static JSONObject buildMotionHandleTypeToJson(JSONObject motionHandleTypeJson, ZKNvrMotionHandleType motionHandleType) {
        if (Objects.nonNull(motionHandleType)) {
            List relAlarmOut;
            Integer handleType = motionHandleType.getHandleType();
            if (Objects.nonNull(handleType)) {
                motionHandleTypeJson.put("HandleType", (Object)handleType);
            }
            if (Objects.nonNull(relAlarmOut = motionHandleType.getRelAlarmOut())) {
                motionHandleTypeJson.put("RelAlarmOut", (Object)relAlarmOut.toArray());
            }
        }
        return motionHandleTypeJson;
    }

    public static JSONObject buildPtzToJson(JSONObject ptzJson, ZKNvrPtz ptz) {
        if (Objects.nonNull(ptz)) {
            List trackNo;
            List trackEnable;
            List presetNo;
            List presetEnable;
            List cruiseNo;
            List cruiseEnable = ptz.getCruiseEnable();
            if (Objects.nonNull(cruiseEnable)) {
                ptzJson.put("CruiseEnable", (Object)cruiseEnable.toArray());
            }
            if (Objects.nonNull(cruiseNo = ptz.getCruiseNo())) {
                ptzJson.put("CruiseNo", (Object)cruiseNo.toArray());
            }
            if (Objects.nonNull(presetEnable = ptz.getPresetEnable())) {
                ptzJson.put("PresetEnable", (Object)presetEnable.toArray());
            }
            if (Objects.nonNull(presetNo = ptz.getPresetNo())) {
                ptzJson.put("PresetNo", (Object)presetNo.toArray());
            }
            if (Objects.nonNull(trackEnable = ptz.getTrackEnable())) {
                ptzJson.put("TrackEnable", (Object)trackEnable.toArray());
            }
            if (Objects.nonNull(trackNo = ptz.getTrackNo())) {
                ptzJson.put("TrackNo", (Object)trackNo.toArray());
            }
        }
        return ptzJson;
    }

    public static List<List<List<Integer>>> buildAlarmTimeToJson(List<List<ZKNvrAlarmTime>> alarmTime) {
        ArrayList<List<List<Integer>>> alarmTimeList = new ArrayList<List<List<Integer>>>();
        for (int i = 0; i < 7; ++i) {
            ArrayList dayAlarmTime = new ArrayList();
            List<ZKNvrAlarmTime> alarmTimes = alarmTime.get(i);
            for (int j = 0; j < 8; ++j) {
                ArrayList<Integer> alarmTimeQuantumList = new ArrayList<Integer>();
                ZKNvrAlarmTime alarmTimeQuantum = alarmTimes.get(j);
                String[] startTime = alarmTimeQuantum.getStartTime().split(":");
                alarmTimeQuantumList.add(Integer.valueOf(startTime[0].startsWith("0") ? startTime[0].substring(1, 2) : startTime[0]));
                alarmTimeQuantumList.add(Integer.valueOf(startTime[1].startsWith("0") ? startTime[1].substring(1, 2) : startTime[1]));
                String[] endTime = alarmTimeQuantum.getEndTime().split(":");
                alarmTimeQuantumList.add(Integer.valueOf(endTime[0].startsWith("0") ? endTime[0].substring(1, 2) : endTime[0]));
                alarmTimeQuantumList.add(Integer.valueOf(endTime[1].startsWith("0") ? endTime[1].substring(1, 2) : endTime[1]));
                dayAlarmTime.add(alarmTimeQuantumList);
            }
            alarmTimeList.add(dayAlarmTime);
        }
        return alarmTimeList;
    }

    public static List<List<ZKNvrAlarmTime>> buildJsonToAlarmTime(JSONArray alarmTimesJson) {
        ArrayList<List<ZKNvrAlarmTime>> alarmTimes = new ArrayList<List<ZKNvrAlarmTime>>();
        if (Objects.nonNull(alarmTimesJson) && alarmTimesJson.size() > 0) {
            for (int i = 0; i < alarmTimesJson.size(); ++i) {
                ArrayList<ZKNvrAlarmTime> alarmTimes4week = new ArrayList<ZKNvrAlarmTime>();
                JSONArray alarmTimeJson = alarmTimesJson.getJSONArray(i);
                for (int j = 0; j < alarmTimeJson.size(); ++j) {
                    ZKNvrAlarmTime alarmTime = new ZKNvrAlarmTime();
                    JSONArray time = alarmTimeJson.getJSONArray(j);
                    alarmTime.setIndex(Integer.valueOf(j + 1));
                    alarmTime.setStartTime(ZKNvrUtils.buildAlarmTime((JSONArray)time, (Boolean)true));
                    alarmTime.setEndTime(ZKNvrUtils.buildAlarmTime((JSONArray)time, (Boolean)false));
                    alarmTimes4week.add(alarmTime);
                }
                alarmTimes.add(alarmTimes4week);
            }
        }
        return alarmTimes;
    }

    private static String buildAlarmTime(JSONArray alarmTimeJson, Boolean isStart) {
        String time = "";
        time = isStart != false ? ZKNvrUtils.timeAddZero((String)alarmTimeJson.getString(0)) + ":" + ZKNvrUtils.timeAddZero((String)alarmTimeJson.getString(1)) : ZKNvrUtils.timeAddZero((String)alarmTimeJson.getString(2)) + ":" + ZKNvrUtils.timeAddZero((String)alarmTimeJson.getString(3));
        return time;
    }

    private static String timeAddZero(String num) {
        if (num.length() < 2 && num.length() > 0) {
            num = "0" + num;
        }
        return num;
    }

    public static ZKNvrPtz buildJsonToPtz(JSONObject ptzJson) {
        ZKNvrPtz ptz = new ZKNvrPtz();
        if (Objects.nonNull(ptzJson)) {
            ptz.setPresetEnable(ptzJson.getJSONArray("PresetEnable").toJavaList(Integer.class));
            ptz.setPresetNo(ptzJson.getJSONArray("PresetNo").toJavaList(Integer.class));
            ptz.setCruiseEnable(ptzJson.getJSONArray("CruiseEnable").toJavaList(Integer.class));
            ptz.setCruiseNo(ptzJson.getJSONArray("CruiseNo").toJavaList(Integer.class));
            ptz.setTrackEnable(ptzJson.getJSONArray("TrackEnable").toJavaList(Integer.class));
            ptz.setTrackNo(ptzJson.getJSONArray("TrackNo").toJavaList(Integer.class));
        }
        return ptz;
    }

    public static void setConfig(String key, String rtspPort) {
        CONFIG_MAP.put(key, rtspPort);
    }

    public static String getConfig(String key) {
        return (String)CONFIG_MAP.get(key);
    }

    public static void delConfig(String key) {
        CONFIG_MAP.remove(key);
    }
}

