/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdcReasonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SdcReasonUtil.class);
    public static String CU_FACE_REPOSITORY_NOT_EXIST = "CU_FACE_REPOSITORY_NOT_EXIST";
    public static String CU_FACE_REPOSITORY_EXIST = "CU_FACE_REPOSITORY_EXIST";
    public static String CU_FACE_NOT_EXIST = "CU_FACE_NOT_EXIST";
    public static String CU_FACE_NOT_PICTURE = "CU_FACE_NOT_PICTURE";
    public static String CU_FACE_NOT_NAME = "CU_FACE_NOT_NAME";

    public static String reasonHelper(SDKException e) {
        if ("503".equals(e.getErrorCode())) {
            return "server_rejected";
        }
        if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
            return "cu_device_not_return";
        }
        try {
            String reason = "";
            JSONObject message = JSONObject.parseObject((String)e.getMessage());
            if (message.containsKey((Object)"ResponseStatus")) {
                reason = message.getJSONObject("ResponseStatus").getString("StatusCode");
            }
            if (message.containsKey((Object)"StatusCode")) {
                reason = message.getString("StatusCode");
            }
            if (StringUtils.isBlank((CharSequence)reason)) {
                return "unknown_error";
            }
            return reason;
        }
        catch (Exception exception) {
            LOGGER.info("reason util error data:{}", (Object)e.getMessage());
            LOGGER.error("reason util error", (Throwable)exception);
            return e.getMessage();
        }
    }
}

