/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

/*
 * Exception performing whole class analysis ignored.
 */
public class PKCS1ToSubjectPublicKeyInfo {
    private static final int SEQUENCE_TAG = 48;
    private static final int BIT_STRING_TAG = 3;
    private static final byte[] NO_UNUSED_BITS = new byte[]{0};
    private static final byte[] RSA_ALGORITHM_IDENTIFIER_SEQUENCE = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0};

    public static RSAPublicKey decodePKCS1PublicKey(byte[] pkcs1PublicKeyEncoding) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] subjectPublicKeyInfo2 = PKCS1ToSubjectPublicKeyInfo.createSubjectPublicKeyInfoEncoding((byte[])pkcs1PublicKeyEncoding);
        KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
        return (RSAPublicKey)rsaKeyFactory.generatePublic(new X509EncodedKeySpec(subjectPublicKeyInfo2));
    }

    public static byte[] createSubjectPublicKeyInfoEncoding(byte[] pkcs1PublicKeyEncoding) {
        byte[] subjectPublicKeyBitString = PKCS1ToSubjectPublicKeyInfo.createDEREncoding((int)3, (byte[])PKCS1ToSubjectPublicKeyInfo.concat((byte[][])new byte[][]{NO_UNUSED_BITS, pkcs1PublicKeyEncoding}));
        byte[] subjectPublicKeyInfoValue = PKCS1ToSubjectPublicKeyInfo.concat((byte[][])new byte[][]{RSA_ALGORITHM_IDENTIFIER_SEQUENCE, subjectPublicKeyBitString});
        return PKCS1ToSubjectPublicKeyInfo.createDEREncoding((int)48, (byte[])subjectPublicKeyInfoValue);
    }

    private static byte[] concat(byte[] ... bas) {
        int len = 0;
        for (byte[] ba : bas) {
            len += ba.length;
        }
        byte[] buf = new byte[len];
        int off = 0;
        for (byte[] ba : bas) {
            System.arraycopy(ba, 0, buf, off, ba.length);
            off += ba.length;
        }
        return buf;
    }

    private static byte[] createDEREncoding(int tag, byte[] value) {
        if (tag < 0 || tag >= 255) {
            throw new IllegalArgumentException("Currently only single byte tags supported");
        }
        byte[] lengthEncoding = PKCS1ToSubjectPublicKeyInfo.createDERLengthEncoding((int)value.length);
        int size = 1 + lengthEncoding.length + value.length;
        byte[] derEncodingBuf = new byte[size];
        int off = 0;
        derEncodingBuf[off++] = (byte)tag;
        System.arraycopy(lengthEncoding, 0, derEncodingBuf, off, lengthEncoding.length);
        System.arraycopy(value, 0, derEncodingBuf, off += lengthEncoding.length, value.length);
        return derEncodingBuf;
    }

    private static byte[] createDERLengthEncoding(int size) {
        if (size <= 127) {
            return new byte[]{(byte)size};
        }
        if (size <= 255) {
            return new byte[]{-127, (byte)size};
        }
        if (size <= 65535) {
            return new byte[]{-126, (byte)(size >> 8), (byte)size};
        }
        throw new IllegalArgumentException("size too large, only up to 64KiB length encoding supported: " + size);
    }
}

