/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.config.ConfigHolder;
import com.zkteco.zkbiosecurity.cuserver.contants.OnvifMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.onvif.Device;
import com.zkteco.zkbiosecurity.cuserver.dto.request.onvif.MediaProfile;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class OnvifUtils {
    private static final Logger log = LoggerFactory.getLogger(OnvifUtils.class);
    private static final Map<String, Device> DEVICE_MAP = new HashMap();
    public static final String TOKEN_SPLIT_FLAG = "&";

    public static JSONObject xml2Json(String xmlStr) {
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xmlStr);
        }
        catch (DocumentException e) {
            log.info("DocumentException error: {}", (Object)e.getMessage());
        }
        JSONObject json = new JSONObject();
        OnvifUtils.dom4j2Json((Element)doc.getRootElement(), (JSONObject)json);
        return json;
    }

    public static void main(String[] args) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:SOAP-ENC=\"http://www.w3.org/2003/05/soap-encoding\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:c14n=\"http://www.w3.org/2001/10/xml-exc-c14n#\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" xmlns:wsadis=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" xmlns:wsrp=\"http://schemas.xmlsoap.org/rp/\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" xmlns:d=\"http://schemas.xmlsoap.org/ws/2005/04/discovery\" xmlns:wsa5=\"http://www.w3.org/2005/08/addressing\" xmlns:xmime=\"http://www.w3.org/2005/05/xmlmime\" xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" xmlns:ter=\"http://www.onvif.org/ver10/error\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:soap12=\"http://tempuri.org/soap12.xsd\" xmlns:http=\"http://schemas.xmlsoap.org/wsdl/http/\" xmlns:tnsn=\"http://www.eventextension.com/2011/event/topics\" xmlns:tt=\"http://www.onvif.org/ver10/schema\" xmlns:wsrfbf=\"http://docs.oasis-open.org/wsrf/bf-2\" xmlns:wstop=\"http://docs.oasis-open.org/wsn/t-1\" xmlns:tns1=\"http://www.onvif.org/ver10/topics\" xmlns:wsrfr=\"http://docs.oasis-open.org/wsrf/r-2\" xmlns:dndl=\"http://www.onvif.org/ver10/network/wsdl/DiscoveryLookupBinding\" xmlns:dnrd=\"http://www.onvif.org/ver10/network/wsdl/RemoteDiscoveryBinding\" xmlns:dn=\"http://www.onvif.org/ver10/network/wsdl\" xmlns:tds=\"http://www.onvif.org/ver10/device/wsdl\" xmlns:tevcp=\"http://www.onvif.org/ver10/events/wsdl/CreatePullPointBinding\" xmlns:teve=\"http://www.onvif.org/ver10/events/wsdl/EventBinding\" xmlns:tevnc=\"http://www.onvif.org/ver10/events/wsdl/NotificationConsumerBinding\" xmlns:tevnp=\"http://www.onvif.org/ver10/events/wsdl/NotificationProducerBinding\" xmlns:tevp=\"http://www.onvif.org/ver10/events/wsdl/PullPointBinding\" xmlns:tev=\"http://www.onvif.org/ver10/events/wsdl\" xmlns:tevps=\"http://www.onvif.org/ver10/events/wsdl/PullPointSubscriptionBinding\" xmlns:tevpsm=\"http://www.onvif.org/ver10/events/wsdl/PausableSubscriptionManagerBinding\" xmlns:wsnt=\"http://docs.oasis-open.org/wsn/b-2\" xmlns:tevsm=\"http://www.onvif.org/ver10/events/wsdl/SubscriptionManagerBinding\" xmlns:timg=\"http://www.onvif.org/ver20/imaging/wsdl\" xmlns:timg10=\"http://www.onvif.org/ver10/imaging/wsdl\" xmlns:tmd=\"http://www.onvif.org/ver10/deviceIO/wsdl\" xmlns:tptz=\"http://www.onvif.org/ver20/ptz/wsdl\" xmlns:tptz10=\"http://www.onvif.org/ver10/ptz/wsdl\" xmlns:tr2=\"http://www.onvif.org/ver20/media/wsdl\" xmlns:trc=\"http://www.onvif.org/ver10/recording/wsdl\" xmlns:trp=\"http://www.onvif.org/ver10/replay/wsdl\" xmlns:trt=\"http://www.onvif.org/ver10/media/wsdl\" xmlns:tse=\"http://www.onvif.org/ver10/search/wsdl\">\n\t<SOAP-ENV:Header>\n\t\t<wsa5:Action SOAP-ENV:mustUnderstand=\"true\">http://www.onvif.org/ver10/events/wsdl/PullPointSubscription/PullMessagesResponse</wsa5:Action>\n\t</SOAP-ENV:Header>\n\t<SOAP-ENV:Body>\n\t\t<tev:PullMessagesResponse>\n\t\t\t<tev:CurrentTime>2023-04-06T06:15:43Z</tev:CurrentTime>\n\t\t\t<tev:TerminationTime>2023-04-06T06:28:00Z</tev:TerminationTime>\n\t\t\t<wsnt:NotificationMessage>\n\t\t\t\t<wsnt:Topic Dialect=\"http://www.onvif.org/ver10/tev/topicExpression/ConcreteSet\">tns1:RuleEngine/CellMotionDetector/Motion</wsnt:Topic>\n\t\t\t\t<wsnt:ProducerReference>\n\t\t\t\t\t<wsa5:Address>http://192.168.0.225:8080/onvif/Event/PullSubManager_56ddbeb886d4ed11b92560123cf32c04</wsa5:Address>\n\t\t\t\t</wsnt:ProducerReference>\n\t\t\t\t<wsnt:Message>\n\t\t\t\t\t<tt:Message UtcTime=\"2023-04-06T06:15:35Z\" PropertyOperation=\"Changed\">\n\t\t\t\t\t\t<tt:Source>\n\t\t\t\t\t\t\t<tt:SimpleItem Name=\"VideoSourceConfigurationToken\" Value=\"VideoSourceToken_1\"/>\n\t\t\t\t\t\t\t<tt:SimpleItem Name=\"VideoAnalyticsConfigurationToken\" Value=\"VideoAnalyticsToken_1\"/>\n\t\t\t\t\t\t\t<tt:SimpleItem Name=\"Rule\" Value=\"MyMotionDetectorRule_1\"/>\n\t\t\t\t\t\t</tt:Source>\n\t\t\t\t\t\t<tt:Data>\n\t\t\t\t\t\t\t<tt:SimpleItem Name=\"IsMotion\" Value=\"true\"/>\n\t\t\t\t\t\t</tt:Data>\n\t\t\t\t\t</tt:Message>\n\t\t\t\t</wsnt:Message>\n\t\t\t</wsnt:NotificationMessage>\n\t\t\t<wsnt:NotificationMessage>\n\t\t\t\t<wsnt:Topic Dialect=\"http://www.onvif.org/ver10/tev/topicExpression/ConcreteSet\">tns1:VideoAnalytics/MotionAlarm</wsnt:Topic>\n\t\t\t\t<wsnt:ProducerReference>\n\t\t\t\t\t<wsa5:Address>http://192.168.0.225:8080/onvif/Event/PullSubManager_56ddbeb886d4ed11b92560123cf32c04</wsa5:Address>\n\t\t\t\t</wsnt:ProducerReference>\n\t\t\t\t<wsnt:Message>\n\t\t\t\t\t<tt:Message UtcTime=\"2023-04-06T06:15:40Z\" PropertyOperation=\"Initialized\">\n\t\t\t\t\t\t<tt:Source>\n\t\t\t\t\t\t\t<tt:SimpleItem Name=\"VideoSourceToken\" Value=\"VideoSource_1\"/>\n\t\t\t\t\t\t\t<tt:SimpleItem Name=\"AlarmAreaID\" Value=\"0\"/>\n\t\t\t\t\t\t</tt:Source>\n\t\t\t\t\t\t<tt:Data>\n\t\t\t\t\t\t\t<tt:SimpleItem Name=\"EffectState\" Value=\"true\"/>\n\t\t\t\t\t\t</tt:Data>\n\t\t\t\t\t</tt:Message>\n\t\t\t\t</wsnt:Message>\n\t\t\t</wsnt:NotificationMessage>\n\t\t</tev:PullMessagesResponse>\n\t</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>";
        JSONObject data = OnvifUtils.xml2Json((String)xml);
        log.info("formate data: {}", (Object)data);
    }

    private static void iterateNodes(Element node, JSONObject json) {
        String nodeName = node.getName();
        if (json.containsKey((Object)nodeName)) {
            Object Object2 = json.get((Object)nodeName);
            JSONArray array = null;
            if (Object2 instanceof JSONArray) {
                array = (JSONArray)Object2;
            } else {
                array = new JSONArray();
                array.add(Object2);
            }
            List listElement = node.elements();
            if (listElement.isEmpty()) {
                String nodeValue = node.getTextTrim();
                array.add((Object)nodeValue);
                json.put(nodeName, (Object)array);
                return;
            }
            JSONObject newJson = new JSONObject();
            for (Element e : listElement) {
                OnvifUtils.iterateNodes((Element)e, (JSONObject)newJson);
            }
            array.add((Object)newJson);
            json.put(nodeName, (Object)array);
            return;
        }
        List listElement = node.elements();
        if (listElement.isEmpty()) {
            String nodeValue = node.getTextTrim();
            json.put(nodeName, (Object)nodeValue);
            return;
        }
        JSONObject object = new JSONObject();
        for (Element e : listElement) {
            OnvifUtils.iterateNodes((Element)e, (JSONObject)object);
        }
        json.put(nodeName, (Object)object);
    }

    private static void dom4j2Json(Element element, JSONObject json) {
        for (Object o : element.attributes()) {
            Attribute attr = (Attribute)o;
            if (!StringUtils.isNotBlank((CharSequence)attr.getValue())) continue;
            json.put("@" + attr.getName(), (Object)attr.getValue());
        }
        List childElements = element.elements();
        if (childElements.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)element.getText())) {
                json.put(element.getName(), (Object)element.getText());
            }
        } else {
            for (Element e : childElements) {
                JSONObject jsonObject;
                JSONArray jsonArray;
                Object o;
                JSONObject childJson;
                if (!e.elements().isEmpty()) {
                    childJson = new JSONObject();
                    OnvifUtils.dom4j2Json((Element)e, (JSONObject)childJson);
                    o = json.get((Object)e.getName());
                    if (o != null) {
                        jsonArray = null;
                        if (o instanceof JSONObject) {
                            jsonObject = (JSONObject)o;
                            jsonArray = new JSONArray();
                            jsonArray.add((Object)jsonObject);
                            jsonArray.add((Object)childJson);
                            json.put(e.getName(), (Object)jsonArray);
                            continue;
                        }
                        if (!(o instanceof JSONArray)) continue;
                        jsonArray = (JSONArray)o;
                        jsonArray.add((Object)childJson);
                        continue;
                    }
                    if (childJson.isEmpty()) continue;
                    json.put(e.getName(), (Object)childJson);
                    continue;
                }
                childJson = new JSONObject();
                o = e.attributes().iterator();
                while (o.hasNext()) {
                    Object o2 = o.next();
                    Attribute attr = (Attribute)o2;
                    if (!StringUtils.isNotBlank((CharSequence)attr.getValue())) continue;
                    childJson.put("@" + attr.getName(), (Object)attr.getValue());
                }
                if (StringUtils.isNotBlank((CharSequence)e.getText())) {
                    childJson.put(e.getName(), (Object)e.getText());
                }
                if ((o = json.get((Object)e.getName())) != null) {
                    jsonArray = null;
                    if (o instanceof JSONObject) {
                        jsonObject = (JSONObject)o;
                        jsonArray = new JSONArray();
                        jsonArray.add((Object)jsonObject);
                        jsonArray.add((Object)childJson);
                        json.put(e.getName(), (Object)jsonArray);
                        continue;
                    }
                    if (!(o instanceof JSONArray)) continue;
                    jsonArray = (JSONArray)o;
                    jsonArray.add((Object)childJson);
                    continue;
                }
                if (childJson.isEmpty()) continue;
                json.put(e.getName(), (Object)childJson);
            }
        }
    }

    public static String jsonObjToXml(JSONObject jo, String root) {
        JSONObject jo0 = new JSONObject();
        jo0.put(root == null ? "info" : root, (Object)jo);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + OnvifUtils.jsontoxml((JSONObject)jo0, (String)"");
        return xml;
    }

    public static String jsontoxml(JSONObject jo, String gt) {
        StringBuffer xmlStr = new StringBuffer();
        try {
            for (Map.Entry entry : jo.entrySet()) {
                String key = entry.getKey().toString();
                String val = entry.getValue().toString();
                if (val.charAt(0) == '{') {
                    xmlStr.append(gt);
                    xmlStr.append("<");
                    xmlStr.append(key);
                    xmlStr.append(">\n");
                    xmlStr.append(OnvifUtils.jsontoxml((JSONObject)JSONObject.parseObject((String)val), (String)(gt + "\t")));
                    xmlStr.append(gt);
                    xmlStr.append("</");
                    xmlStr.append(key);
                    xmlStr.append(">\n");
                    continue;
                }
                if (val.charAt(0) == '[') {
                    xmlStr.append(gt);
                    xmlStr.append("<");
                    xmlStr.append(key);
                    xmlStr.append(">\n");
                    JSONArray ja = JSONArray.parseArray((String)val);
                    for (int i = 0; i < ja.size(); ++i) {
                        JSONObject jo2 = new JSONObject();
                        jo2.put("object", (Object)ja.getJSONObject(i));
                        xmlStr.append(OnvifUtils.jsontoxml((JSONObject)jo2, (String)(gt + "\t")));
                    }
                    xmlStr.append(gt);
                    xmlStr.append("</");
                    xmlStr.append(key);
                    xmlStr.append(">\n");
                    continue;
                }
                xmlStr.append(gt);
                xmlStr.append("<");
                xmlStr.append(key);
                xmlStr.append(">");
                xmlStr.append(val);
                xmlStr.append("</");
                xmlStr.append(key);
                xmlStr.append(">\n");
            }
        }
        catch (Exception e) {
            log.info("jo=" + jo);
            log.error("json to xml error", (Throwable)e);
            return "<error>1</error>";
        }
        return xmlStr.toString();
    }

    public static String getPostStringByVcmInfo(String fileName, VcmReqBaseInfo vcmReqBaseInfo, String ... params) {
        String postString = "";
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/" + fileName);
            byte[] postData = new byte[is.available()];
            if (is.read(postData) > 0) {
                postString = new String(postData, "utf-8");
            }
            ArrayList<String> listParams = new ArrayList<String>();
            if (postString.contains("Header")) {
                String timestamp = OnvifUtils.getUTCTime();
                String nonce = String.valueOf(System.currentTimeMillis());
                listParams.add(vcmReqBaseInfo.getSdcUserName());
                listParams.add(OnvifUtils.encryptPassword((String)vcmReqBaseInfo.getSdcPassword(), (String)nonce, (String)timestamp));
                listParams.add(Base64.getEncoder().encodeToString(nonce.getBytes()));
                listParams.add(timestamp);
            }
            if (params.length > 0) {
                listParams.addAll(Arrays.asList(params));
            }
            postString = String.format(postString, listParams.toArray());
        }
        catch (IOException e) {
            log.error("get post string by vcm error", (Throwable)e);
        }
        return postString;
    }

    public static String getPostStringByFileName(String fileName, String ... params) {
        String postString = "";
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/" + fileName);
            byte[] postData = new byte[is.available()];
            if (is.read(postData) > 0) {
                postString = new String(postData, "utf-8");
            }
        }
        catch (IOException e) {
            log.error("get post string by vcm error", (Throwable)e);
        }
        return postString;
    }

    public static List<MediaProfile> getMediaProfiles(VcmReqBaseInfo vcmReqBaseInfo) throws SDKException {
        Device device = OnvifUtils.getDevice((String)vcmReqBaseInfo.getVcmSession());
        if (device == null) {
            throw new InvokeException("500", "cu_offline_error");
        }
        if (!CollectionUtils.isEmpty((Collection)device.getProfiles())) {
            return device.getProfiles();
        }
        String result = OnvifUtils.getPostString((VcmReqBaseInfo)vcmReqBaseInfo, (String)device.getMediaUrl(), (String)"getProfiles.xml", (String[])new String[0]);
        List mediaProfiles = OnvifUtils.parseMediaProfiles((String)result);
        if (!CollectionUtils.isEmpty((Collection)mediaProfiles) && mediaProfiles.size() > 0) {
            device.setProfiles(mediaProfiles);
            OnvifUtils.setDevice((String)vcmReqBaseInfo.getVcmSession(), (Device)device);
        }
        return mediaProfiles;
    }

    public static String getPostString(VcmReqBaseInfo vcmInfo, String url, String fileName, String ... params) throws SDKException {
        String ret;
        block2: {
            String xml = OnvifUtils.getPostStringByVcmInfo((String)fileName, (VcmReqBaseInfo)vcmInfo, (String[])params);
            vcmInfo.setVcmIp(url);
            ret = "";
            try {
                ret = (String)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)OnvifMsgType.DEVICE_EMPTY, (ObjectToMsgConvertor)new ObjectToXmlMsgConvertor((Object)xml), (MsgToObjectConvertor)new XmlMsgToObjectConvertor(String.class), (List)OnvifUtils.getHeaders((VcmReqBaseInfo)vcmInfo));
            }
            catch (SDKException e) {
                int code = Integer.parseInt(e.getErrorCode());
                xml = OnvifUtils.removeHeader((String)xml);
                if (401 != code && 400 != code) break block2;
                ret = (String)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)OnvifMsgType.DEVICE_EMPTY, (ObjectToMsgConvertor)new ObjectToXmlMsgConvertor((Object)xml), (MsgToObjectConvertor)new XmlMsgToObjectConvertor(String.class), (List)OnvifUtils.getHeaders((VcmReqBaseInfo)vcmInfo));
            }
        }
        return ret;
    }

    private static List<Header> getHeaders(VcmReqBaseInfo vcmInfo) {
        ArrayList<Header> headers = new ArrayList<Header>();
        OnvifUtils.addOtherHeaders((VcmReqBaseInfo)vcmInfo, headers);
        return headers;
    }

    private static void addOtherHeaders(VcmReqBaseInfo vcmInfo, List<Header> headers) {
        if (null != vcmInfo.getHeaders() && !vcmInfo.getHeaders().isEmpty()) {
            for (VcmReqBaseInfo.Header header : vcmInfo.getHeaders()) {
                headers.add((Header)new BasicHeader(header.getKey(), (Object)header.getValue()));
            }
        }
    }

    public static String removeHeader(String xmlString) {
        String result = xmlString;
        try {
            String[] headerPatterns = new String[]{"<s:Header>", "</s:Header>", "<SOAP-ENV:Header>", "</SOAP-ENV:Header>"};
            for (int i = 0; i < headerPatterns.length; i += 2) {
                int headerStartIndex = xmlString.indexOf(headerPatterns[i]);
                int headerEndIndex = xmlString.indexOf(headerPatterns[i + 1]) + headerPatterns[i + 1].length();
                if (headerStartIndex == -1 || headerEndIndex == -1) continue;
                String beforeHeader = xmlString.substring(0, headerStartIndex);
                String afterHeader = xmlString.substring(headerEndIndex);
                result = beforeHeader + afterHeader;
                break;
            }
        }
        catch (Exception e) {
            log.error("removeHeader error", (Throwable)e);
        }
        return result;
    }

    public static String getUTCTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-d'T'HH:mm:ss'Z'");
        sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        String utcTime = sdf.format(cal.getTime());
        return utcTime;
    }

    public static String encryptPassword(String password, String nonce, String timestamp) {
        byte[] encryptedRaw;
        String beforeEncryption = nonce + timestamp + password;
        try {
            encryptedRaw = OnvifUtils.sha1((String)beforeEncryption);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("encryptPassword error", (Throwable)e);
            return password;
        }
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])encryptedRaw);
    }

    private static byte[] sha1(String s) throws NoSuchAlgorithmException {
        MessageDigest SHA1 = MessageDigest.getInstance("SHA-1");
        SHA1.reset();
        SHA1.update(s.getBytes());
        return SHA1.digest();
    }

    public static String getStreamUri(String result) {
        JSONObject rootObject = OnvifUtils.xml2Json((String)result);
        JSONObject bodyObject = rootObject.getJSONObject("Body");
        if (bodyObject == null) {
            return null;
        }
        JSONObject streamResponseObject = bodyObject.getJSONObject("GetStreamUriResponse");
        if (streamResponseObject == null) {
            return null;
        }
        JSONObject mediaUriObject = streamResponseObject.getJSONObject("MediaUri");
        if (mediaUriObject == null) {
            return null;
        }
        return mediaUriObject.getJSONObject("Uri").getString("Uri");
    }

    public static List<MediaProfile> parseMediaProfiles(String result) {
        JSONObject json = OnvifUtils.xml2Json((String)result);
        log.info("token analysis json ==" + json.toJSONString());
        ArrayList<MediaProfile> mediaProfiles = new ArrayList<MediaProfile>();
        if (Objects.nonNull(json)) {
            JSONObject body = json.getJSONObject("Body");
            JSONObject response = body.getJSONObject("GetProfilesResponse");
            JSONArray jsonArray = response.getJSONArray("Profiles");
            for (int i = 0; i < jsonArray.size(); ++i) {
                MediaProfile mediaProfile = new MediaProfile();
                JSONObject profile = jsonArray.getJSONObject(i);
                if (Objects.isNull(profile.getJSONObject("VideoSourceConfiguration"))) continue;
                String token = profile.getString("@token");
                mediaProfile.setName(profile.getString("Name"));
                mediaProfile.setToken(token);
                mediaProfile.setVideoSourceToken(profile.getJSONObject("VideoSourceConfiguration").getJSONObject("SourceToken").getString("SourceToken"));
                mediaProfile.getVideSource().setVideoSourceToken(profile.getJSONObject("VideoSourceConfiguration").getJSONObject("SourceToken").getString("SourceToken"));
                mediaProfiles.add(mediaProfile);
            }
        }
        return mediaProfiles;
    }

    public static String download(String urlString) {
        String base64 = "";
        try {
            URL url = new URL(urlString);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(5000);
            InputStream inputStream = connection.getInputStream();
            base64 = OnvifUtils.inputStream2Base64((InputStream)inputStream);
            inputStream.close();
        }
        catch (Exception e) {
            log.error("download pic error", (Throwable)e);
        }
        return base64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStream2Base64(InputStream is) throws Exception {
        byte[] data = null;
        try {
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = is.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            data = swapStream.toByteArray();
        }
        catch (IOException e) {
            log.error("inputStream2Base64  error", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("\u8f93\u5165\u6d41\u5173\u95ed\u5f02\u5e38");
                }
            }
        }
        return Base64.getEncoder().encodeToString(data);
    }

    public static boolean isImageURL(String url) {
        return url.endsWith(".jpg") || url.endsWith(".jpeg") || url.endsWith(".png") || url.endsWith(".bmp");
    }

    public static void setDevice(String key, Device device) {
        DEVICE_MAP.put(key, device);
    }

    public static Device getDevice(String key) {
        return (Device)DEVICE_MAP.get(key);
    }

    public static void delDevice(String key) {
        DEVICE_MAP.remove(key);
    }

    public static String getCallBackUrl(VcmReqBaseInfo vcmReqBaseInfo) {
        String template = "%s://%s:%s/rest/ics/v1/zk/callback/onvif/";
        String ip = ConfigHolder.getIpByParentDeviceId((String)vcmReqBaseInfo.getParentDeviceId());
        if (StringUtils.isBlank((CharSequence)ip)) {
            ip = ConfigHolder.getIp();
        }
        String[] ips = ip.split("_");
        String callbackUrl = String.format(template, ConfigHolder.getHttpSchema(), "192.168.0.111", ConfigHolder.getPort());
        return callbackUrl + vcmReqBaseInfo.getDomainCode();
    }
}

