/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.DateTimeRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.DeviceInfoConfigNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.SpringContextUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Nvr800Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Nvr800Utils.class);
    private static final Map<String, String> AI_ALARM_CODE_MAP = new HashMap();
    public static List<String> AI_SNAPSHOT_LIST = new ArrayList();
    public static List<String> NVR_NOT_SUPPORT_ALARM = new ArrayList();
    public static String CU_FACE_REPOSITORY_NOT_EXIST;
    public static String CU_FACE_NOT_EXIST;
    private static final Map<Integer, String> NVR800_CODE_MAP;

    public static String getAiCode(String code) {
        return (String)AI_ALARM_CODE_MAP.get(code);
    }

    public static String getConnectStatus(String connectStatus) {
        if ("Online".equals(connectStatus)) {
            return "ALARM_CHANNEL_ONLINE";
        }
        return "ALARM_CHANNEL_OFFLINE";
    }

    public static boolean isBehavior(String code) {
        return DeviceUtil.BEHAVIOR_ALARM_CODE_LIST.contains(code);
    }

    public static Date convertToUTCTime(VcmReqBaseInfo vcmReqBaseInfo, Date date) {
        String timeZone = Nvr800Utils.getTimeZone((VcmReqBaseInfo)vcmReqBaseInfo);
        if (StringUtils.isBlank((CharSequence)timeZone)) {
            return date;
        }
        return Nvr800Utils.convertToUTCTime((Date)date, (String)timeZone);
    }

    public static Date convertToUTCTime(Date date, String timeZone) {
        timeZone = timeZone.replace("GMT", "");
        String addOrSub = timeZone.substring(0, 1);
        String[] array = timeZone.substring(1).split(":");
        int minutes = Integer.parseInt(array[0]) * 60 + Integer.parseInt(array[1]);
        if ("-".equals(addOrSub)) {
            return DateUtils.addMinutes((Date)date, (int)minutes);
        }
        return DateUtils.addMinutes((Date)date, (int)(minutes * -1));
    }

    public static String getTimeZone(VcmReqBaseInfo vcmReqBaseInfo) {
        DeviceInfoConfigNvr800ServiceImpl deviceInfoConfigNvr800Service = (DeviceInfoConfigNvr800ServiceImpl)SpringContextUtil.getBean((String)"deviceInfoConfigNvr800Service");
        ParamBean paramBean = new ParamBean();
        paramBean.setVcmInfo(vcmReqBaseInfo);
        paramBean.setRequestBody((Object)new EmptyRequest());
        DateTimeRespond dateTimeRespond = deviceInfoConfigNvr800Service.getTimeConfig(paramBean);
        return dateTimeRespond.getTimeZone();
    }

    public static boolean isSnapshot(String code) {
        return AI_SNAPSHOT_LIST.contains(code);
    }

    public static String getAlarmTypeByAlarmFlags(Integer alarmFlags) {
        String alarmType = "";
        if (Objects.isNull(alarmFlags)) {
            return alarmType;
        }
        String binary = String.format("%5s", Integer.toBinaryString(alarmFlags)).replaceAll(" ", "0");
        StringBuilder typeBuilder = new StringBuilder(binary).reverse();
        if (typeBuilder.charAt(2) == '1') {
            alarmType = alarmType + "ALARM_FACE_MASK" + ",";
        }
        if (typeBuilder.charAt(3) == '1' || typeBuilder.charAt(4) == '1') {
            alarmType = alarmType + "REPEAT_VISITOR" + ",";
        }
        return StringUtils.isNotBlank((CharSequence)alarmType) ? alarmType.substring(0, alarmType.length() - 1) : "";
    }

    public static int getAlarmType(String alarmCode) {
        ArrayList<String> alarmCodeList = new ArrayList<String>();
        alarmCodeList.add("ALARM_TRIP_LINE");
        alarmCodeList.add("ALARM_INTRUSION");
        alarmCodeList.add("ALARM_OBJECT_WANDER");
        alarmCodeList.add("ALARM_ENTER");
        alarmCodeList.add("ALARM_EXIT");
        alarmCodeList.add("ALARM_FASTMOVE");
        alarmCodeList.add("Face_Black");
        alarmCodeList.add("Face_White");
        alarmCodeList.add("Vehicle_Black");
        alarmCodeList.add("Vehicle_White");
        if (alarmCodeList.contains(alarmCode)) {
            return 1;
        }
        return 0;
    }

    public static String reasonHelper(SDKException e) {
        if ("503".equals(e.getErrorCode())) {
            return "server_rejected";
        }
        if ("413".equals(e.getErrorCode())) {
            return "payload_too_large";
        }
        if (StringUtils.isEmpty((CharSequence)e.getMessage()) || "-1002".equals(e.getErrorCode())) {
            return "cu_device_not_return";
        }
        if ("-1001".equals(e.getErrorCode())) {
            return "cu_connect_timeout";
        }
        try {
            JSONObject dataObject;
            String result;
            JSONArray jsonArray;
            JSONObject message = JSONObject.parseObject((String)e.getMessage());
            if (message.containsKey((Object)"ch_error_code") && (jsonArray = message.getJSONArray("ch_error_code")) != null && jsonArray.size() > 0) {
                return jsonArray.getJSONObject(0).getString("error_code");
            }
            if (message.containsKey((Object)"data") && StringUtils.isNotEmpty((CharSequence)(result = (dataObject = message.getJSONObject("data")).get((Object)"Result") instanceof JSONArray ? dataObject.getJSONArray("Result").get(0).toString() : dataObject.getString("Result")))) {
                return result;
            }
            String reason = (String)message.get((Object)"error_code");
            if (StringUtils.isBlank((CharSequence)reason)) {
                return "unknown_error";
            }
            return reason;
        }
        catch (Exception exception) {
            LOGGER.info("reason util error data:{}", (Object)e.getMessage());
            LOGGER.error("reason util error", (Throwable)exception);
            return "unknown_error";
        }
    }

    public static String getSingleAlarmCode(Integer recordType) {
        String binary = Integer.toBinaryString(recordType);
        StringBuilder type = new StringBuilder(binary = String.format("%32s", binary).replaceAll(" ", "0")).reverse();
        if (type.charAt(2) == '1') {
            return "ALARM_TYPE_MOVE_DECTION";
        }
        if (type.charAt(3) == '1') {
            return "ALARM_TYPE_DI";
        }
        if (type.charAt(4) == '1') {
            return "ALARM_TRIP_LINE";
        }
        if (type.charAt(9) == '1') {
            return "ALARM_INTRUSION";
        }
        if (type.charAt(11) == '1') {
            return "ALARM_HUMAN_COUNT";
        }
        if (type.charAt(12) == '1') {
            return "ALARM_ENTER";
        }
        if (type.charAt(13) == '1') {
            return "ALARM_EXIT";
        }
        if (type.charAt(14) == '1') {
            return "ALARM_FASTMOVE";
        }
        if (type.charAt(15) == '1') {
            return "ALARM_OBJECT_WANDER";
        }
        if (type.charAt(19) == '1') {
            return "ALARM_QUEUE_DETECT";
        }
        if (type.charAt(21) == '1') {
            return "ALARM_CROWD_DENSITY_DETECT";
        }
        if (type.charAt(22) == '1') {
            return "ALARM_FACE_MASK";
        }
        if (type.charAt(23) == '1') {
            return "ALARM_THIRD_ALGORITHM";
        }
        if (type.charAt(24) == '1') {
            return "ALARM_VE_ILLEGAL_PARKING";
        }
        if (type.charAt(25) == '1') {
            return "REPEAT_VISITOR";
        }
        if (type.charAt(26) == '1') {
            return "ALARM_OBJECT_ABANDONED";
        }
        if (type.charAt(28) == '1') {
            return "ALARM_ELE_BICYCLE";
        }
        if (type.charAt(29) == '1') {
            return "ALARM_PERSON_LEAVE_DETECT";
        }
        return "";
    }

    public static String getMouthMaskType(int type) {
        if (type == 1) {
            return "2";
        }
        if (type == 2) {
            return "1";
        }
        return "0";
    }

    public static String get(int code) {
        String result = (String)NVR800_CODE_MAP.get(code);
        return StringUtils.isNotEmpty((CharSequence)result) ? result : String.valueOf(code);
    }

    public static String plateColorConvertToIvs1800(String plateColor) {
        String rs;
        switch (plateColor) {
            case "2": {
                rs = "2";
                break;
            }
            case "5": {
                rs = "5";
                break;
            }
            case "1": {
                rs = "6";
                break;
            }
            case "4": {
                rs = "8";
                break;
            }
            case "0": {
                rs = "9";
                break;
            }
            case "6": {
                rs = "10";
                break;
            }
            case "7": {
                rs = "11";
                break;
            }
            case "9": {
                rs = "17";
                break;
            }
            case "11": {
                rs = "18";
                break;
            }
            case "12": {
                rs = "19";
                break;
            }
            case "13": {
                rs = "20";
                break;
            }
            case "14": {
                rs = "21";
                break;
            }
            case "8": {
                rs = "22";
                break;
            }
            case "10": {
                rs = "23";
                break;
            }
            case "15": {
                rs = "24";
                break;
            }
            default: {
                rs = "0";
            }
        }
        return rs;
    }

    public static String plateTypeConvertToIvs1800(String plateType) {
        String rs;
        switch (plateType) {
            case "16": {
                rs = "7";
                break;
            }
            case "12": {
                rs = "11";
                break;
            }
            case "14": {
                rs = "12";
                break;
            }
            case "15": {
                rs = "14";
                break;
            }
            case "7": {
                rs = "15";
                break;
            }
            case "18": {
                rs = "16";
                break;
            }
            case "19": {
                rs = "18";
                break;
            }
            default: {
                rs = plateType;
            }
        }
        return rs;
    }

    public static String vehicleColorConvertToIvs1800(String carColor) {
        String rs;
        switch (carColor) {
            case "1": {
                rs = "0";
                break;
            }
            case "2": {
                rs = "1";
                break;
            }
            case "3": {
                rs = "2";
                break;
            }
            case "4": {
                rs = "3";
                break;
            }
            case "5": {
                rs = "4";
                break;
            }
            case "6": {
                rs = "5";
                break;
            }
            case "7": {
                rs = "6";
                break;
            }
            case "8": {
                rs = "7";
                break;
            }
            case "9": {
                rs = "8";
                break;
            }
            case "0": {
                rs = "9";
                break;
            }
            case "10": {
                rs = "10";
                break;
            }
            case "11": {
                rs = "11";
                break;
            }
            case "14": {
                rs = "12";
                break;
            }
            case "12": {
                rs = "13";
                break;
            }
            case "13": {
                rs = "14";
                break;
            }
            default: {
                rs = carColor;
            }
        }
        return rs;
    }

    static {
        AI_ALARM_CODE_MAP.put("Lens", "ALARM_SHIELD");
        AI_ALARM_CODE_MAP.put("Sound", "ALARM_Sound");
        AI_ALARM_CODE_MAP.put("Mask", "ALARM_FACE_MASK");
        AI_ALARM_CODE_MAP.put("Queue", "ALARM_QUEUE_DETECT");
        AI_ALARM_CODE_MAP.put("People Density", "ALARM_CROWD_DENSITY_DETECT");
        AI_ALARM_CODE_MAP.put("People Count", "ALARM_HUMAN_COUNT");
        AI_ALARM_CODE_MAP.put("Over Line", "ALARM_TRIP_LINE");
        AI_ALARM_CODE_MAP.put("Region Invasion", "ALARM_INTRUSION");
        AI_ALARM_CODE_MAP.put("Region In", "ALARM_ENTER");
        AI_ALARM_CODE_MAP.put("Region Out", "ALARM_EXIT");
        AI_ALARM_CODE_MAP.put("Fast Move", "ALARM_FASTMOVE");
        AI_ALARM_CODE_MAP.put("Linger", "ALARM_OBJECT_WANDER");
        AI_ALARM_CODE_MAP.put("Third Part Alog", "ALARM_THIRD_ALGORITHM");
        AI_ALARM_CODE_MAP.put("Item Leave", "ALARM_OBJECT_ABANDONED");
        AI_ALARM_CODE_MAP.put("Item Move", "ALARM_OBJECT_REMOVAL");
        AI_ALARM_CODE_MAP.put("Electromobile", "ALARM_ELE_BICYCLE");
        AI_ALARM_CODE_MAP.put("Illegalp Parking", "ALARM_VE_ILLEGAL_PARKING");
        AI_ALARM_CODE_MAP.put("cross_counting", "ALARM_HUMAN_COUNT");
        AI_ALARM_CODE_MAP.put("queue_length", "ALARM_QUEUE_DETECT");
        AI_ALARM_CODE_MAP.put("crowd_density", "ALARM_CROWD_DENSITY_DETECT");
        AI_ALARM_CODE_MAP.put("Leave_detect", "ALARM_PERSON_LEAVE_DETECT");
        AI_ALARM_CODE_MAP.put("Lift_Electromobile", "ALARM_LIFT_ELE_BICYCLE");
        AI_ALARM_CODE_MAP.put("Parking Detection", "ALARM_CAR_DETECTION");
        AI_SNAPSHOT_LIST.add("Mask");
        AI_SNAPSHOT_LIST.add("Lens");
        AI_SNAPSHOT_LIST.add("Sound");
        AI_SNAPSHOT_LIST.add("Third Part Alog");
        AI_SNAPSHOT_LIST.add("People Density");
        AI_SNAPSHOT_LIST.add("People Count");
        AI_SNAPSHOT_LIST.add("Queue");
        AI_SNAPSHOT_LIST.add("cross_counting");
        AI_SNAPSHOT_LIST.add("queue_length");
        AI_SNAPSHOT_LIST.add("crowd_density");
        AI_SNAPSHOT_LIST.add("ALARM_FACE_DETECTION");
        NVR_NOT_SUPPORT_ALARM.add("ALARM_CROWD_ANALYSIS");
        NVR_NOT_SUPPORT_ALARM.add("ALARM_NO_SIGNAL");
        CU_FACE_REPOSITORY_NOT_EXIST = "CU_FACE_REPOSITORY_NOT_EXIST";
        CU_FACE_NOT_EXIST = "CU_FACE_NOT_EXIST";
        NVR800_CODE_MAP = new HashMap();
        NVR800_CODE_MAP.put(-1, "AORT_NO_DB");
        NVR800_CODE_MAP.put(-2, "AORT_DB_EXEC_FAILED");
        NVR800_CODE_MAP.put(-3, "AORT_CALC_FEATURE_FAILED");
        NVR800_CODE_MAP.put(-4, "AORT_CANCELED");
        NVR800_CODE_MAP.put(-5, "AORT_NO_DISK");
        NVR800_CODE_MAP.put(-6, "AORT_DISK_ERROR");
        NVR800_CODE_MAP.put(-7, "AORT_EXIST");
        NVR800_CODE_MAP.put(-8, "AORT_GROUP_INVALID");
        NVR800_CODE_MAP.put(-9, "AORT_NOT_EXIST");
        NVR800_CODE_MAP.put(-10, "AORT_MORE_FILE_EXIST");
        NVR800_CODE_MAP.put(-11, "AORT_SEARCH_ERROR");
        NVR800_CODE_MAP.put(-12, "AORT_OVER_MAX_COUNT");
        NVR800_CODE_MAP.put(-13, "AORT_UPDATING_FEATURE");
        NVR800_CODE_MAP.put(-14, "AORT_NO_USABLE_IPC");
        NVR800_CODE_MAP.put(-15, "AORT_INVALID_PARAM");
        NVR800_CODE_MAP.put(-16, "AORT_INVALID_FORMAT");
        NVR800_CODE_MAP.put(-17, "AORT_INVALID_RES");
        NVR800_CODE_MAP.put(-18, "AORT_INVALID_MEM");
        NVR800_CODE_MAP.put(-19, "AORT_CREAT_FAILED");
        NVR800_CODE_MAP.put(-20, "AORT_MD5_NOT_MATCH");
        NVR800_CODE_MAP.put(-21, "AORT_POS_ERROR");
        NVR800_CODE_MAP.put(-22, "AORT_SIZE_ERROR");
        NVR800_CODE_MAP.put(-23, "AORT_NOT_READY");
        NVR800_CODE_MAP.put(-24, "AORT_INVALID_DB");
        NVR800_CODE_MAP.put(-25, "AORT_GRP_INVALID_OR_INTERNAL");
        NVR800_CODE_MAP.put(-26, "AORT_GRP_FACE_OVER_MAX");
        NVR800_CODE_MAP.put(-27, "AORT_NO_PERMISSION");
        NVR800_CODE_MAP.put(-31, "AORT_FACE_NAME_NULL");
    }
}

