/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XMLConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.JAXBException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class JsonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);

    public static <T> String convertBeanToJSON(T object) {
        return JSONObject.toJSONString(object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static <T> Optional<T> convertJsonToBean(String json, Class<T> beanClass) {
        try {
            return Optional.of(JSON.parseObject((String)json, beanClass));
        }
        catch (JSONException e) {
            LOGGER.error("convertJsonToBean happen exception, {} ", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static <T> Optional<T> convertOrderJsonToBean(String json, Class<T> beanClass) {
        try {
            return Optional.of(JSON.parseObject((String)json, beanClass, (Feature[])new Feature[]{Feature.OrderedField}));
        }
        catch (JSONException e) {
            LOGGER.error("convertJsonToBean happen exception, {} ", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static <T> Optional<T> convertXMLToBean(String xmlStr, Class<T> beanClass) {
        try {
            if ("java.lang.String".equals(beanClass.getName())) {
                return Optional.of(xmlStr);
            }
            return Optional.ofNullable(XMLConvertor.convertXMLToBean((String)xmlStr, beanClass));
        }
        catch (JAXBException e) {
            LOGGER.error("convertXMLToBean happen exception, {} ", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static String xmlToJson(String xmlStr) {
        try {
            Document doc = DocumentHelper.parseText((String)xmlStr);
            JSONObject jsonObject = JsonUtil.xmlToJsonRoot((Document)doc);
            return jsonObject.toJSONString();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONObject xmlToJsonRoot(Document document) {
        Element root = document.getRootElement();
        List elements = root.elements();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(root.getName(), JsonUtil.elementToJson((List)elements));
        return jsonObject;
    }

    public static Object elementToJson(List<Element> elements) {
        Object object = null;
        if (elements.isEmpty()) {
            return object;
        }
        if (elements.size() == 1) {
            JSONObject jsonObject = new JSONObject();
            Element element = elements.get(0);
            List children = element.elements();
            if (!children.isEmpty()) {
                jsonObject.put(element.getName(), JsonUtil.elementToJson((List)children));
            } else {
                jsonObject.put(element.getName(), (Object)element.getText());
            }
            object = jsonObject;
            return object;
        }
        if (!elements.get(0).getName().equals(elements.get(1).getName())) {
            JSONObject jsonObject = new JSONObject();
            for (Element element : elements) {
                List children = element.elements();
                if (!children.isEmpty()) {
                    jsonObject.put(element.getName(), JsonUtil.elementToJson((List)children));
                    continue;
                }
                jsonObject.put(element.getName(), (Object)element.getText());
            }
            object = jsonObject;
            return object;
        }
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (Element element : elements) {
            JSONObject jsonObject = new JSONObject();
            List children = element.elements();
            if (!children.isEmpty()) {
                jsonObject = (JSONObject)JsonUtil.elementToJson((List)children);
            } else {
                jsonObject.put(element.getName(), (Object)element.getText());
            }
            jsonList.add(jsonObject);
        }
        object = jsonList;
        return object;
    }
}

