/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.AlarmCallbackRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.utils.EventNameHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ivs1800Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ivs1800Utils.class);
    private static final Map<String, String> AI_EVENT_MAP = new HashMap();
    public static List<String> AI_SNAPSHOT_LIST = new ArrayList();
    public static final String DEFAULT_CRUISE_NAME = "defaultCruise";
    public static String CU_ALLOWED_SUBSCRIBE_CAMERA_NOT_EXIST;

    public static String getEventName(JSONObject obj) {
        String type = obj.getString("alarmType");
        return EventNameHelper.getEventName((String)type);
    }

    public static String getCameraType(int type) {
        String strType;
        switch (type) {
            case 0: {
                strType = "FIX";
                break;
            }
            case 1: {
                strType = "PTZ";
                break;
            }
            case 2: {
                strType = "DOME";
                break;
            }
            case 6: {
                strType = "DOME";
                break;
            }
            case 3: {
                strType = "HALFDOME";
                break;
            }
            case 4: {
                strType = "BULLET";
                break;
            }
            case 9999: {
                strType = "NVR800";
                break;
            }
            default: {
                LOGGER.warn("type maybe error type=" + type);
                strType = "FIX";
            }
        }
        return strType;
    }

    public static String getEventName(AlarmCallbackRespondIvs1800 alarmCallbackRespondIvs1800) {
        return EventNameHelper.getEventName((String)alarmCallbackRespondIvs1800.getAlarmType());
    }

    public static String getEventCode(String code) {
        return (String)AI_EVENT_MAP.get(code);
    }

    public static String reasonHelper(SDKException e) {
        if ("502".equals(e.getErrorCode())) {
            return "cu_interface_502";
        }
        if ("503".equals(e.getErrorCode())) {
            return "cu_device_frequent_operation";
        }
        if ("400".equals(e.getErrorCode())) {
            return e.getErrorCode();
        }
        if ("-1002".equals(e.getErrorCode())) {
            return "cu_device_not_return";
        }
        if ("-1001".equals(e.getErrorCode())) {
            return "cu_connect_timeout";
        }
        if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
            return e.getErrorCode();
        }
        return e.getMessage();
    }

    public static String get(int code) {
        return String.valueOf(code);
    }

    static {
        AI_EVENT_MAP.put("2", "ALARM_FACE_RECOGNITION");
        AI_EVENT_MAP.put("3", "ALARM_FACE_RECOGNITION");
        AI_EVENT_MAP.put("501", "ALARM_VEHICLE_RECOGNITION");
        AI_EVENT_MAP.put("502", "ALARM_VEHICLE_RECOGNITION");
        AI_EVENT_MAP.put("701", "ALARM_BEHAVIOR_ANALYSIS_TRIPWIRE");
        AI_EVENT_MAP.put("708", "ALARM_BEHAVIOR_ANALYSIS_INVASION");
        AI_EVENT_MAP.put("715", "ALARM_BEHAVIOR_ANALYSIS_WANDER");
        AI_EVENT_MAP.put("733", "ALARM_BEHAVIOR_ANALYSIS_FASTMOVE");
        AI_EVENT_MAP.put("735", "ALARM_BEHAVIOR_ANALYSIS_ENTER");
        AI_EVENT_MAP.put("736", "ALARM_BEHAVIOR_ANALYSIS_EXIT");
        AI_EVENT_MAP.put("741", "ALARM_ELE_BICYCLE");
        AI_EVENT_MAP.put("ALARM_THIRD_ALGORITHM", "ALARM_THIRD_ALGORITHM");
        AI_SNAPSHOT_LIST.add("ALARM_TYPE_MOVE_DECTION");
        AI_SNAPSHOT_LIST.add("ALARM_FACE_DETECTION");
        AI_SNAPSHOT_LIST.add("ALARM_HUMAN_COUNT");
        AI_SNAPSHOT_LIST.add("ALARM_THIRD_ALGORITHM");
        AI_SNAPSHOT_LIST.add("ALARM_SHIELD");
        AI_SNAPSHOT_LIST.add("ALARM_CROWD_DENSITY_DETECT");
        AI_SNAPSHOT_LIST.add("ALARM_INTRUSION");
        AI_SNAPSHOT_LIST.add("ALARM_OBJECT_WANDER");
        AI_SNAPSHOT_LIST.add("ALARM_OBJECT_ABANDONED");
        AI_SNAPSHOT_LIST.add("ALARM_TRIP_LINE");
        AI_SNAPSHOT_LIST.add("ALARM_OBJECT_REMOVAL");
        AI_SNAPSHOT_LIST.add("Face_Temp");
        AI_SNAPSHOT_LIST.add("ALARM_QUEUE_DETECT");
        AI_SNAPSHOT_LIST.add("ALARM_ENTER");
        AI_SNAPSHOT_LIST.add("ALARM_EXIT");
        AI_SNAPSHOT_LIST.add("ALARM_FASTMOVE");
        CU_ALLOWED_SUBSCRIBE_CAMERA_NOT_EXIST = "CU_ALLOWED_SUBSCRIBE_CAMERA_NOT_EXIST";
    }
}

